/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.config.ConfigInstance;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.Derived;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.ComplexAttributeFieldUtils;
import com.yahoo.schema.document.GeoPos;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.ImportedComplexField;
import com.yahoo.schema.document.ImportedField;
import com.yahoo.vespa.config.search.ImportedFieldsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ImportedFields
extends Derived {
    private Optional<com.yahoo.schema.document.ImportedFields> importedFields = Optional.empty();

    public ImportedFields(Schema schema) {
        this.derive(schema);
    }

    @Override
    protected void derive(Schema schema) {
        this.importedFields = schema.importedFields();
    }

    @Override
    protected String getDerivedName() {
        return "imported-fields";
    }

    public void getConfig(ImportedFieldsConfig.Builder builder) {
        if (this.importedFields.isPresent()) {
            ArrayList imported = new ArrayList();
            this.importedFields.get().fields().forEach((name, field) -> ImportedFields.considerField(imported, field));
            builder.attribute(imported.stream().map(ImportedFields::createAttributeBuilder).toList());
        }
    }

    public void export(String toDirectory) throws IOException {
        ImportedFieldsConfig.Builder builder = new ImportedFieldsConfig.Builder();
        this.getConfig(builder);
        this.export(toDirectory, (ConfigInstance)builder.build());
    }

    private static boolean isNestedFieldName(String fieldName) {
        return fieldName.indexOf(46) != -1;
    }

    private static void considerField(List<ImportedField> importedFields, ImportedField field) {
        if (field instanceof ImportedComplexField) {
            ImportedFields.considerComplexField(importedFields, (ImportedComplexField)field);
        } else {
            ImportedFields.considerSimpleField(importedFields, field);
        }
    }

    private static void considerComplexField(List<ImportedField> importedFields, ImportedComplexField field) {
        ImmutableSDField targetField = field.targetField();
        if (!GeoPos.isAnyPos(targetField)) {
            if (ComplexAttributeFieldUtils.isArrayOfSimpleStruct(targetField)) {
                ImportedFields.considerNestedFields(importedFields, field);
            } else if (ComplexAttributeFieldUtils.isMapOfSimpleStruct(targetField)) {
                ImportedFields.considerSimpleField(importedFields, field.getNestedField("key"));
                ImportedFields.considerNestedFields(importedFields, field.getNestedField("value"));
            } else if (ComplexAttributeFieldUtils.isMapOfPrimitiveType(targetField)) {
                ImportedFields.considerSimpleField(importedFields, field.getNestedField("key"));
                ImportedFields.considerSimpleField(importedFields, field.getNestedField("value"));
            }
        }
    }

    private static void considerNestedFields(List<ImportedField> importedFields, ImportedField field) {
        if (field instanceof ImportedComplexField) {
            ImportedComplexField complexField = (ImportedComplexField)field;
            complexField.getNestedFields().forEach(nestedField -> ImportedFields.considerSimpleField(importedFields, nestedField));
        }
    }

    private static void considerSimpleField(List<ImportedField> importedFields, ImportedField field) {
        ImmutableSDField targetField = field.targetField();
        String targetFieldName = targetField.getName();
        if (!ImportedFields.isNestedFieldName(targetFieldName)) {
            if (targetField.doesAttributing()) {
                importedFields.add(field);
            }
        } else {
            Attribute attribute = targetField.getAttribute();
            if (attribute != null) {
                importedFields.add(field);
            }
        }
    }

    private static ImportedFieldsConfig.Attribute.Builder createAttributeBuilder(ImportedField field) {
        ImportedFieldsConfig.Attribute.Builder result = new ImportedFieldsConfig.Attribute.Builder();
        result.name(field.fieldName());
        result.referencefield(field.reference().referenceField().getName());
        result.targetfield(field.targetField().getName());
        return result;
    }
}

