/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.schema.parser.ParsedBlock;
import com.yahoo.schema.parser.ParsedSorting;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ParsedAttribute
extends ParsedBlock {
    private boolean enableOnlyBitVector = false;
    private boolean enableFastAccess = false;
    private boolean enableFastRank = false;
    private boolean enableFastSearch = false;
    private boolean enableMutable = false;
    private boolean enablePaged = false;
    private final Map<String, String> aliases = new LinkedHashMap<String, String>();
    private ParsedSorting sortSettings = null;
    private String distanceMetric = null;

    public ParsedAttribute(String name) {
        super(name, "attribute");
    }

    List<String> getAliases() {
        return List.copyOf(this.aliases.keySet());
    }

    String lookupAliasedFrom(String alias) {
        return this.aliases.get(alias);
    }

    Optional<String> getDistanceMetric() {
        return Optional.ofNullable(this.distanceMetric);
    }

    boolean getEnableOnlyBitVector() {
        return this.enableOnlyBitVector;
    }

    boolean getFastAccess() {
        return this.enableFastAccess;
    }

    boolean getFastRank() {
        return this.enableFastRank;
    }

    boolean getFastSearch() {
        return this.enableFastSearch;
    }

    boolean getMutable() {
        return this.enableMutable;
    }

    boolean getPaged() {
        return this.enablePaged;
    }

    Optional<ParsedSorting> getSorting() {
        return Optional.ofNullable(this.sortSettings);
    }

    public void addAlias(String from, String to) {
        this.verifyThat(!this.aliases.containsKey(to), "already has alias", to);
        this.aliases.put(to, from);
    }

    public void setDistanceMetric(String value) {
        this.verifyThat(this.distanceMetric == null, "already has distance-metric", this.distanceMetric);
        this.distanceMetric = value;
    }

    public ParsedSorting sortInfo() {
        if (this.sortSettings == null) {
            this.sortSettings = new ParsedSorting(this.name(), "attribute.sorting");
        }
        return this.sortSettings;
    }

    public void setEnableOnlyBitVector(boolean value) {
        this.enableOnlyBitVector = value;
    }

    public void setFastAccess(boolean value) {
        this.enableFastAccess = true;
    }

    public void setFastRank(boolean value) {
        this.enableFastRank = true;
    }

    public void setFastSearch(boolean value) {
        this.enableFastSearch = true;
    }

    public void setMutable(boolean value) {
        this.enableMutable = true;
    }

    public void setPaged(boolean value) {
        this.enablePaged = true;
    }
}

