/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import java.util.Objects;
import java.util.Optional;

public class TenantSecretStore {
    private final String name;
    private final String awsId;
    private final String role;
    private final Optional<String> externalId;

    public TenantSecretStore(String name, String awsId, String role) {
        this(name, awsId, role, Optional.empty());
    }

    public TenantSecretStore(String name, String awsId, String role, String externalId) {
        this(name, awsId, role, Optional.of(externalId));
    }

    public TenantSecretStore(String name, String awsId, String role, Optional<String> externalId) {
        this.name = name;
        this.awsId = awsId;
        this.role = role;
        this.externalId = externalId;
    }

    public String getName() {
        return this.name;
    }

    public String getAwsId() {
        return this.awsId;
    }

    public String getRole() {
        return this.role;
    }

    public Optional<String> getExternalId() {
        return this.externalId;
    }

    public TenantSecretStore withExternalId(String externalId) {
        return new TenantSecretStore(this.name, this.awsId, this.role, Optional.of(externalId));
    }

    public boolean isValid() {
        return !this.name.isBlank() && !this.awsId.isBlank() && !this.role.isBlank();
    }

    public String toString() {
        return "TenantSecretStore{name='" + this.name + "', awsId='" + this.awsId + "', role='" + this.role + "', externalId='" + this.externalId.orElse("<EMPTY>") + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantSecretStore that = (TenantSecretStore)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.awsId, that.awsId) && Objects.equals(this.role, that.role) && Objects.equals(this.externalId, that.externalId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.awsId, this.role, this.externalId);
    }
}

