/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.collections.Comparables;
import com.yahoo.config.application.api.Bcp;
import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.application.api.Endpoint;
import com.yahoo.config.application.api.TimeWindow;
import com.yahoo.config.application.api.xml.DeploymentSpecXmlReader;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.ZoneEndpoint;
import com.yahoo.config.provision.zone.ZoneId;
import java.io.Reader;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeploymentSpec {
    public static final DeploymentSpec empty = new DeploymentSpec(List.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), List.of(), "<deployment version='1.0'/>", List.of());
    private final List<Step> steps;
    private final Optional<Integer> majorVersion;
    private final Optional<AthenzDomain> athenzDomain;
    private final Optional<AthenzService> athenzService;
    private final Optional<CloudAccount> cloudAccount;
    private final List<Endpoint> endpoints;
    private final List<DeprecatedElement> deprecatedElements;
    private final String xmlForm;

    public DeploymentSpec(List<Step> steps, Optional<Integer> majorVersion, Optional<AthenzDomain> athenzDomain, Optional<AthenzService> athenzService, Optional<CloudAccount> cloudAccount, List<Endpoint> endpoints, String xmlForm, List<DeprecatedElement> deprecatedElements) {
        this.steps = List.copyOf((Collection)Objects.requireNonNull(steps));
        this.majorVersion = Objects.requireNonNull(majorVersion);
        this.athenzDomain = Objects.requireNonNull(athenzDomain);
        this.athenzService = Objects.requireNonNull(athenzService);
        this.cloudAccount = Objects.requireNonNull(cloudAccount);
        this.xmlForm = Objects.requireNonNull(xmlForm);
        this.endpoints = List.copyOf((Collection)Objects.requireNonNull(endpoints));
        this.deprecatedElements = List.copyOf((Collection)Objects.requireNonNull(deprecatedElements));
        this.validateTotalDelay(steps);
        this.validateUpgradePoliciesOfIncreasingConservativeness(steps);
        this.validateAthenz();
        this.validateApplicationEndpoints();
    }

    public boolean isEmpty() {
        return this == empty;
    }

    private void validateTotalDelay(List<Step> steps) {
        long totalDelaySeconds = steps.stream().mapToLong(step -> step.delay().getSeconds()).sum();
        if (totalDelaySeconds > Duration.ofHours(48L).getSeconds()) {
            DeploymentSpec.illegal("The total delay specified is " + Duration.ofSeconds(totalDelaySeconds) + " but max 48 hours is allowed");
        }
    }

    private void validateUpgradePoliciesOfIncreasingConservativeness(List<Step> steps) {
        UpgradePolicy previous = Collections.min(List.of(UpgradePolicy.values()));
        for (Step step : steps) {
            UpgradePolicy strictest = previous;
            List<DeploymentInstanceSpec> specs = DeploymentSpec.instances(List.of(step));
            for (DeploymentInstanceSpec spec : specs) {
                if (spec.upgradePolicy().compareTo(previous) < 0) {
                    DeploymentSpec.illegal("Instance '" + spec.name() + "' cannot have a looser upgrade policy than the previous of '" + previous + "'");
                }
                strictest = (UpgradePolicy)((Object)Comparables.max((Comparable)((Object)strictest), (Comparable)((Object)spec.upgradePolicy())));
            }
            previous = strictest;
        }
    }

    private void validateAthenz() {
        block5: {
            block4: {
                if (!this.athenzDomain.isEmpty()) break block4;
                for (DeploymentInstanceSpec instance : this.instances()) {
                    for (DeclaredZone zone : instance.zones()) {
                        if (!zone.athenzService().isPresent()) continue;
                        DeploymentSpec.illegal("Athenz service configured for zone: " + zone + ", but Athenz domain is not configured");
                    }
                }
                break block5;
            }
            if (!this.athenzService.isEmpty()) break block5;
            for (DeploymentInstanceSpec instance : this.instances()) {
                for (DeclaredZone zone : instance.zones()) {
                    if (!zone.athenzService().isEmpty()) continue;
                    DeploymentSpec.illegal("Athenz domain is configured, but Athenz service not configured for zone: " + zone);
                }
            }
        }
    }

    private void validateApplicationEndpoints() {
        for (Endpoint endpoint : this.endpoints) {
            if (endpoint.level() != Endpoint.Level.application) {
                DeploymentSpec.illegal("Endpoint '" + endpoint.endpointId() + "' must be an application\u2013level endpoint, got " + endpoint.level());
            }
            String prefix = "Application-level endpoint '" + endpoint.endpointId() + "': ";
            for (Endpoint.Target target : endpoint.targets()) {
                Optional<DeploymentInstanceSpec> instance = this.instance(target.instance());
                if (instance.isEmpty()) {
                    DeploymentSpec.illegal(prefix + "targets undeclared instance '" + target.instance() + "'");
                }
                if (!instance.get().deploysTo(Environment.prod, target.region())) {
                    DeploymentSpec.illegal(prefix + "targets undeclared region '" + target.region() + "' in instance '" + target.instance() + "'");
                }
                if (!instance.get().zoneEndpoint(ZoneId.from((Environment)Environment.prod, (RegionName)target.region()), ClusterSpec.Id.from((String)endpoint.containerId())).map(zoneEndpoint -> !zoneEndpoint.isPublicEndpoint()).orElse(false).booleanValue()) continue;
                DeploymentSpec.illegal(prefix + "targets '" + target.region().value() + "' in '" + target.instance().value() + "', but its zone endpoint has 'enabled' set to 'false'");
            }
        }
    }

    public Optional<Integer> majorVersion() {
        return this.majorVersion;
    }

    public List<Step> steps() {
        return this.steps;
    }

    public Optional<AthenzDomain> athenzDomain() {
        return this.athenzDomain;
    }

    public Optional<AthenzService> athenzService() {
        return this.athenzService;
    }

    public Optional<CloudAccount> cloudAccount() {
        return this.cloudAccount;
    }

    public ZoneEndpoint zoneEndpoint(InstanceName instance, ZoneId zone, ClusterSpec.Id cluster) {
        if (zone.environment().isTest() && this.instances().stream().anyMatch(spec -> spec.zoneEndpoints().getOrDefault(cluster, Map.of()).values().stream().anyMatch(endpoint -> !endpoint.isPublicEndpoint()))) {
            return ZoneEndpoint.privateEndpoint;
        }
        if (zone.environment() != Environment.prod) {
            return ZoneEndpoint.defaultEndpoint;
        }
        return this.instance(instance).flatMap(spec -> spec.zoneEndpoint(zone, cluster)).orElse(ZoneEndpoint.defaultEndpoint);
    }

    @Deprecated
    public Bcp bcp() {
        return Bcp.empty();
    }

    public String xmlForm() {
        return this.xmlForm;
    }

    public Optional<DeploymentInstanceSpec> instance(InstanceName name) {
        for (DeploymentInstanceSpec instance : this.instances()) {
            if (!instance.name().equals((Object)name)) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public DeploymentInstanceSpec requireInstance(String name) {
        return this.requireInstance(InstanceName.from((String)name));
    }

    public DeploymentInstanceSpec requireInstance(InstanceName name) {
        Optional<DeploymentInstanceSpec> instance = this.instance(name);
        if (instance.isEmpty()) {
            throw new IllegalArgumentException("No instance '" + name + "' in deployment.xml. Instances: " + this.instances().stream().map(spec -> spec.name().toString()).collect(Collectors.joining(",")));
        }
        return instance.get();
    }

    public List<InstanceName> instanceNames() {
        return this.instances().stream().map(DeploymentInstanceSpec::name).toList();
    }

    public List<DeploymentInstanceSpec> instances() {
        return DeploymentSpec.instances(this.steps);
    }

    public List<Endpoint> endpoints() {
        return this.endpoints;
    }

    public List<DeprecatedElement> deprecatedElements() {
        return this.deprecatedElements;
    }

    private static List<DeploymentInstanceSpec> instances(List<Step> steps) {
        return steps.stream().flatMap(DeploymentSpec::flatten).toList();
    }

    private static Stream<DeploymentInstanceSpec> flatten(Step step) {
        if (step instanceof DeploymentInstanceSpec) {
            return Stream.of((DeploymentInstanceSpec)step);
        }
        return step.steps().stream().flatMap(DeploymentSpec::flatten);
    }

    private static void illegal(String message) {
        throw new IllegalArgumentException(message);
    }

    public static DeploymentSpec fromXml(Reader reader) {
        return new DeploymentSpecXmlReader().read(reader);
    }

    public static DeploymentSpec fromXml(String xmlForm) {
        return DeploymentSpec.fromXml(xmlForm, true);
    }

    public static DeploymentSpec fromXml(String xmlForm, boolean validate) {
        return new DeploymentSpecXmlReader(validate).read(xmlForm);
    }

    public static String toMessageString(Throwable t) {
        StringBuilder b = new StringBuilder();
        String lastMessage = null;
        while (t != null) {
            String message = t.getMessage();
            if (message != null && !message.equals(lastMessage)) {
                if (b.length() > 0) {
                    b.append(": ");
                }
                b.append(message);
                lastMessage = message;
            }
            t = t.getCause();
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentSpec other = (DeploymentSpec)o;
        return this.majorVersion.equals(other.majorVersion) && this.steps.equals(other.steps) && this.xmlForm.equals(other.xmlForm);
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.steps, this.xmlForm);
    }

    public int deployableHashCode() {
        Object[] toHash = new Object[this.instances().size() + 4];
        int i = 0;
        toHash[i++] = this.majorVersion;
        toHash[i++] = this.athenzDomain;
        toHash[i++] = this.athenzService;
        toHash[i++] = this.endpoints;
        for (DeploymentInstanceSpec instance : this.instances()) {
            toHash[i++] = instance.deployableHashCode();
        }
        return Arrays.hashCode(toHash);
    }

    public static enum UpgradePolicy {
        canary,
        defaultPolicy,
        conservative;

    }

    public static abstract class Step {
        public final boolean concerns(Environment environment) {
            return this.concerns(environment, Optional.empty());
        }

        public abstract boolean concerns(Environment var1, Optional<RegionName> var2);

        public List<DeclaredZone> zones() {
            return Collections.emptyList();
        }

        public Duration delay() {
            return Duration.ZERO;
        }

        public List<Step> steps() {
            return List.of();
        }

        public boolean isTest() {
            return false;
        }

        public boolean isOrdered() {
            return true;
        }
    }

    public static class DeclaredZone
    extends Step {
        private final Environment environment;
        private final Optional<RegionName> region;
        private final boolean active;
        private final Optional<AthenzService> athenzService;
        private final Optional<String> testerFlavor;
        private final Optional<CloudAccount> cloudAccount;

        public DeclaredZone(Environment environment) {
            this(environment, Optional.empty(), false, Optional.empty(), Optional.empty(), Optional.empty());
        }

        public DeclaredZone(Environment environment, Optional<RegionName> region, boolean active, Optional<AthenzService> athenzService, Optional<String> testerFlavor, Optional<CloudAccount> cloudAccount) {
            if (environment != Environment.prod && region.isPresent()) {
                DeploymentSpec.illegal("Non-prod environments cannot specify a region");
            }
            if (environment == Environment.prod && region.isEmpty()) {
                DeploymentSpec.illegal("Prod environments must be specified with a region");
            }
            this.environment = Objects.requireNonNull(environment);
            this.region = Objects.requireNonNull(region);
            this.active = active;
            this.athenzService = Objects.requireNonNull(athenzService);
            this.testerFlavor = Objects.requireNonNull(testerFlavor);
            this.cloudAccount = Objects.requireNonNull(cloudAccount);
        }

        public Environment environment() {
            return this.environment;
        }

        public Optional<RegionName> region() {
            return this.region;
        }

        public boolean active() {
            return this.active;
        }

        public Optional<String> testerFlavor() {
            return this.testerFlavor;
        }

        public Optional<AthenzService> athenzService() {
            return this.athenzService;
        }

        public Optional<CloudAccount> cloudAccount() {
            return this.cloudAccount;
        }

        @Override
        public List<DeclaredZone> zones() {
            return List.of(this);
        }

        @Override
        public boolean concerns(Environment environment, Optional<RegionName> region) {
            if (environment != this.environment) {
                return false;
            }
            return !region.isPresent() || !this.region.isPresent() || region.equals(this.region);
        }

        @Override
        public boolean isTest() {
            return this.environment.isTest();
        }

        public int hashCode() {
            return Objects.hash(this.environment, this.region);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeclaredZone)) {
                return false;
            }
            DeclaredZone other = (DeclaredZone)o;
            if (this.environment != other.environment) {
                return false;
            }
            return this.region.equals(other.region());
        }

        public String toString() {
            return this.environment + this.region.map(regionName -> "." + regionName).orElse("");
        }
    }

    public static class DeprecatedElement {
        private final String tagName;
        private final List<String> attributes;
        private final String message;
        private final int majorVersion;

        public DeprecatedElement(int majorVersion, String tagName, List<String> attributes, String message) {
            this.tagName = Objects.requireNonNull(tagName);
            this.attributes = Objects.requireNonNull(attributes);
            this.message = Objects.requireNonNull(message);
            this.majorVersion = majorVersion;
            if (message.isBlank()) {
                throw new IllegalArgumentException("message must be non-empty");
            }
        }

        public int majorVersion() {
            return this.majorVersion;
        }

        public String humanReadableString() {
            String deprecationDescription = "deprecated since major version " + this.majorVersion;
            if (this.attributes.isEmpty()) {
                return "Element '" + this.tagName + "' is " + deprecationDescription + ". " + this.message;
            }
            return "Element '" + this.tagName + "' contains attribute" + (this.attributes.size() > 1 ? "s " : " ") + this.attributes.stream().map(attr -> "'" + attr + "'").collect(Collectors.joining(", ")) + " " + deprecationDescription + ". " + this.message;
        }

        public String toString() {
            return this.humanReadableString();
        }
    }

    public static class ChangeBlocker {
        private final boolean revision;
        private final boolean version;
        private final TimeWindow window;

        public ChangeBlocker(boolean revision, boolean version, TimeWindow window) {
            this.revision = revision;
            this.version = version;
            this.window = window;
        }

        public boolean blocksRevisions() {
            return this.revision;
        }

        public boolean blocksVersions() {
            return this.version;
        }

        public TimeWindow window() {
            return this.window;
        }

        public String toString() {
            return "change blocker revision=" + this.revision + " version=" + this.version + " window=" + this.window;
        }
    }

    public static enum UpgradeRollout {
        separate,
        leading,
        simultaneous;

    }

    public static enum RevisionChange {
        whenClear,
        whenFailing,
        always;

    }

    public static enum RevisionTarget {
        next,
        latest;

    }

    public static class ParallelSteps
    extends Steps {
        public ParallelSteps(List<Step> steps) {
            super(steps);
        }

        @Override
        public Duration delay() {
            return this.steps().stream().map(Step::delay).max(Comparator.naturalOrder()).orElse(Duration.ZERO);
        }

        @Override
        public boolean isOrdered() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParallelSteps)) {
                return false;
            }
            return Objects.equals(this.steps(), ((ParallelSteps)o).steps());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.steps());
        }

        @Override
        public String toString() {
            return this.steps().size() + " parallel steps";
        }
    }

    public static class Steps
    extends Step {
        private final List<Step> steps;

        public Steps(List<Step> steps) {
            this.steps = List.copyOf(steps);
        }

        @Override
        public List<DeclaredZone> zones() {
            return this.steps.stream().flatMap(step -> step.zones().stream()).toList();
        }

        @Override
        public List<Step> steps() {
            return this.steps;
        }

        @Override
        public boolean concerns(Environment environment, Optional<RegionName> region) {
            return this.steps.stream().anyMatch(step -> step.concerns(environment, region));
        }

        @Override
        public Duration delay() {
            return this.steps.stream().map(Step::delay).reduce(Duration.ZERO, Duration::plus);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.steps.equals(((Steps)o).steps);
        }

        public int hashCode() {
            return Objects.hash(this.steps);
        }

        public String toString() {
            return this.steps.size() + " steps";
        }
    }

    public static class DeclaredTest
    extends Step {
        private final RegionName region;

        public DeclaredTest(RegionName region) {
            this.region = Objects.requireNonNull(region);
        }

        @Override
        public boolean concerns(Environment environment, Optional<RegionName> region) {
            return region.map(arg_0 -> ((RegionName)this.region).equals(arg_0)).orElse(true) != false && environment == Environment.prod;
        }

        @Override
        public boolean isTest() {
            return true;
        }

        public RegionName region() {
            return this.region;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeclaredTest that = (DeclaredTest)o;
            return this.region.equals((Object)that.region);
        }

        public int hashCode() {
            return Objects.hash(this.region);
        }

        public String toString() {
            return "tests for prod." + this.region;
        }
    }

    public static class Delay
    extends Step {
        private final Duration duration;

        public Delay(Duration duration) {
            this.duration = duration;
        }

        @Override
        public Duration delay() {
            return this.duration;
        }

        @Override
        public boolean concerns(Environment environment, Optional<RegionName> region) {
            return false;
        }

        public String toString() {
            return "delay " + this.duration;
        }
    }
}

