/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.yahoo.collections.Tuple2;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.application.provider.AppSubDirs;
import com.yahoo.config.model.application.provider.SchemaValidator;
import com.yahoo.config.model.application.provider.SchemaValidators;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;

public class ApplicationPackageXmlFilesValidator {
    private final AppSubDirs appDirs;
    private final SchemaValidators validators;
    private static final FilenameFilter xmlFilter = (dir, name) -> name.endsWith(".xml");

    private ApplicationPackageXmlFilesValidator(AppSubDirs appDirs, Version vespaVersion) {
        this.appDirs = appDirs;
        this.validators = new SchemaValidators(vespaVersion);
    }

    public static ApplicationPackageXmlFilesValidator create(File appDir, Version vespaVersion) {
        return new ApplicationPackageXmlFilesValidator(new AppSubDirs(appDir), vespaVersion);
    }

    public void checkApplication() throws IOException {
        this.validateOptional(this.validators.applicationXmlValidator(), ApplicationPackage.APPLICATION_DEFINITION_FILE.getName());
        this.validateOptional(this.validators.servicesXmlValidator(), "services.xml");
        this.validateOptional(this.validators.hostsXmlValidator(), "hosts.xml");
        this.validateOptional(this.validators.deploymentXmlValidator(), ApplicationPackage.DEPLOYMENT_FILE.getName());
        this.validateOptional(this.validators.validationOverridesXmlValidator(), ApplicationPackage.VALIDATION_OVERRIDES.getName());
        this.validateRouting(this.appDirs.routingTables());
    }

    public void checkIncludedDirs(ApplicationPackage app) throws IOException {
        for (String includedDir : app.getUserIncludeDirs()) {
            List includedFiles = app.getFiles(Path.fromString((String)includedDir), ".xml", true);
            for (NamedReader file : includedFiles) {
                this.validators.containerIncludeXmlValidator().validate(file);
            }
        }
    }

    private void validateOptional(SchemaValidator validator, String file) throws IOException {
        if (!this.appDirs.file(file).exists()) {
            return;
        }
        this.validate(validator, file);
    }

    private void validate(SchemaValidator validator, String filename) throws IOException {
        validator.validate(this.appDirs.file(filename));
    }

    private void validateRouting(Tuple2<File, String> directory) throws IOException {
        if (!((File)directory.first).isDirectory()) {
            return;
        }
        this.validateRouting(this.validators.routingStandaloneXmlValidator(), directory);
    }

    private void validateRouting(SchemaValidator validator, Tuple2<File, String> directory) throws IOException {
        File dir = (File)directory.first;
        if (!dir.isDirectory()) {
            return;
        }
        String directoryName = (String)directory.second;
        for (File f : dir.listFiles(xmlFilter)) {
            if (f.isDirectory()) {
                this.validateRouting(validator, (Tuple2<File, String>)new Tuple2((Object)f, (Object)(directoryName + File.separator + f.getName())));
                continue;
            }
            validator.validate(f, directoryName + File.separator + f.getName());
        }
    }
}

