/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.application.provider;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaValidator {
    private static final int linesOfContextForErrors = 3;
    private final CustomErrorHandler errorHandler = new CustomErrorHandler();
    private final ValidationDriver driver;
    private final DeployLogger deployLogger;

    SchemaValidator(File schemaFile, DeployLogger deployLogger) throws IOException, SAXException {
        this.deployLogger = deployLogger;
        this.driver = new ValidationDriver(PropertyMap.EMPTY, this.instanceProperties(), CompactSchemaReader.getInstance());
        this.driver.loadSchema(ValidationDriver.fileInputSource((File)schemaFile));
    }

    public void validate(File file) throws IOException {
        this.validate(file, file.getName());
    }

    public void validate(File file, String fileName) throws IOException {
        this.validate(IOUtils.createReader((String)file.getAbsolutePath()), fileName);
    }

    public void validate(Reader reader) throws IOException {
        this.validate(reader, null);
    }

    public void validate(NamedReader reader) throws IOException {
        this.validate((Reader)reader, reader.getName());
    }

    private void validate(Reader reader, String fileName) throws IOException {
        this.errorHandler.fileName = fileName == null ? "input" : fileName;
        StringReader newReader = new StringReader(IOUtils.readAll((Reader)reader));
        this.errorHandler.reader = newReader;
        try {
            if (!this.driver.validate(new InputSource(newReader))) {
                throw new RuntimeException("Aborting due to earlier XML errors.");
            }
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("XML error in " + this.errorHandler.fileName + ": " + Exceptions.toMessageString((Throwable)e));
        }
    }

    private PropertyMap instanceProperties() {
        PropertyMapBuilder builder = new PropertyMapBuilder();
        builder.put(ValidateProperty.ERROR_HANDLER, (Object)this.errorHandler);
        return builder.toPropertyMap();
    }

    private class CustomErrorHandler
    implements ErrorHandler {
        volatile String fileName;
        volatile Reader reader;

        private CustomErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) {
            SchemaValidator.this.deployLogger.logApplicationPackage(Level.WARNING, this.message(e));
        }

        @Override
        public void error(SAXParseException e) {
            throw new IllegalArgumentException(this.message(e));
        }

        @Override
        public void fatalError(SAXParseException e) {
            throw new IllegalArgumentException(this.message(e));
        }

        private String message(SAXParseException e) {
            return "Invalid XML according to XML schema, error in " + this.fileName + ": " + Exceptions.toMessageString((Throwable)e) + " [" + e.getLineNumber() + ":" + e.getColumnNumber() + "], input:\n" + this.getErrorContext(e.getLineNumber());
        }

        private String getErrorContext(int lineNumberWithError) {
            if (!(this.reader instanceof StringReader)) {
                return "";
            }
            int fromLine = Math.max(0, lineNumberWithError - 3);
            int toLine = lineNumberWithError + 3;
            LineNumberReader r = new LineNumberReader(this.reader);
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                this.reader.reset();
                while ((line = r.readLine()) != null) {
                    int lineNumber = r.getLineNumber();
                    if (lineNumber < fromLine || lineNumber > toLine) continue;
                    sb.append(lineNumber).append(":").append(line).append("\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return sb.toString();
        }
    }
}

