/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import com.yahoo.container.plugin.mojo.AbstractAssembleBundleMojo;
import com.yahoo.container.plugin.util.Artifacts;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumMap;
import javax.inject.Inject;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="assemble-container-plugin", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class AssembleContainerPluginMojo
extends AbstractAssembleBundleMojo {
    @Inject
    private MavenProjectHelper projectHelper;
    @Parameter(alias="UseCommonAssemblyIds", defaultValue="false")
    private boolean useCommonAssemblyIds = false;
    @Parameter(alias="AttachBundle", defaultValue="false")
    private boolean attachBundleArtifact;
    @Parameter(alias="BundleClassifier", defaultValue="bundle")
    private String bundleClassifierName;

    public void execute() throws MojoExecutionException {
        EnumMap<Dependencies, String> jarSuffixes = new EnumMap<Dependencies, String>(Dependencies.class);
        if (this.useCommonAssemblyIds) {
            jarSuffixes.put(Dependencies.WITHOUT, ".jar");
            jarSuffixes.put(Dependencies.WITH, "-jar-with-dependencies.jar");
        } else {
            jarSuffixes.put(Dependencies.WITHOUT, "-without-dependencies.jar");
            jarSuffixes.put(Dependencies.WITH, "-deploy.jar");
        }
        EnumMap jarFiles = new EnumMap(Dependencies.class);
        jarSuffixes.forEach((dep, suffix) -> jarFiles.put((Dependencies)((Object)dep), this.jarFileInBuildDirectory(this.build().getFinalName(), (String)suffix)));
        Path manifestFile = Paths.get(this.build().getOutputDirectory(), "META-INF/MANIFEST.MF");
        JarArchiver jarWithoutDependencies = new JarArchiver();
        this.addDirectory(jarWithoutDependencies, Paths.get(this.build().getOutputDirectory(), new String[0]));
        this.createArchive(jarWithoutDependencies, ((File)jarFiles.get((Object)Dependencies.WITHOUT)).toPath(), manifestFile);
        this.project.getArtifact().setFile((File)jarFiles.get((Object)Dependencies.WITHOUT));
        JarArchiver jarWithDependencies = new JarArchiver();
        this.addDirectory(jarWithDependencies, Paths.get(this.build().getOutputDirectory(), new String[0]));
        this.addArtifacts(jarWithDependencies, Artifacts.getArtifactsToInclude(this.project));
        this.createArchive(jarWithDependencies, ((File)jarFiles.get((Object)Dependencies.WITH)).toPath(), manifestFile);
        if (this.attachBundleArtifact) {
            this.projectHelper.attachArtifact(this.project, this.project.getArtifact().getType(), this.bundleClassifierName, (File)jarFiles.get((Object)Dependencies.WITH));
        }
    }

    private File jarFileInBuildDirectory(String name, String suffix) {
        return new File(this.build().getDirectory(), name + suffix);
    }

    private Build build() {
        return this.project.getBuild();
    }

    private static enum Dependencies {
        WITH,
        WITHOUT;

    }
}

