/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zts;

import com.yahoo.athenz.zts.AWSTemporaryCredentials;
import com.yahoo.athenz.zts.Access;
import com.yahoo.athenz.zts.AccessTokenResponse;
import com.yahoo.athenz.zts.CertificateAuthorityBundle;
import com.yahoo.athenz.zts.DomainSignedPolicyData;
import com.yahoo.athenz.zts.HostServices;
import com.yahoo.athenz.zts.Identity;
import com.yahoo.athenz.zts.InstanceIdentity;
import com.yahoo.athenz.zts.InstanceRefreshInformation;
import com.yahoo.athenz.zts.InstanceRefreshRequest;
import com.yahoo.athenz.zts.InstanceRegisterInformation;
import com.yahoo.athenz.zts.InstanceRegisterToken;
import com.yahoo.athenz.zts.JWKList;
import com.yahoo.athenz.zts.JWSPolicyData;
import com.yahoo.athenz.zts.OAuthConfig;
import com.yahoo.athenz.zts.OIDCResponse;
import com.yahoo.athenz.zts.OpenIDConfig;
import com.yahoo.athenz.zts.PublicKeyEntry;
import com.yahoo.athenz.zts.ResourceAccess;
import com.yahoo.athenz.zts.ResourceError;
import com.yahoo.athenz.zts.ResourceException;
import com.yahoo.athenz.zts.RoleAccess;
import com.yahoo.athenz.zts.RoleCertificate;
import com.yahoo.athenz.zts.RoleCertificateRequest;
import com.yahoo.athenz.zts.RoleToken;
import com.yahoo.athenz.zts.SSHCertRequest;
import com.yahoo.athenz.zts.SSHCertificates;
import com.yahoo.athenz.zts.ServiceIdentity;
import com.yahoo.athenz.zts.ServiceIdentityList;
import com.yahoo.athenz.zts.SignedPolicyRequest;
import com.yahoo.athenz.zts.Status;
import com.yahoo.athenz.zts.TenantDomains;
import com.yahoo.athenz.zts.TransportRules;
import com.yahoo.athenz.zts.Workloads;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class ZTSRDLGeneratedClient {
    Client client;
    WebTarget base;
    String credsHeader;
    String credsToken;

    public ZTSRDLGeneratedClient(String url) {
        this.client = ClientBuilder.newClient();
        this.base = this.client.target(url);
    }

    public ZTSRDLGeneratedClient(String url, HostnameVerifier hostnameVerifier) {
        this.client = ClientBuilder.newBuilder().hostnameVerifier(hostnameVerifier).build();
        this.base = this.client.target(url);
    }

    public ZTSRDLGeneratedClient(String url, Client rsClient) {
        this.client = rsClient;
        this.base = this.client.target(url);
    }

    public void close() {
        this.client.close();
    }

    public ZTSRDLGeneratedClient setProperty(String name, Object value) {
        this.client = (Client)this.client.property(name, value);
        this.base = this.client.target(this.base.getUri().toString());
        return this;
    }

    public ZTSRDLGeneratedClient addCredentials(String header, String token) {
        this.credsHeader = header;
        this.credsToken = token;
        return this;
    }

    public ResourceAccess getResourceAccess(String action, String resource, String domain, String checkPrincipal) {
        WebTarget target = this.base.path("/access/{action}/{resource}").resolveTemplate("action", (Object)action).resolveTemplate("resource", (Object)resource);
        if (domain != null) {
            target = target.queryParam("domain", new Object[]{domain});
        }
        if (checkPrincipal != null) {
            target = target.queryParam("principal", new Object[]{checkPrincipal});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (ResourceAccess)response.readEntity(ResourceAccess.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ResourceAccess getResourceAccessExt(String action, String resource, String domain, String checkPrincipal) {
        WebTarget target = this.base.path("/access/{action}").resolveTemplate("action", (Object)action);
        if (resource != null) {
            target = target.queryParam("resource", new Object[]{resource});
        }
        if (domain != null) {
            target = target.queryParam("domain", new Object[]{domain});
        }
        if (checkPrincipal != null) {
            target = target.queryParam("principal", new Object[]{checkPrincipal});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (ResourceAccess)response.readEntity(ResourceAccess.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ServiceIdentity getServiceIdentity(String domainName, String serviceName) {
        WebTarget target = this.base.path("/domain/{domainName}/service/{serviceName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("serviceName", (Object)serviceName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (ServiceIdentity)response.readEntity(ServiceIdentity.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ServiceIdentityList getServiceIdentityList(String domainName) {
        WebTarget target = this.base.path("/domain/{domainName}/service").resolveTemplate("domainName", (Object)domainName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (ServiceIdentityList)response.readEntity(ServiceIdentityList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public PublicKeyEntry getPublicKeyEntry(String domainName, String serviceName, String keyId) {
        WebTarget target = this.base.path("/domain/{domainName}/service/{serviceName}/publickey/{keyId}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("serviceName", (Object)serviceName).resolveTemplate("keyId", (Object)keyId);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (PublicKeyEntry)response.readEntity(PublicKeyEntry.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public HostServices getHostServices(String host) {
        WebTarget target = this.base.path("/host/{host}/services").resolveTemplate("host", (Object)host);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (HostServices)response.readEntity(HostServices.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainSignedPolicyData getDomainSignedPolicyData(String domainName, String matchingTag, Map<String, List<String>> headers) {
        WebTarget target = this.base.path("/domain/{domainName}/signed_policy_data").resolveTemplate("domainName", (Object)domainName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (matchingTag != null) {
            invocationBuilder = invocationBuilder.header("If-None-Match", (Object)matchingTag);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: 
            case 304: {
                if (headers != null) {
                    headers.put("tag", Arrays.asList((String)response.getHeaders().getFirst((Object)"ETag")));
                }
                if (code == 304) {
                    return null;
                }
                return (DomainSignedPolicyData)response.readEntity(DomainSignedPolicyData.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public JWSPolicyData postSignedPolicyRequest(String domainName, SignedPolicyRequest request, String matchingTag, Map<String, List<String>> headers) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/signed").resolveTemplate("domainName", (Object)domainName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (matchingTag != null) {
            invocationBuilder = invocationBuilder.header("If-None-Match", (Object)matchingTag);
        }
        Response response = invocationBuilder.post(Entity.entity((Object)request, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: 
            case 304: {
                if (headers != null) {
                    headers.put("tag", Arrays.asList((String)response.getHeaders().getFirst((Object)"ETag")));
                }
                if (code == 304) {
                    return null;
                }
                return (JWSPolicyData)response.readEntity(JWSPolicyData.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public RoleToken getRoleToken(String domainName, String role, Integer minExpiryTime, Integer maxExpiryTime, String proxyForPrincipal) {
        WebTarget target = this.base.path("/domain/{domainName}/token").resolveTemplate("domainName", (Object)domainName);
        if (role != null) {
            target = target.queryParam("role", new Object[]{role});
        }
        if (minExpiryTime != null) {
            target = target.queryParam("minExpiryTime", new Object[]{minExpiryTime});
        }
        if (maxExpiryTime != null) {
            target = target.queryParam("maxExpiryTime", new Object[]{maxExpiryTime});
        }
        if (proxyForPrincipal != null) {
            target = target.queryParam("proxyForPrincipal", new Object[]{proxyForPrincipal});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (RoleToken)response.readEntity(RoleToken.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public RoleToken postRoleCertificateRequest(String domainName, String roleName, RoleCertificateRequest req) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}/token").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity((Object)req, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (RoleToken)response.readEntity(RoleToken.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Access getAccess(String domainName, String roleName, String principal) {
        WebTarget target = this.base.path("/access/domain/{domainName}/role/{roleName}/principal/{principal}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName).resolveTemplate("principal", (Object)principal);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Access)response.readEntity(Access.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public RoleAccess getRoleAccess(String domainName, String principal) {
        WebTarget target = this.base.path("/access/domain/{domainName}/principal/{principal}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("principal", (Object)principal);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (RoleAccess)response.readEntity(RoleAccess.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public TenantDomains getTenantDomains(String providerDomainName, String userName, String roleName, String serviceName) {
        WebTarget target = this.base.path("/providerdomain/{providerDomainName}/user/{userName}").resolveTemplate("providerDomainName", (Object)providerDomainName).resolveTemplate("userName", (Object)userName);
        if (roleName != null) {
            target = target.queryParam("roleName", new Object[]{roleName});
        }
        if (serviceName != null) {
            target = target.queryParam("serviceName", new Object[]{serviceName});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (TenantDomains)response.readEntity(TenantDomains.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Identity postInstanceRefreshRequest(String domain, String service, InstanceRefreshRequest req) {
        WebTarget target = this.base.path("/instance/{domain}/{service}/refresh").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity((Object)req, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Identity)response.readEntity(Identity.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public AWSTemporaryCredentials getAWSTemporaryCredentials(String domainName, String role, Integer durationSeconds, String externalId) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{role}/creds").resolveTemplate("domainName", (Object)domainName).resolveTemplate("role", (Object)role);
        if (durationSeconds != null) {
            target = target.queryParam("durationSeconds", new Object[]{durationSeconds});
        }
        if (externalId != null) {
            target = target.queryParam("externalId", new Object[]{externalId});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (AWSTemporaryCredentials)response.readEntity(AWSTemporaryCredentials.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public InstanceIdentity postInstanceRegisterInformation(InstanceRegisterInformation info, Map<String, List<String>> headers) {
        WebTarget target = this.base.path("/instance");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity((Object)info, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 201: {
                if (headers != null) {
                    headers.put("location", Arrays.asList((String)response.getHeaders().getFirst((Object)"Location")));
                }
                return (InstanceIdentity)response.readEntity(InstanceIdentity.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public InstanceIdentity postInstanceRefreshInformation(String provider, String domain, String service, String instanceId, InstanceRefreshInformation info) {
        WebTarget target = this.base.path("/instance/{provider}/{domain}/{service}/{instanceId}").resolveTemplate("provider", (Object)provider).resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service).resolveTemplate("instanceId", (Object)instanceId);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity((Object)info, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (InstanceIdentity)response.readEntity(InstanceIdentity.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public InstanceRegisterToken getInstanceRegisterToken(String provider, String domain, String service, String instanceId) {
        WebTarget target = this.base.path("/instance/{provider}/{domain}/{service}/{instanceId}/token").resolveTemplate("provider", (Object)provider).resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service).resolveTemplate("instanceId", (Object)instanceId);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (InstanceRegisterToken)response.readEntity(InstanceRegisterToken.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public InstanceIdentity deleteInstanceIdentity(String provider, String domain, String service, String instanceId) {
        WebTarget target = this.base.path("/instance/{provider}/{domain}/{service}/{instanceId}").resolveTemplate("provider", (Object)provider).resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service).resolveTemplate("instanceId", (Object)instanceId);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public CertificateAuthorityBundle getCertificateAuthorityBundle(String name) {
        WebTarget target = this.base.path("/cacerts/{name}").resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (CertificateAuthorityBundle)response.readEntity(CertificateAuthorityBundle.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Status getStatus() {
        WebTarget target = this.base.path("/status");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Status)response.readEntity(Status.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public SSHCertificates postSSHCertRequest(SSHCertRequest certRequest) {
        WebTarget target = this.base.path("/sshcert");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity((Object)certRequest, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 201: {
                return (SSHCertificates)response.readEntity(SSHCertificates.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public OpenIDConfig getOpenIDConfig() {
        WebTarget target = this.base.path("/.well-known/openid-configuration");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (OpenIDConfig)response.readEntity(OpenIDConfig.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public OAuthConfig getOAuthConfig() {
        WebTarget target = this.base.path("/.well-known/oauth-authorization-server");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (OAuthConfig)response.readEntity(OAuthConfig.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public JWKList getJWKList(Boolean rfc) {
        WebTarget target = this.base.path("/oauth2/keys");
        if (rfc != null) {
            target = target.queryParam("rfc", new Object[]{rfc});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (JWKList)response.readEntity(JWKList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public AccessTokenResponse postAccessTokenRequest(String request) {
        WebTarget target = this.base.path("/oauth2/token");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity((Object)request, (String)"application/x-www-form-urlencoded"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public OIDCResponse getOIDCResponse(String responseType, String clientId, String redirectUri, String scope, String state, String nonce, String keyType, Map<String, List<String>> headers) {
        WebTarget target = this.base.path("/oauth2/auth");
        if (responseType != null) {
            target = target.queryParam("response_type", new Object[]{responseType});
        }
        if (clientId != null) {
            target = target.queryParam("client_id", new Object[]{clientId});
        }
        if (redirectUri != null) {
            target = target.queryParam("redirect_uri", new Object[]{redirectUri});
        }
        if (scope != null) {
            target = target.queryParam("scope", new Object[]{scope});
        }
        if (state != null) {
            target = target.queryParam("state", new Object[]{state});
        }
        if (nonce != null) {
            target = target.queryParam("nonce", new Object[]{nonce});
        }
        if (keyType != null) {
            target = target.queryParam("keyType", new Object[]{keyType});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 302: {
                if (headers != null) {
                    headers.put("location", Arrays.asList((String)response.getHeaders().getFirst((Object)"Location")));
                }
                return (OIDCResponse)response.readEntity(OIDCResponse.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public RoleCertificate postRoleCertificateRequestExt(RoleCertificateRequest req) {
        WebTarget target = this.base.path("/rolecert");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.post(Entity.entity((Object)req, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (RoleCertificate)response.readEntity(RoleCertificate.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public RoleAccess getRolesRequireRoleCert(String principal) {
        WebTarget target = this.base.path("/role/cert");
        if (principal != null) {
            target = target.queryParam("principal", new Object[]{principal});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (RoleAccess)response.readEntity(RoleAccess.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Workloads getWorkloadsByService(String domainName, String serviceName) {
        WebTarget target = this.base.path("/domain/{domainName}/service/{serviceName}/workloads").resolveTemplate("domainName", (Object)domainName).resolveTemplate("serviceName", (Object)serviceName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Workloads)response.readEntity(Workloads.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Workloads getWorkloadsByIP(String ip) {
        WebTarget target = this.base.path("/workloads/{ip}").resolveTemplate("ip", (Object)ip);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Workloads)response.readEntity(Workloads.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public TransportRules getTransportRules(String domainName, String serviceName) {
        WebTarget target = this.base.path("/domain/{domainName}/service/{serviceName}/transportRules").resolveTemplate("domainName", (Object)domainName).resolveTemplate("serviceName", (Object)serviceName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (TransportRules)response.readEntity(TransportRules.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }
}

