/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zts;

import com.yahoo.athenz.auth.token.AccessToken;
import com.yahoo.athenz.auth.token.IdToken;
import com.yahoo.athenz.auth.token.jwts.JwtsSigningKeyResolver;
import com.yahoo.athenz.zts.AccessTokenResponse;
import com.yahoo.athenz.zts.AccessTokenResponseCacheEntry;
import com.yahoo.athenz.zts.RoleToken;
import com.yahoo.athenz.zts.ZTSClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZTSClientTokenCacher {
    private static final Logger LOG = LoggerFactory.getLogger(ZTSClientTokenCacher.class);

    public static void setRoleToken(String signedRoleToken, String roleName, String trustDomain) {
        ZTSClientTokenCacher.setRoleToken(signedRoleToken, roleName);
    }

    public static void setRoleToken(String signedRoleToken, String roleName) {
        com.yahoo.athenz.auth.token.RoleToken rt = new com.yahoo.athenz.auth.token.RoleToken(signedRoleToken);
        String domainName = rt.getDomain();
        String principalName = rt.getPrincipal();
        int index = principalName.lastIndexOf(46);
        if (index == -1) {
            return;
        }
        String tenantDomain = principalName.substring(0, index);
        String tenantService = principalName.substring(index + 1);
        Long expiryTime = rt.getExpiryTime();
        RoleToken roleToken = new RoleToken().setToken(signedRoleToken).setExpiryTime(expiryTime.longValue());
        String key = ZTSClient.getRoleTokenCacheKey(tenantDomain, tenantService, domainName, roleName, null);
        if (LOG.isInfoEnabled()) {
            LOG.info("ZTSTokenCache: cache-add key: {} expiry: {}", (Object)key, (Object)expiryTime);
        }
        ZTSClient.ROLE_TOKEN_CACHE.put(key, roleToken);
    }

    public static void setAccessToken(AccessTokenResponse accessTokenResponse, List<String> roleNames) {
        AccessToken accessToken;
        if (accessTokenResponse == null || accessTokenResponse.getAccess_token() == null) {
            return;
        }
        String tokenWithoutSignature = ZTSClientTokenCacher.removeSignature(accessTokenResponse.getAccess_token());
        try {
            accessToken = new AccessToken(tokenWithoutSignature, (JwtsSigningKeyResolver)null);
        }
        catch (Exception ex) {
            LOG.error("ZTSTokenCache: unable to parse access token", (Throwable)ex);
            return;
        }
        String domainName = accessToken.getAudience();
        String principalName = accessToken.getClientId();
        int index = principalName.lastIndexOf(46);
        if (index == -1) {
            return;
        }
        String tenantDomain = principalName.substring(0, index);
        String tenantService = principalName.substring(index + 1);
        AccessTokenResponseCacheEntry cacheEntry = new AccessTokenResponseCacheEntry(accessTokenResponse);
        String proxyPrincipalSpiffeUris = null;
        List spiffeUris = accessToken.getConfirmProxyPrincpalSpiffeUris();
        if (spiffeUris != null) {
            proxyPrincipalSpiffeUris = String.join((CharSequence)",", spiffeUris);
        }
        String idTokenServiceName = ZTSClientTokenCacher.extractIdTokenServiceName(accessTokenResponse.getId_token());
        String key = ZTSClient.getAccessTokenCacheKey(tenantDomain, tenantService, domainName, roleNames, idTokenServiceName, accessToken.getProxyPrincipal(), accessToken.getAuthorizationDetails(), proxyPrincipalSpiffeUris);
        if (LOG.isInfoEnabled()) {
            LOG.info("ZTSTokenCache: cache-add key: {} expires-in: {}", (Object)key, (Object)accessTokenResponse.getExpires_in());
        }
        ZTSClient.ACCESS_TOKEN_CACHE.put(key, cacheEntry);
    }

    private static String extractIdTokenServiceName(String token) {
        IdToken idToken;
        if (token == null) {
            return null;
        }
        String tokenWithoutSignature = ZTSClientTokenCacher.removeSignature(token);
        try {
            idToken = new IdToken(tokenWithoutSignature, (JwtsSigningKeyResolver)null);
        }
        catch (Exception ex) {
            LOG.error("ZTSTokenCache: unable to parse id token", (Throwable)ex);
            return null;
        }
        String fullServiceName = idToken.getAudience();
        if (fullServiceName == null) {
            LOG.error("ZTSTokenCache: token has no audience");
            return null;
        }
        int index = fullServiceName.lastIndexOf(46);
        if (index == -1) {
            LOG.error("ZTSTokenCache: invalid id token audience - {}", (Object)fullServiceName);
            return null;
        }
        return fullServiceName.substring(index + 1);
    }

    private static String removeSignature(String accessToken) {
        int idx = accessToken.lastIndexOf(46);
        return idx == -1 ? accessToken : accessToken.substring(0, idx + 1);
    }
}

