/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zts;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oath.auth.KeyManagerProxy;
import com.oath.auth.KeyRefresher;
import com.oath.auth.KeyRefresherException;
import com.oath.auth.KeyRefresherListener;
import com.oath.auth.TrustManagerProxy;
import com.oath.auth.Utils;
import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.PrivateKeyStore;
import com.yahoo.athenz.auth.ServiceIdentityProvider;
import com.yahoo.athenz.auth.token.jwts.JwtsSigningKeyResolver;
import com.yahoo.athenz.auth.util.Crypto;
import com.yahoo.athenz.auth.util.CryptoException;
import com.yahoo.athenz.common.config.AthenzConfig;
import com.yahoo.athenz.common.utils.SSLUtils;
import com.yahoo.athenz.zts.AWSAttestationData;
import com.yahoo.athenz.zts.AWSCredentialsProviderImpl;
import com.yahoo.athenz.zts.AWSLambdaIdentity;
import com.yahoo.athenz.zts.AWSTemporaryCredentials;
import com.yahoo.athenz.zts.Access;
import com.yahoo.athenz.zts.AccessTokenResponse;
import com.yahoo.athenz.zts.AccessTokenResponseCacheEntry;
import com.yahoo.athenz.zts.CertificateAuthorityBundle;
import com.yahoo.athenz.zts.DomainSignedPolicyData;
import com.yahoo.athenz.zts.HostServices;
import com.yahoo.athenz.zts.Identity;
import com.yahoo.athenz.zts.InstanceIdentity;
import com.yahoo.athenz.zts.InstanceRefreshInformation;
import com.yahoo.athenz.zts.InstanceRefreshRequest;
import com.yahoo.athenz.zts.InstanceRegisterInformation;
import com.yahoo.athenz.zts.InstanceRegisterToken;
import com.yahoo.athenz.zts.JWKList;
import com.yahoo.athenz.zts.JWSPolicyData;
import com.yahoo.athenz.zts.OpenIDConfig;
import com.yahoo.athenz.zts.PublicKeyEntry;
import com.yahoo.athenz.zts.ResourceAccess;
import com.yahoo.athenz.zts.ResourceException;
import com.yahoo.athenz.zts.RoleAccess;
import com.yahoo.athenz.zts.RoleCertificate;
import com.yahoo.athenz.zts.RoleCertificateRequest;
import com.yahoo.athenz.zts.RoleToken;
import com.yahoo.athenz.zts.ServiceIdentity;
import com.yahoo.athenz.zts.ServiceIdentityList;
import com.yahoo.athenz.zts.SignedPolicyRequest;
import com.yahoo.athenz.zts.TenantDomains;
import com.yahoo.athenz.zts.TransportRules;
import com.yahoo.athenz.zts.Workloads;
import com.yahoo.athenz.zts.ZTSAccessTokenFileLoader;
import com.yahoo.athenz.zts.ZTSClientCache;
import com.yahoo.athenz.zts.ZTSClientException;
import com.yahoo.athenz.zts.ZTSClientNotification;
import com.yahoo.athenz.zts.ZTSClientNotificationSender;
import com.yahoo.athenz.zts.ZTSClientService;
import com.yahoo.athenz.zts.ZTSRDLGeneratedClient;
import com.yahoo.rdl.JSON;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.operator.OperatorCreationException;
import org.ehcache.Cache;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZTSClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ZTSClient.class);
    private String ztsUrl = null;
    private String proxyUrl = null;
    private String domain = null;
    private String service = null;
    private SSLContext sslContext = null;
    private ZTSClientNotificationSender notificationSender = null;
    ZTSRDLGeneratedClient ztsClient = null;
    ServiceIdentityProvider siaProvider = null;
    Principal principal = null;
    ZTSClientCache ztsClientCache = ZTSClientCache.getInstance();
    private static boolean cacheDisabled = false;
    private static int tokenMinExpiryTime = 900;
    private static int tokenMaxExpiryOffset = 300;
    private static long prefetchInterval = 60L;
    private static boolean prefetchAutoEnable = true;
    private static String x509CsrDn = null;
    private static String x509CsrDomain = null;
    private static int reqReadTimeout = 30000;
    private static int reqConnectTimeout = 30000;
    private static String x509CertDNSName = null;
    private static String confZtsUrl = null;
    private static JwtsSigningKeyResolver resolver = null;
    private boolean enablePrefetch = true;
    private boolean ztsClientOverride = false;
    private static boolean initialized = ZTSClient.initConfigValues();
    public static final String ZTS_CLIENT_PROP_ATHENZ_CONF = "athenz.athenz_conf";
    public static final String ZTS_CLIENT_PROP_TOKEN_MIN_EXPIRY_TIME = "athenz.zts.client.token_min_expiry_time";
    public static final String ZTS_CLIENT_PROP_READ_TIMEOUT = "athenz.zts.client.read_timeout";
    public static final String ZTS_CLIENT_PROP_CONNECT_TIMEOUT = "athenz.zts.client.connect_timeout";
    public static final String ZTS_CLIENT_PROP_PREFETCH_SLEEP_INTERVAL = "athenz.zts.client.prefetch_sleep_interval";
    public static final String ZTS_CLIENT_PROP_PREFETCH_AUTO_ENABLE = "athenz.zts.client.prefetch_auto_enable";
    public static final String ZTS_CLIENT_PROP_X509CERT_DNS_NAME = "athenz.zts.client.x509cert_dns_name";
    public static final String ZTS_CLIENT_PROP_X509CSR_DN = "athenz.zts.client.x509csr_dn";
    public static final String ZTS_CLIENT_PROP_X509CSR_DOMAIN = "athenz.zts.client.x509csr_domain";
    public static final String ZTS_CLIENT_PROP_DISABLE_CACHE = "athenz.zts.client.disable_cache";
    public static final String ZTS_CLIENT_PROP_CERT_ALIAS = "athenz.zts.client.cert_alias";
    public static final String ZTS_CLIENT_PROP_KEYSTORE_PATH = "athenz.zts.client.keystore_path";
    public static final String ZTS_CLIENT_PROP_KEYSTORE_TYPE = "athenz.zts.client.keystore_type";
    public static final String ZTS_CLIENT_PROP_KEYSTORE_PASSWORD = "athenz.zts.client.keystore_password";
    public static final String ZTS_CLIENT_PROP_KEYSTORE_PWD_APP_NAME = "athenz.zts.client.keystore_pwd_app_name";
    public static final String ZTS_CLIENT_PROP_KEY_MANAGER_PASSWORD = "athenz.zts.client.keymanager_password";
    public static final String ZTS_CLIENT_PROP_KEY_MANAGER_PWD_APP_NAME = "athenz.zts.client.keymanager_pwd_app_name";
    public static final String ZTS_CLIENT_PROP_TRUSTSTORE_PATH = "athenz.zts.client.truststore_path";
    public static final String ZTS_CLIENT_PROP_TRUSTSTORE_TYPE = "athenz.zts.client.truststore_type";
    public static final String ZTS_CLIENT_PROP_TRUSTSTORE_PASSWORD = "athenz.zts.client.truststore_password";
    public static final String ZTS_CLIENT_PROP_TRUSTSTORE_PWD_APP_NAME = "athenz.zts.client.truststore_pwd_app_name";
    public static final String ZTS_CLIENT_PROP_POOL_MAX_PER_ROUTE = "athenz.zts.client.http_pool_max_per_route";
    public static final String ZTS_CLIENT_PROP_POOL_MAX_TOTAL = "athenz.zts.client.http_pool_max_total";
    public static final String ZTS_CLIENT_PROP_PRIVATE_KEY_STORE_FACTORY_CLASS = "athenz.zts.client.private_keystore_factory_class";
    public static final String ZTS_CLIENT_PROP_CLIENT_PROTOCOL = "athenz.zts.client.client_ssl_protocol";
    public static final String ZTS_CLIENT_PKEY_STORE_FACTORY_CLASS = "com.yahoo.athenz.auth.impl.FilePrivateKeyStoreFactory";
    public static final String ZTS_CLIENT_DEFAULT_CLIENT_SSL_PROTOCOL = "TLSv1.2";
    public static final String SPIFFE_URI = "spiffe://";
    public static final String SPIFFE_COMP_SERVICE = "/sa/";
    public static final String SPIFFE_COMP_ROLE = "/ra/";
    public static final String ROLE_TOKEN_HEADER = System.getProperty("athenz.auth.role.header", "Athenz-Role-Auth");
    static final ConcurrentHashMap<String, RoleToken> ROLE_TOKEN_CACHE = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, AccessTokenResponseCacheEntry> ACCESS_TOKEN_CACHE = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, AWSTemporaryCredentials> AWS_CREDS_CACHE = new ConcurrentHashMap();
    private static final Queue<PrefetchTokenScheduledItem> PREFETCH_SCHEDULED_ITEMS = new ConcurrentLinkedQueue<PrefetchTokenScheduledItem>();
    private static Timer FETCH_TIMER;
    private static final Object TIMER_LOCK;
    static AtomicLong FETCHER_LAST_RUN_AT;
    static final ClientKeyRefresherListener KEY_REFRESHER_LISTENER;
    private static ServiceLoader<ZTSClientService> ztsTokenProviders;
    private static AtomicReference<Set<String>> svcLoaderCacheKeys;
    private static PrivateKeyStore PRIVATE_KEY_STORE;
    private static ZTSAccessTokenFileLoader ztsAccessTokenFileLoader;

    static boolean initConfigValues() {
        ZTSClient.loadSvcProviderTokens();
        ZTSClient.setTokenMinExpiryTime(Integer.parseInt(System.getProperty(ZTS_CLIENT_PROP_TOKEN_MIN_EXPIRY_TIME, "900")));
        ZTSClient.setPrefetchInterval(Integer.parseInt(System.getProperty(ZTS_CLIENT_PROP_PREFETCH_SLEEP_INTERVAL, "60")));
        ZTSClient.setPrefetchAutoEnable(Boolean.parseBoolean(System.getProperty(ZTS_CLIENT_PROP_PREFETCH_AUTO_ENABLE, "true")));
        ZTSClient.setCacheDisable(Boolean.parseBoolean(System.getProperty(ZTS_CLIENT_PROP_DISABLE_CACHE, "false")));
        ZTSClient.setX509CsrDetails(System.getProperty(ZTS_CLIENT_PROP_X509CSR_DN), System.getProperty(ZTS_CLIENT_PROP_X509CSR_DOMAIN));
        ZTSClient.setConnectionTimeouts(Integer.parseInt(System.getProperty(ZTS_CLIENT_PROP_CONNECT_TIMEOUT, "30000")), Integer.parseInt(System.getProperty(ZTS_CLIENT_PROP_READ_TIMEOUT, "30000")));
        ZTSClient.setX509CertDnsName(System.getProperty(ZTS_CLIENT_PROP_X509CERT_DNS_NAME));
        ZTSClient.lookupZTSUrl();
        ZTSClient.initZTSAccessTokenFileLoader();
        return true;
    }

    public static void setX509CertDnsName(String dnsName) {
        x509CertDNSName = dnsName;
    }

    public static void setConnectionTimeouts(int connectTimeout, int readTimeout) {
        reqConnectTimeout = connectTimeout;
        reqReadTimeout = readTimeout;
    }

    public static void setX509CsrDetails(String csrDn, String csrDomain) {
        x509CsrDn = csrDn;
        x509CsrDomain = csrDomain;
    }

    public static void setCacheDisable(boolean cacheState) {
        cacheDisabled = cacheState;
    }

    public static void setPrefetchAutoEnable(boolean fetchState) {
        prefetchAutoEnable = fetchState;
    }

    public static void setPrefetchInterval(int interval) {
        prefetchInterval = interval;
        if (prefetchInterval >= (long)tokenMinExpiryTime) {
            prefetchInterval = 60L;
        }
    }

    public static void setTokenMinExpiryTime(int minExpiryTime) {
        tokenMinExpiryTime = minExpiryTime;
        if (tokenMinExpiryTime < 0) {
            tokenMinExpiryTime = 900;
        }
    }

    public static void lookupZTSUrl() {
        block3: {
            String rootDir = System.getenv("ROOT");
            if (rootDir == null) {
                rootDir = "/home/athenz";
            }
            String confFileName = System.getProperty(ZTS_CLIENT_PROP_ATHENZ_CONF, rootDir + "/conf/athenz/athenz.conf");
            try {
                Path path = Paths.get(confFileName, new String[0]);
                AthenzConfig conf = (AthenzConfig)JSON.fromBytes((byte[])Files.readAllBytes(path), AthenzConfig.class);
                confZtsUrl = conf.getZtsUrl();
            }
            catch (Exception ex) {
                LOG.warn("Unable to extract ZTS Url from conf file {}, exc: {}", (Object)confFileName, (Object)ex.getMessage());
                if (svcLoaderCacheKeys.get().isEmpty()) break block3;
                confZtsUrl = "https://localhost:4443/";
            }
        }
    }

    public static void initZTSAccessTokenFileLoader() {
        if (resolver == null) {
            resolver = new JwtsSigningKeyResolver(null, null);
        }
        ztsAccessTokenFileLoader = new ZTSAccessTokenFileLoader(resolver);
        ztsAccessTokenFileLoader.preload();
    }

    public static void setAccessTokenSignKeyResolver(JwtsSigningKeyResolver jwtsSigningKeyResolver) {
        resolver = jwtsSigningKeyResolver;
    }

    public ZTSClient() {
        this.initClient(null, null, null, null, null);
        this.enablePrefetch = false;
    }

    public ZTSClient(String ztsUrl) {
        this.initClient(ztsUrl, null, null, null, null);
        this.enablePrefetch = false;
    }

    public ZTSClient(Principal identity) {
        this(null, identity);
    }

    public ZTSClient(String ztsUrl, Principal identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Principal object must be specified");
        }
        if (identity.getAuthority() == null) {
            throw new IllegalArgumentException("Principal Authority cannot be null");
        }
        this.initClient(ztsUrl, identity, null, null, null);
        this.enablePrefetch = false;
    }

    public ZTSClient(String ztsUrl, SSLContext sslContext) {
        this(ztsUrl, null, sslContext);
    }

    public ZTSClient(String ztsUrl, String proxyUrl, SSLContext sslContext) {
        if (sslContext == null) {
            throw new IllegalArgumentException("SSLContext object must be specified");
        }
        this.sslContext = sslContext;
        this.proxyUrl = proxyUrl;
        this.initClient(ztsUrl, null, null, null, null);
    }

    public ZTSClient(String domainName, String serviceName, ServiceIdentityProvider siaProvider) {
        this(null, domainName, serviceName, siaProvider);
    }

    public ZTSClient(String ztsUrl, String domainName, String serviceName, ServiceIdentityProvider siaProvider) {
        if (ZTSClient.isEmpty(domainName)) {
            throw new IllegalArgumentException("Domain name must be specified");
        }
        if (ZTSClient.isEmpty(serviceName)) {
            throw new IllegalArgumentException("Service name must be specified");
        }
        if (siaProvider == null) {
            throw new IllegalArgumentException("Service Identity Provider must be specified");
        }
        this.initClient(ztsUrl, null, domainName, serviceName, siaProvider);
    }

    @Override
    public void close() {
        this.ztsClient.close();
    }

    public void setEnablePrefetch(boolean state) {
        this.enablePrefetch = state;
    }

    public void setProperty(String name, Object value) {
        if (this.ztsClient != null) {
            this.ztsClient.setProperty(name, value);
        }
    }

    public void setNotificationSender(ZTSClientNotificationSender notificationSender) {
        this.notificationSender = notificationSender;
    }

    public static void cancelPrefetch() {
        PREFETCH_SCHEDULED_ITEMS.clear();
        if (FETCH_TIMER != null) {
            FETCH_TIMER.purge();
            FETCH_TIMER.cancel();
            FETCH_TIMER = null;
        }
    }

    public String getZTSUrl() {
        return this.ztsUrl;
    }

    public void setZTSRDLGeneratedClient(ZTSRDLGeneratedClient client) {
        this.ztsClient = client;
        this.ztsClientOverride = true;
    }

    public void setZTSClientCache(ZTSClientCache ztsClientCache) {
        this.ztsClientCache = ztsClientCache;
    }

    public SSLContext createSSLContext(String trustStorePath, char[] trustStorePassword, String publicCertFile, String privateKeyFile, boolean monitorKeyCertUpdates) throws InterruptedException, KeyRefresherException, IOException {
        KeyRefresher keyRefresher = Utils.generateKeyRefresher((String)trustStorePath, (char[])trustStorePassword, (String)publicCertFile, (String)privateKeyFile, (KeyRefresherListener)KEY_REFRESHER_LISTENER);
        SSLContext sslContext = Utils.buildSSLContext((KeyManagerProxy)keyRefresher.getKeyManagerProxy(), (TrustManagerProxy)keyRefresher.getTrustManagerProxy());
        if (monitorKeyCertUpdates) {
            keyRefresher.startup();
        }
        return sslContext;
    }

    private SSLContext createSSLContext() {
        String keyStorePath = System.getProperty(ZTS_CLIENT_PROP_KEYSTORE_PATH);
        if (ZTSClient.isEmpty(keyStorePath)) {
            return null;
        }
        String keyStoreType = System.getProperty(ZTS_CLIENT_PROP_KEYSTORE_TYPE);
        String keyStorePwd = System.getProperty(ZTS_CLIENT_PROP_KEYSTORE_PASSWORD);
        char[] keyStorePassword = null;
        if (!ZTSClient.isEmpty(keyStorePwd)) {
            keyStorePassword = keyStorePwd.toCharArray();
        }
        String keyStorePasswordAppName = System.getProperty(ZTS_CLIENT_PROP_KEYSTORE_PWD_APP_NAME);
        char[] keyManagerPassword = null;
        String keyManagerPwd = System.getProperty(ZTS_CLIENT_PROP_KEY_MANAGER_PASSWORD);
        if (!ZTSClient.isEmpty(keyManagerPwd)) {
            keyManagerPassword = keyManagerPwd.toCharArray();
        }
        String keyManagerPasswordAppName = System.getProperty(ZTS_CLIENT_PROP_KEY_MANAGER_PWD_APP_NAME);
        String trustStorePath = System.getProperty(ZTS_CLIENT_PROP_TRUSTSTORE_PATH);
        String trustStoreType = System.getProperty(ZTS_CLIENT_PROP_TRUSTSTORE_TYPE);
        String trustStorePwd = System.getProperty(ZTS_CLIENT_PROP_TRUSTSTORE_PASSWORD);
        char[] trustStorePassword = null;
        if (!ZTSClient.isEmpty(trustStorePwd)) {
            trustStorePassword = trustStorePwd.toCharArray();
        }
        String trustStorePasswordAppName = System.getProperty(ZTS_CLIENT_PROP_TRUSTSTORE_PWD_APP_NAME);
        String certAlias = System.getProperty(ZTS_CLIENT_PROP_CERT_ALIAS);
        String clientProtocol = System.getProperty(ZTS_CLIENT_PROP_CLIENT_PROTOCOL, ZTS_CLIENT_DEFAULT_CLIENT_SSL_PROTOCOL);
        SSLUtils.ClientSSLContextBuilder builder = new SSLUtils.ClientSSLContextBuilder(clientProtocol).privateKeyStore(PRIVATE_KEY_STORE).keyStorePath(keyStorePath);
        if (!ZTSClient.isEmpty(certAlias)) {
            builder.certAlias(certAlias);
        }
        if (!ZTSClient.isEmpty(keyStoreType)) {
            builder.keyStoreType(keyStoreType);
        }
        if (null != keyStorePassword) {
            builder.keyStorePassword(keyStorePassword);
        }
        if (null != keyStorePasswordAppName) {
            builder.keyStorePasswordAppName(keyStorePasswordAppName);
        }
        if (null != keyManagerPassword) {
            builder.keyManagerPassword(keyManagerPassword);
        }
        if (null != keyManagerPasswordAppName) {
            builder.keyManagerPasswordAppName(keyManagerPasswordAppName);
        }
        if (!ZTSClient.isEmpty(trustStorePath)) {
            builder.trustStorePath(trustStorePath);
        }
        if (!ZTSClient.isEmpty(trustStoreType)) {
            builder.trustStoreType(trustStoreType);
        }
        if (null != trustStorePassword) {
            builder.trustStorePassword(trustStorePassword);
        }
        if (null != trustStorePasswordAppName) {
            builder.trustStorePasswordAppName(trustStorePasswordAppName);
        }
        return builder.build();
    }

    static PrivateKeyStore loadServicePrivateKey() {
        String pkeyFactoryClass = System.getProperty(ZTS_CLIENT_PROP_PRIVATE_KEY_STORE_FACTORY_CLASS, ZTS_CLIENT_PKEY_STORE_FACTORY_CLASS);
        return SSLUtils.loadServicePrivateKey((String)pkeyFactoryClass);
    }

    ClientBuilder getClientBuilder() {
        return ClientBuilder.newBuilder();
    }

    private void initClient(String serverUrl, Principal identity, String domainName, String serviceName, ServiceIdentityProvider siaProvider) {
        String string = this.ztsUrl = serverUrl == null ? confZtsUrl : serverUrl;
        if (!ZTSClient.isEmpty(this.ztsUrl) && !this.ztsUrl.endsWith("/zts/v1")) {
            if (this.ztsUrl.charAt(this.ztsUrl.length() - 1) != '/') {
                this.ztsUrl = this.ztsUrl + '/';
            }
            this.ztsUrl = this.ztsUrl + "zts/v1";
        }
        AWSHostNameVerifier hostnameVerifier = null;
        if (!ZTSClient.isEmpty(x509CertDNSName)) {
            hostnameVerifier = new AWSHostNameVerifier(x509CertDNSName);
        }
        if (this.sslContext == null) {
            this.sslContext = this.createSSLContext();
        }
        JacksonJsonProvider jacksonJsonProvider = (JacksonJsonProvider)new JacksonJaxbJsonProvider().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ClientConfig config = new ClientConfig(new Object[]{jacksonJsonProvider});
        PoolingHttpClientConnectionManager connManager = this.createConnectionManager(this.sslContext, hostnameVerifier);
        if (connManager != null) {
            config.property("jersey.config.apache.client.connectionManager", (Object)connManager);
        }
        config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        if (this.proxyUrl != null) {
            config.property("jersey.config.client.proxy.uri", (Object)this.proxyUrl);
        }
        ClientBuilder builder = this.getClientBuilder();
        if (this.sslContext != null) {
            builder = builder.sslContext(this.sslContext);
            this.enablePrefetch = true;
        }
        Client rsClient = builder.withConfig((Configuration)config).hostnameVerifier((HostnameVerifier)hostnameVerifier).readTimeout((long)reqReadTimeout, TimeUnit.MILLISECONDS).connectTimeout((long)reqConnectTimeout, TimeUnit.MILLISECONDS).build();
        this.ztsClient = new ZTSRDLGeneratedClient(this.ztsUrl, rsClient);
        this.principal = identity;
        this.domain = domainName;
        this.service = serviceName;
        this.siaProvider = siaProvider;
        if (this.principal != null) {
            this.domain = this.principal.getDomain();
            this.service = this.principal.getName();
            this.ztsClient.addCredentials(identity.getAuthority().getHeader(), identity.getCredentials());
        }
    }

    PoolingHttpClientConnectionManager createConnectionManager(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        if (sslContext == null) {
            return null;
        }
        SSLConnectionSocketFactory sslSocketFactory = hostnameVerifier == null ? new SSLConnectionSocketFactory(sslContext) : new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslSocketFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
        int maxPerRoute = Integer.parseInt(System.getProperty(ZTS_CLIENT_PROP_POOL_MAX_PER_ROUTE, "2"));
        int maxTotal = Integer.parseInt(System.getProperty(ZTS_CLIENT_PROP_POOL_MAX_TOTAL, "20"));
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(maxPerRoute);
        poolingHttpClientConnectionManager.setMaxTotal(maxTotal);
        return poolingHttpClientConnectionManager;
    }

    void setPrefetchInterval(long interval) {
        prefetchInterval = interval;
    }

    long getPrefetchInterval() {
        return prefetchInterval;
    }

    public static String getHeader() {
        return ROLE_TOKEN_HEADER;
    }

    public ZTSClient addCredentials(Principal identity) {
        return this.addPrincipalCredentials(identity, true);
    }

    public void addCredentials(String credHeader, String credToken) {
        this.ztsClient.addCredentials(credHeader, credToken);
    }

    public ZTSClient clearCredentials() {
        if (this.principal != null) {
            this.ztsClient.addCredentials(this.principal.getAuthority().getHeader(), null);
            this.principal = null;
        }
        return this;
    }

    ZTSClient addPrincipalCredentials(Principal identity, boolean resetServiceDetails) {
        if (identity != null && identity.getAuthority() != null) {
            this.ztsClient.addCredentials(identity.getAuthority().getHeader(), identity.getCredentials());
        }
        if (resetServiceDetails) {
            this.siaProvider = null;
        }
        this.principal = identity;
        return this;
    }

    boolean sameCredentialsAsBefore(Principal svcPrincipal) {
        if (this.principal == null) {
            return false;
        }
        String creds = this.principal.getCredentials();
        if (creds == null) {
            return false;
        }
        return creds.equals(svcPrincipal.getCredentials());
    }

    boolean updateServicePrincipal() {
        if (this.siaProvider == null) {
            return false;
        }
        Principal svcPrincipal = this.siaProvider.getIdentity(this.domain, this.service);
        if (svcPrincipal == null) {
            String msg = "UpdateServicePrincipal: Unable to get PrincipalToken from SIA Provider for " + this.domain + "." + this.service;
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        if (this.sameCredentialsAsBefore(svcPrincipal)) {
            return false;
        }
        this.addPrincipalCredentials(svcPrincipal, false);
        return true;
    }

    public HostServices getHostServices(String host) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getHostServices(host);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public OpenIDConfig getOpenIDConfig() {
        try {
            return this.ztsClient.getOpenIDConfig();
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public JWKList getJWKList(boolean rfcCurveNames) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getJWKList(rfcCurveNames);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public JWKList getJWKList() {
        return this.getJWKList(false);
    }

    public RoleToken getRoleToken(String domainName) {
        return this.getRoleToken(domainName, null, null, null, false, null);
    }

    public RoleToken getRoleToken(String domainName, String roleNames) {
        if (ZTSClient.isEmpty(roleNames)) {
            throw new IllegalArgumentException("RoleNames cannot be null or empty");
        }
        return this.getRoleToken(domainName, roleNames, null, null, false, null);
    }

    public RoleToken getRoleToken(String domainName, String roleNames, Integer minExpiryTime, Integer maxExpiryTime, boolean ignoreCache) {
        return this.getRoleToken(domainName, roleNames, minExpiryTime, maxExpiryTime, ignoreCache, null);
    }

    public RoleToken getRoleToken(String domainName, String roleNames, Integer minExpiryTime, Integer maxExpiryTime, boolean ignoreCache, String proxyForPrincipal) {
        RoleToken roleToken;
        String cacheKey = null;
        if (!cacheDisabled && (cacheKey = this.getRoleTokenCacheKey(domainName, roleNames, proxyForPrincipal)) != null && !ignoreCache) {
            roleToken = this.lookupRoleTokenInCache(cacheKey, minExpiryTime, maxExpiryTime, tokenMinExpiryTime);
            if (roleToken != null) {
                return roleToken;
            }
            if (this.enablePrefetch && prefetchAutoEnable) {
                if (this.prefetchRoleToken(domainName, roleNames, minExpiryTime, maxExpiryTime, proxyForPrincipal)) {
                    roleToken = this.lookupRoleTokenInCache(cacheKey, minExpiryTime, maxExpiryTime, tokenMinExpiryTime);
                }
                if (roleToken != null) {
                    return roleToken;
                }
                LOG.error("GetRoleToken: cache prefetch and lookup error");
            }
        }
        for (ZTSClientService provider : ztsTokenProviders) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getRoleToken: found service provider={}", (Object)provider);
            }
            if ((roleToken = provider.fetchToken(this.domain, this.service, domainName, roleNames, minExpiryTime, maxExpiryTime, proxyForPrincipal)) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getRoleToken: service provider={} returns token", (Object)provider);
            }
            return roleToken;
        }
        this.updateServicePrincipal();
        try {
            roleToken = this.ztsClient.getRoleToken(domainName, roleNames, minExpiryTime, maxExpiryTime, proxyForPrincipal);
        }
        catch (ResourceException ex) {
            if (cacheKey != null && !ignoreCache && (roleToken = this.lookupRoleTokenInCache(cacheKey, null, null, 1)) != null) {
                return roleToken;
            }
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            if (cacheKey != null && !ignoreCache && (roleToken = this.lookupRoleTokenInCache(cacheKey, null, null, 1)) != null) {
                return roleToken;
            }
            throw new ZTSClientException(400, ex.getMessage());
        }
        if (!cacheDisabled) {
            if (cacheKey == null) {
                cacheKey = this.getRoleTokenCacheKey(domainName, roleNames, proxyForPrincipal);
            }
            if (cacheKey != null) {
                ROLE_TOKEN_CACHE.put(cacheKey, roleToken);
            }
        }
        return roleToken;
    }

    public AccessTokenResponse getAccessToken(String domainName, List<String> roleNames, long expiryTime) {
        return this.getAccessToken(domainName, roleNames, null, null, null, null, expiryTime, false);
    }

    public AccessTokenResponse getAccessToken(String domainName, String roleName, String authorizationDetails, long expiryTime) {
        return this.getAccessToken(domainName, Collections.singletonList(roleName), null, null, authorizationDetails, null, expiryTime, false);
    }

    public AccessTokenResponse getAccessToken(String domainName, List<String> roleNames, String idTokenServiceName, long expiryTime, boolean ignoreCache) {
        return this.getAccessToken(domainName, roleNames, idTokenServiceName, null, null, null, expiryTime, ignoreCache);
    }

    public AccessTokenResponse getAccessToken(String domainName, List<String> roleNames, String idTokenServiceName, String proxyForPrincipal, String authorizationDetails, long expiryTime, boolean ignoreCache) {
        return this.getAccessToken(domainName, roleNames, idTokenServiceName, proxyForPrincipal, authorizationDetails, null, expiryTime, ignoreCache);
    }

    public AccessTokenResponse getAccessToken(String domainName, List<String> roleNames, String idTokenServiceName, String proxyForPrincipal, String authorizationDetails, String proxyPrincipalSpiffeUris, long expiryTime, boolean ignoreCache) {
        AccessTokenResponse accessTokenResponse = null;
        String cacheKey = null;
        if (!cacheDisabled && (cacheKey = this.getAccessTokenCacheKey(domainName, roleNames, idTokenServiceName, proxyForPrincipal, authorizationDetails, proxyPrincipalSpiffeUris)) != null && !ignoreCache) {
            accessTokenResponse = this.lookupAccessTokenResponseInCache(cacheKey, expiryTime);
            if (accessTokenResponse != null) {
                return accessTokenResponse;
            }
            if (this.enablePrefetch && prefetchAutoEnable) {
                if (this.prefetchAccessToken(domainName, roleNames, idTokenServiceName, proxyForPrincipal, authorizationDetails, proxyPrincipalSpiffeUris, expiryTime)) {
                    accessTokenResponse = this.lookupAccessTokenResponseInCache(cacheKey, expiryTime);
                }
                if (accessTokenResponse != null) {
                    return accessTokenResponse;
                }
                LOG.error("GetAccessToken: cache prefetch and lookup error");
            }
        }
        try {
            accessTokenResponse = ztsAccessTokenFileLoader.lookupAccessTokenFromDisk(domainName, roleNames);
        }
        catch (IOException ex) {
            LOG.error("GetAccessToken: failed to load access token from disk {}", (Object)ex.getMessage());
        }
        if (accessTokenResponse == null) {
            this.updateServicePrincipal();
            try {
                String requestBody = this.generateAccessTokenRequestBody(domainName, roleNames, idTokenServiceName, proxyForPrincipal, authorizationDetails, proxyPrincipalSpiffeUris, expiryTime);
                accessTokenResponse = this.ztsClient.postAccessTokenRequest(requestBody);
            }
            catch (ResourceException ex) {
                if (cacheKey != null && !ignoreCache && (accessTokenResponse = this.lookupAccessTokenResponseInCache(cacheKey, -1L)) != null) {
                    return accessTokenResponse;
                }
                throw new ZTSClientException(ex.getCode(), ex.getData());
            }
            catch (Exception ex) {
                if (cacheKey != null && !ignoreCache && (accessTokenResponse = this.lookupAccessTokenResponseInCache(cacheKey, -1L)) != null) {
                    return accessTokenResponse;
                }
                throw new ZTSClientException(400, ex.getMessage());
            }
        }
        if (!cacheDisabled) {
            if (cacheKey == null) {
                cacheKey = this.getAccessTokenCacheKey(domainName, roleNames, idTokenServiceName, proxyForPrincipal, authorizationDetails, proxyPrincipalSpiffeUris);
            }
            if (cacheKey != null) {
                ACCESS_TOKEN_CACHE.put(cacheKey, new AccessTokenResponseCacheEntry(accessTokenResponse));
            }
        }
        return accessTokenResponse;
    }

    String generateAccessTokenRequestBody(String domainName, List<String> roleNames, String idTokenServiceName, String proxyForPrincipal, String authorizationDetails, String proxyPrincipalSpiffeUris, long expiryTime) throws UnsupportedEncodingException {
        StringBuilder body = new StringBuilder(256);
        body.append("grant_type=client_credentials");
        if (expiryTime > 0L) {
            body.append("&expires_in=").append(expiryTime);
        }
        StringBuilder scope = new StringBuilder(256);
        if (ZTSClient.isEmpty(roleNames)) {
            scope.append(domainName).append(":domain");
        } else {
            for (String role : roleNames) {
                if (scope.length() != 0) {
                    scope.append(' ');
                }
                scope.append(domainName).append(":role.").append(role);
            }
        }
        if (!ZTSClient.isEmpty(idTokenServiceName)) {
            scope.append(" openid ").append(domainName).append(":service.").append(idTokenServiceName);
        }
        String scopeStr = scope.toString();
        body.append("&scope=").append(URLEncoder.encode(scopeStr, "UTF-8"));
        if (!ZTSClient.isEmpty(proxyForPrincipal)) {
            body.append("&proxy_for_principal=").append(URLEncoder.encode(proxyForPrincipal, "UTF-8"));
        }
        if (!ZTSClient.isEmpty(authorizationDetails)) {
            body.append("&authorization_details=").append(URLEncoder.encode(authorizationDetails, "UTF-8"));
        }
        if (!ZTSClient.isEmpty(proxyPrincipalSpiffeUris)) {
            body.append("&proxy_principal_spiffe_uris=").append(URLEncoder.encode(proxyPrincipalSpiffeUris, "UTF-8"));
        }
        return body.toString();
    }

    @Deprecated
    public RoleToken postRoleCertificateRequest(String domainName, String roleName, RoleCertificateRequest req) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.postRoleCertificateRequest(domainName, roleName, req);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getMessage());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public RoleCertificate postRoleCertificateRequest(RoleCertificateRequest req) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.postRoleCertificateRequestExt(req);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getMessage());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public static RoleCertificateRequest generateRoleCertificateRequest(String principalDomain, String principalService, String roleDomainName, String roleName, PrivateKey privateKey, String csrDn, String csrDomain, int expiryTime) {
        String csr;
        if (principalDomain == null || principalService == null) {
            throw new IllegalArgumentException("Principal's Domain and Service must be specified");
        }
        if (roleDomainName == null || roleName == null) {
            throw new IllegalArgumentException("Role DomainName and Name must be specified");
        }
        if (csrDomain == null) {
            throw new IllegalArgumentException("X509 CSR Domain must be specified");
        }
        String domain = principalDomain.toLowerCase();
        String service = principalService.toLowerCase();
        String rnDomain = roleDomainName.toLowerCase();
        String rnName = roleName.toLowerCase();
        String dn = "cn=" + rnDomain + ":role." + rnName;
        if (csrDn != null) {
            dn = dn.concat(",").concat(csrDn);
        }
        String hostName = service + '.' + domain.replace('.', '-') + '.' + csrDomain;
        String email = domain + "." + service + "@" + csrDomain;
        GeneralName[] sanArray = new GeneralName[4];
        sanArray[0] = new GeneralName(2, (ASN1Encodable)new DERIA5String(hostName));
        sanArray[1] = new GeneralName(1, (ASN1Encodable)new DERIA5String(email));
        String spiffeUri = SPIFFE_URI + rnDomain + SPIFFE_COMP_ROLE + rnName;
        sanArray[2] = new GeneralName(6, (ASN1Encodable)new DERIA5String(spiffeUri));
        String principalUri = "athenz://principal/" + domain + "." + service;
        sanArray[3] = new GeneralName(6, (ASN1Encodable)new DERIA5String(principalUri));
        try {
            csr = Crypto.generateX509CSR((PrivateKey)privateKey, (String)dn, (GeneralName[])sanArray);
        }
        catch (IOException | OperatorCreationException ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
        return new RoleCertificateRequest().setCsr(csr).setExpiryTime((long)expiryTime);
    }

    public static RoleCertificateRequest generateRoleCertificateRequest(String principalDomain, String principalService, String roleDomainName, String roleName, PrivateKey privateKey, String cloud, int expiryTime) {
        if (cloud == null) {
            throw new IllegalArgumentException("Cloud Environment must be specified");
        }
        String csrDomain = x509CsrDomain != null ? cloud + "." + x509CsrDomain : cloud;
        return ZTSClient.generateRoleCertificateRequest(principalDomain, principalService, roleDomainName, roleName, privateKey, x509CsrDn, csrDomain, expiryTime);
    }

    public static InstanceRefreshRequest generateInstanceRefreshRequest(String principalDomain, String principalService, PrivateKey privateKey, String csrDn, String csrDomain, int expiryTime) {
        String csr;
        if (principalDomain == null || principalService == null) {
            throw new IllegalArgumentException("Principal's Domain and Service must be specified");
        }
        if (csrDomain == null) {
            throw new IllegalArgumentException("X509 CSR Domain must be specified");
        }
        String domain = principalDomain.toLowerCase();
        String service = principalService.toLowerCase();
        String cn = domain + "." + service;
        String dn = "cn=" + cn;
        if (csrDn != null) {
            dn = dn.concat(",").concat(csrDn);
        }
        GeneralName[] sanArray = new GeneralName[2];
        String hostName = service + '.' + domain.replace('.', '-') + '.' + csrDomain;
        sanArray[0] = new GeneralName(2, (ASN1Encodable)new DERIA5String(hostName));
        String spiffeUri = SPIFFE_URI + domain + SPIFFE_COMP_SERVICE + service;
        sanArray[1] = new GeneralName(6, (ASN1Encodable)new DERIA5String(spiffeUri));
        try {
            csr = Crypto.generateX509CSR((PrivateKey)privateKey, (String)dn, (GeneralName[])sanArray);
        }
        catch (IOException | OperatorCreationException ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
        return new InstanceRefreshRequest().setCsr(csr).setExpiryTime(Integer.valueOf(expiryTime));
    }

    public static InstanceRefreshRequest generateInstanceRefreshRequest(String principalDomain, String principalService, PrivateKey privateKey, String cloud, int expiryTime) {
        if (cloud == null) {
            throw new IllegalArgumentException("Cloud Environment must be specified");
        }
        String csrDomain = x509CsrDomain != null ? cloud + "." + x509CsrDomain : cloud;
        return ZTSClient.generateInstanceRefreshRequest(principalDomain, principalService, privateKey, x509CsrDn, csrDomain, expiryTime);
    }

    static void processPrefetchTask(PrefetchTokenScheduledItem item, ZTSClient itemZtsClient, Set<String> svcLoaderCache, long currentTime) {
        ZTSRDLGeneratedClient savedZtsClient = itemZtsClient.ztsClient;
        if (item.ztsClient != null) {
            itemZtsClient.ztsClient = item.ztsClient;
        }
        try {
            switch (item.tokenType) {
                case ROLE: {
                    RoleToken token = itemZtsClient.getRoleToken(item.domainName, item.roleName, item.minDuration, item.maxDuration, true, item.proxyForPrincipal);
                    item.setExpiresAtUTC(token.getExpiryTime());
                    break;
                }
                case ACCESS: {
                    AccessTokenResponse response = itemZtsClient.getAccessToken(item.domainName, item.roleNames, item.idTokenServiceName, item.proxyForPrincipal, item.authorizationDetails, item.maxDuration.intValue(), true);
                    item.setExpiresAtUTC(System.currentTimeMillis() / 1000L + (long)response.getExpires_in().intValue());
                    break;
                }
                case AWS: {
                    AWSTemporaryCredentials awsCred = itemZtsClient.getAWSTemporaryCredentials(item.domainName, item.roleName, item.externalId, item.minDuration, item.maxDuration, true);
                    item.setExpiresAtUTC(awsCred.getExpiration().millis() / 1000L);
                    break;
                }
                case SVC_ROLE: {
                    if (svcLoaderCache == null || svcLoaderCache.contains(item.cacheKey)) break;
                    item.setIsInvalid(true);
                    PREFETCH_SCHEDULED_ITEMS.remove(item);
                }
            }
            item.setFetchTime(currentTime);
            item.setLastFailTime(0L);
        }
        catch (ZTSClientException ex) {
            LOG.error("PrefetchTask: Error while trying to prefetch token", (Throwable)ex);
            int code = ex.getCode();
            if (code == 401 || code == 403) {
                item.setIsInvalid(true);
                item.setLastFailTime(currentTime);
                PREFETCH_SCHEDULED_ITEMS.remove(item);
            } else {
                item.setLastFailTime(currentTime);
            }
        }
        catch (Exception ex) {
            item.setLastFailTime(currentTime);
            item.setIsInvalid(true);
            PREFETCH_SCHEDULED_ITEMS.remove(item);
            LOG.error("PrefetchTask: Error while trying to prefetch token", (Throwable)ex);
        }
        if (item.shouldSendNotification()) {
            ZTSClientNotification ztsClientNotification = new ZTSClientNotification(itemZtsClient.getZTSUrl(), item.roleName, item.tokenType.toString(), item.expiresAtUTC, item.isInvalid, item.domainName);
            item.lastNotificationTime = currentTime;
            item.notificationSender.sendNotification(ztsClientNotification);
        }
        itemZtsClient.ztsClient = savedZtsClient;
    }

    int getScheduledItemsSize() {
        return PREFETCH_SCHEDULED_ITEMS.size();
    }

    boolean prefetchRoleToken(String domainName, String roleName, Integer minExpiryTime, Integer maxExpiryTime) {
        return this.prefetchRoleToken(domainName, roleName, minExpiryTime, maxExpiryTime, null);
    }

    boolean prefetchRoleToken(String domainName, String roleName, Integer minExpiryTime, Integer maxExpiryTime, String proxyForPrincipal) {
        if (domainName == null || domainName.trim().isEmpty()) {
            throw new ZTSClientException(400, "Domain Name cannot be empty");
        }
        RoleToken token = this.getRoleToken(domainName, roleName, minExpiryTime, maxExpiryTime, true, proxyForPrincipal);
        if (token == null) {
            LOG.error("PrefetchToken: No token fetchable using domain={}, roleSuffix={}", (Object)domainName, (Object)roleName);
            return false;
        }
        long expiryTimeUTC = token.getExpiryTime();
        return this.prefetchToken(domainName, roleName, null, minExpiryTime, maxExpiryTime, proxyForPrincipal, null, null, null, expiryTimeUTC, TokenType.ROLE);
    }

    boolean prefetchAwsCreds(String domainName, String roleName, String externalId, Integer minExpiryTime, Integer maxExpiryTime) {
        if (domainName == null || domainName.trim().isEmpty()) {
            throw new ZTSClientException(400, "Domain Name cannot be empty");
        }
        AWSTemporaryCredentials awsCred = this.getAWSTemporaryCredentials(domainName, roleName, externalId, minExpiryTime, maxExpiryTime, true);
        if (awsCred == null) {
            LOG.error("PrefetchToken: No aws credential fetchable using domain={}, roleName={}", (Object)domainName, (Object)roleName);
            return false;
        }
        long expiryTimeUTC = awsCred.getExpiration().millis() / 1000L;
        return this.prefetchToken(domainName, roleName, null, minExpiryTime, maxExpiryTime, null, externalId, null, null, expiryTimeUTC, TokenType.AWS);
    }

    public boolean prefetchAccessToken(String domainName, List<String> roleNames, String idTokenServiceName, String proxyForPrincipal, String authorizationDetails, String proxyPrincipalSpiffeUris, long expiryTime) {
        if (domainName == null || domainName.trim().isEmpty()) {
            throw new ZTSClientException(400, "Domain Name cannot be empty");
        }
        AccessTokenResponse tokenResponse = this.getAccessToken(domainName, roleNames, idTokenServiceName, proxyForPrincipal, authorizationDetails, proxyPrincipalSpiffeUris, expiryTime, true);
        if (tokenResponse == null) {
            LOG.error("PrefetchToken: No access token fetchable using domain={}", (Object)domainName);
            return false;
        }
        long expiryTimeUTC = System.currentTimeMillis() / 1000L + (long)tokenResponse.getExpires_in().intValue();
        return this.prefetchToken(domainName, null, roleNames, null, (int)expiryTime, proxyForPrincipal, null, idTokenServiceName, authorizationDetails, expiryTimeUTC, TokenType.ACCESS);
    }

    boolean prefetchToken(String domainName, String roleName, List<String> roleNames, Integer minExpiryTime, Integer maxExpiryTime, String proxyForPrincipal, String externalId, String idTokenServiceName, String authorizationDetails, long expiryTimeUTC, TokenType tokenType) {
        if (this.sslContext == null && (ZTSClient.isEmpty(this.domain) || ZTSClient.isEmpty(this.service))) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("PrefetchToken: setup failure. Both domain({}) and service({}) are required", (Object)this.domain, (Object)this.service);
            }
            return false;
        }
        PrefetchTokenScheduledItem item = new PrefetchTokenScheduledItem().setTokenType(tokenType).setFetchTime(System.currentTimeMillis() / 1000L).setDomainName(domainName).setRoleName(roleName).setRoleNames(roleNames).setProxyForPrincipal(proxyForPrincipal).setExternalId(externalId).setMinDuration(minExpiryTime).setMaxDuration(maxExpiryTime).setExpiresAtUTC(expiryTimeUTC).setIdTokenServiceName(idTokenServiceName).setAuthorizationDetails(authorizationDetails).setIdentityDomain(this.domain).setIdentityName(this.service).setTokenMinExpiryTime(tokenMinExpiryTime).setProvidedZTSUrl(this.ztsUrl).setSiaIdentityProvider(this.siaProvider).setSslContext(this.sslContext).setProxyUrl(this.proxyUrl).setNotificationSender(this.notificationSender);
        if (this.ztsClientOverride) {
            item.setZtsClient(this.ztsClient);
        }
        PREFETCH_SCHEDULED_ITEMS.remove(item);
        PREFETCH_SCHEDULED_ITEMS.add(item);
        ZTSClient.startPrefetch();
        return true;
    }

    String getAccessTokenCacheKey(String domainName, List<String> roleNames, String idTokenServiceName, String proxyForPrincipal, String authorizationDetails, String proxyPrincipalSpiffeUris) {
        String tenantDomain = this.domain;
        if (this.domain == null && this.sslContext != null) {
            tenantDomain = this.sslContext.toString();
        }
        return ZTSClient.getAccessTokenCacheKey(tenantDomain, this.service, domainName, roleNames, idTokenServiceName, proxyForPrincipal, authorizationDetails, proxyPrincipalSpiffeUris);
    }

    static String getAccessTokenCacheKey(String tenantDomain, String tenantService, String domainName, List<String> roleNames, String idTokenServiceName, String proxyForPrincipal, String authorizationDetails, String proxyPrincipalSpiffeUris) {
        if (tenantDomain == null) {
            return null;
        }
        StringBuilder cacheKey = new StringBuilder(256);
        cacheKey.append("p=");
        cacheKey.append(tenantDomain);
        if (tenantService != null) {
            cacheKey.append(".").append(tenantService);
        }
        cacheKey.append(";d=");
        cacheKey.append(domainName);
        if (!ZTSClient.isEmpty(roleNames)) {
            cacheKey.append(";r=");
            cacheKey.append(ZTSClient.multipleRoleKey(roleNames));
        }
        if (!ZTSClient.isEmpty(idTokenServiceName)) {
            cacheKey.append(";o=");
            cacheKey.append(idTokenServiceName);
        }
        if (!ZTSClient.isEmpty(proxyForPrincipal)) {
            cacheKey.append(";u=");
            cacheKey.append(proxyForPrincipal);
        }
        if (!ZTSClient.isEmpty(authorizationDetails)) {
            cacheKey.append(";z=");
            cacheKey.append(Base64.getUrlEncoder().withoutPadding().encodeToString(Crypto.sha256((String)authorizationDetails)));
        }
        if (!ZTSClient.isEmpty(proxyPrincipalSpiffeUris)) {
            cacheKey.append(";s=");
            cacheKey.append(proxyPrincipalSpiffeUris);
        }
        return cacheKey.toString();
    }

    String getRoleTokenCacheKey(String domainName, String roleName, String proxyForPrincipal) {
        String tenantDomain = this.domain;
        if (this.domain == null && this.sslContext != null) {
            tenantDomain = this.sslContext.toString();
        }
        return ZTSClient.getRoleTokenCacheKey(tenantDomain, this.service, domainName, roleName, proxyForPrincipal);
    }

    static String getRoleTokenCacheKey(String tenantDomain, String tenantService, String domainName, String roleName, String proxyForPrincipal) {
        if (tenantDomain == null) {
            return null;
        }
        StringBuilder cacheKey = new StringBuilder(256);
        cacheKey.append("p=");
        cacheKey.append(tenantDomain);
        if (tenantService != null) {
            cacheKey.append(".").append(tenantService);
        }
        cacheKey.append(";d=");
        cacheKey.append(domainName);
        if (roleName != null && !roleName.isEmpty()) {
            cacheKey.append(";r=");
            if (roleName.indexOf(44) == -1) {
                cacheKey.append(roleName);
            } else {
                List<String> roles = Arrays.asList(roleName.split(","));
                cacheKey.append(ZTSClient.multipleRoleKey(roles));
            }
        }
        if (proxyForPrincipal != null && !proxyForPrincipal.isEmpty()) {
            cacheKey.append(";u=");
            cacheKey.append(proxyForPrincipal);
        }
        return cacheKey.toString();
    }

    static boolean isExpiredToken(long expiryTime, Integer minExpiryTime, Integer maxExpiryTime, int tokenMinExpiryTime) {
        if (minExpiryTime != null && expiryTime < (long)minExpiryTime.intValue()) {
            return true;
        }
        if (maxExpiryTime != null && expiryTime > (long)(maxExpiryTime + tokenMaxExpiryOffset)) {
            return true;
        }
        return minExpiryTime == null && maxExpiryTime == null && expiryTime < (long)tokenMinExpiryTime;
    }

    RoleToken lookupRoleTokenInCache(String cacheKey, Integer minExpiryTime, Integer maxExpiryTime, int serverMinExpiryTime) {
        RoleToken roleToken = ROLE_TOKEN_CACHE.get(cacheKey);
        if (roleToken == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("LookupRoleTokenInCache: cache-lookup key: {} result: not found", (Object)cacheKey);
            }
            return null;
        }
        long expiryTime = roleToken.getExpiryTime() - System.currentTimeMillis() / 1000L;
        if (ZTSClient.isExpiredToken(expiryTime, minExpiryTime, maxExpiryTime, serverMinExpiryTime)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("LookupRoleTokenInCache: role-cache-lookup key: {} token-expiry: {} req-min-expiry: {} req-max-expiry: {} client-min-expiry: {} result: expired", new Object[]{cacheKey, expiryTime, minExpiryTime, maxExpiryTime, serverMinExpiryTime});
            }
            if (expiryTime < 1L) {
                ROLE_TOKEN_CACHE.remove(cacheKey);
            }
            return null;
        }
        return roleToken;
    }

    AccessTokenResponse lookupAccessTokenResponseInCache(String cacheKey, long expiryTime) {
        AccessTokenResponseCacheEntry accessTokenResponseCacheEntry = ACCESS_TOKEN_CACHE.get(cacheKey);
        if (accessTokenResponseCacheEntry == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("LookupAccessTokenResponseInCache: cache-lookup key: {} result: not found", (Object)cacheKey);
            }
            return null;
        }
        if (accessTokenResponseCacheEntry.isExpired(expiryTime)) {
            if (accessTokenResponseCacheEntry.isExpired(-1L)) {
                ACCESS_TOKEN_CACHE.remove(cacheKey);
            }
            return null;
        }
        return accessTokenResponseCacheEntry.accessTokenResponse();
    }

    AWSTemporaryCredentials lookupAwsCredInCache(String cacheKey, Integer minExpiryTime, Integer maxExpiryTime) {
        AWSTemporaryCredentials awsCred = AWS_CREDS_CACHE.get(cacheKey);
        if (awsCred == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("LookupAwsCredInCache: aws-cache-lookup key: {} result: not found", (Object)cacheKey);
            }
            return null;
        }
        long expiryTime = awsCred.getExpiration().millis() - System.currentTimeMillis();
        if (ZTSClient.isExpiredToken(expiryTime /= 1000L, minExpiryTime, maxExpiryTime, tokenMinExpiryTime)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("LookupAwsCredInCache: aws-cache-lookup key: {} token-expiry: {} req-min-expiry: {} req-max-expiry: {} client-min-expiry: {} result: expired", new Object[]{cacheKey, expiryTime, minExpiryTime, maxExpiryTime, tokenMinExpiryTime});
            }
            if (expiryTime < 1L) {
                AWS_CREDS_CACHE.remove(cacheKey);
            }
            return null;
        }
        return awsCred;
    }

    public RoleAccess getRoleAccess(String domainName, String principal) {
        RoleAccess cachedValue;
        this.updateServicePrincipal();
        ZTSClientCache.DomainAndPrincipal cacheKey = null;
        Cache<ZTSClientCache.DomainAndPrincipal, RoleAccess> cache = this.ztsClientCache.getRoleAccessCache();
        if (cache != null && (cachedValue = (RoleAccess)cache.get((Object)(cacheKey = new ZTSClientCache.DomainAndPrincipal(domainName, principal)))) != null) {
            return cachedValue;
        }
        try {
            RoleAccess roleAccess = this.ztsClient.getRoleAccess(domainName, principal);
            if (cache != null) {
                cache.put((Object)cacheKey, (Object)roleAccess);
            }
            return roleAccess;
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getMessage());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public ServiceIdentity getServiceIdentity(String domainName, String serviceName) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getServiceIdentity(domainName, serviceName);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public PublicKeyEntry getPublicKeyEntry(String domainName, String serviceName, String keyId) {
        try {
            return this.ztsClient.getPublicKeyEntry(domainName, serviceName, keyId);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public ServiceIdentityList getServiceIdentityList(String domainName) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getServiceIdentityList(domainName);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public RoleAccess getRolesRequireRoleCert(String principal) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getRolesRequireRoleCert(principal);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public TenantDomains getTenantDomains(String providerDomainName, String userName, String roleName, String serviceName) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getTenantDomains(providerDomainName, userName, roleName, serviceName);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public Identity postInstanceRefreshRequest(String domain, String service, InstanceRefreshRequest req) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.postInstanceRefreshRequest(domain, service, req);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public AWSLambdaIdentity getAWSLambdaServiceCertificate(String domainName, String serviceName, String account, String provider) {
        if (domainName == null || serviceName == null) {
            throw new IllegalArgumentException("Domain and Service must be specified");
        }
        if (account == null || provider == null) {
            throw new IllegalArgumentException("AWS Account and Provider must be specified");
        }
        if (x509CsrDomain == null) {
            throw new IllegalArgumentException("X509 CSR Domain must be specified");
        }
        AWSLambdaIdentity lambdaIdentity = new AWSLambdaIdentity();
        try {
            lambdaIdentity.setPrivateKey(Crypto.generateRSAPrivateKey((int)2048));
        }
        catch (CryptoException ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
        InstanceRegisterInformation info = new InstanceRegisterInformation();
        info.setDomain(domainName.toLowerCase());
        info.setService(serviceName.toLowerCase());
        info.setProvider(provider.toLowerCase());
        String athenzService = info.getDomain() + "." + info.getService();
        StringBuilder dnBuilder = new StringBuilder(128);
        dnBuilder.append("cn=");
        dnBuilder.append(athenzService);
        if (x509CsrDn != null) {
            dnBuilder.append(',');
            dnBuilder.append(x509CsrDn);
        }
        GeneralName[] sanArray = new GeneralName[3];
        String hostBuilder = info.getService() + '.' + info.getDomain().replace('.', '-') + '.' + x509CsrDomain;
        sanArray[0] = new GeneralName(2, (ASN1Encodable)new DERIA5String(hostBuilder));
        String instanceHostBuilder = "lambda-" + account + '-' + info.getService() + ".instanceid.athenz." + x509CsrDomain;
        sanArray[1] = new GeneralName(2, (ASN1Encodable)new DERIA5String(instanceHostBuilder));
        String spiffeUri = SPIFFE_URI + info.getDomain() + SPIFFE_COMP_SERVICE + info.getService();
        sanArray[2] = new GeneralName(6, (ASN1Encodable)new DERIA5String(spiffeUri));
        try {
            info.setCsr(Crypto.generateX509CSR((PrivateKey)lambdaIdentity.getPrivateKey(), (String)dnBuilder.toString(), (GeneralName[])sanArray));
        }
        catch (IOException | OperatorCreationException ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
        info.setAttestationData(this.getAWSLambdaAttestationData(athenzService, account));
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        InstanceIdentity identity = this.postInstanceRegisterInformation(info, responseHeaders);
        try {
            lambdaIdentity.setX509Certificate(Crypto.loadX509Certificate((String)identity.getX509Certificate()));
        }
        catch (CryptoException ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
        lambdaIdentity.setCaCertificates(identity.getX509CertificateSigner());
        return lambdaIdentity;
    }

    String getAWSLambdaAttestationData(String athenzService, String account) {
        AWSAttestationData data = new AWSAttestationData();
        data.setRole(athenzService);
        Credentials awsCreds = this.assumeAWSRole(account, athenzService);
        data.setAccess(awsCreds.getAccessKeyId());
        data.setSecret(awsCreds.getSecretAccessKey());
        data.setToken(awsCreds.getSessionToken());
        ObjectMapper mapper = new ObjectMapper();
        String jsonData = null;
        try {
            jsonData = mapper.writeValueAsString((Object)data);
        }
        catch (JsonProcessingException ex) {
            LOG.error("Unable to generate attestation json data: {}", (Object)ex.getMessage());
        }
        return jsonData;
    }

    AssumeRoleRequest getAssumeRoleRequest(String account, String roleName) {
        String arn = "arn:aws:iam::" + account + ":role/" + roleName;
        AssumeRoleRequest req = new AssumeRoleRequest();
        req.setRoleArn(arn);
        req.setRoleSessionName(roleName);
        return req;
    }

    Credentials assumeAWSRole(String account, String roleName) {
        try {
            AssumeRoleRequest req = this.getAssumeRoleRequest(account, roleName);
            return AWSSecurityTokenServiceClientBuilder.defaultClient().assumeRole(req).getCredentials();
        }
        catch (Exception ex) {
            LOG.error("assumeAWSRole - unable to assume role: {}", (Object)ex.getMessage());
            return null;
        }
    }

    public AWSCredentialsProvider getAWSCredentialProvider(String domainName, String roleName) {
        return new AWSCredentialsProviderImpl(this, domainName, roleName);
    }

    public AWSCredentialsProvider getAWSCredentialProvider(String domainName, String roleName, String externalId, Integer minExpiryTime, Integer maxExpiryTime) {
        return new AWSCredentialsProviderImpl(this, domainName, roleName, externalId, minExpiryTime, maxExpiryTime);
    }

    public AWSTemporaryCredentials getAWSTemporaryCredentials(String domainName, String roleName) {
        return this.getAWSTemporaryCredentials(domainName, roleName, null, null, null, false);
    }

    public AWSTemporaryCredentials getAWSTemporaryCredentials(String domainName, String roleName, boolean ignoreCache) {
        return this.getAWSTemporaryCredentials(domainName, roleName, null, null, null, ignoreCache);
    }

    public AWSTemporaryCredentials getAWSTemporaryCredentials(String domainName, String roleName, String externalId, Integer minExpiryTime, Integer maxExpiryTime) {
        return this.getAWSTemporaryCredentials(domainName, roleName, externalId, minExpiryTime, maxExpiryTime, false);
    }

    public AWSTemporaryCredentials getAWSTemporaryCredentials(String domainName, String roleName, String externalId, Integer minExpiryTime, Integer maxExpiryTime, boolean ignoreCache) {
        AWSTemporaryCredentials awsCred;
        try {
            roleName = URLEncoder.encode(roleName, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("Unable to encode {} - error {}", (Object)roleName, (Object)ex.getMessage());
        }
        String cacheKey = this.getRoleTokenCacheKey(domainName, roleName, null);
        if (cacheKey != null && !ignoreCache) {
            awsCred = this.lookupAwsCredInCache(cacheKey, minExpiryTime, maxExpiryTime);
            if (awsCred != null) {
                return awsCred;
            }
            if (this.enablePrefetch && prefetchAutoEnable) {
                if (this.prefetchAwsCreds(domainName, roleName, externalId, minExpiryTime, maxExpiryTime)) {
                    awsCred = this.lookupAwsCredInCache(cacheKey, minExpiryTime, maxExpiryTime);
                }
                if (awsCred != null) {
                    return awsCred;
                }
                LOG.error("GetAWSTemporaryCredentials: cache prefetch and lookup error");
            }
        }
        this.updateServicePrincipal();
        try {
            awsCred = this.ztsClient.getAWSTemporaryCredentials(domainName, roleName, maxExpiryTime, externalId);
        }
        catch (ResourceException ex) {
            if (cacheKey != null && !ignoreCache && (awsCred = this.lookupAwsCredInCache(cacheKey, null, null)) != null) {
                return awsCred;
            }
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            if (cacheKey != null && !ignoreCache && (awsCred = this.lookupAwsCredInCache(cacheKey, null, null)) != null) {
                return awsCred;
            }
            throw new ZTSClientException(400, ex.getMessage());
        }
        if (awsCred != null) {
            if (cacheKey == null) {
                cacheKey = this.getRoleTokenCacheKey(domainName, roleName, null);
            }
            if (cacheKey != null) {
                AWS_CREDS_CACHE.put(cacheKey, awsCred);
            }
        }
        return awsCred;
    }

    public DomainSignedPolicyData getDomainSignedPolicyData(String domainName, String matchingTag, Map<String, List<String>> responseHeaders) {
        try {
            return this.ztsClient.getDomainSignedPolicyData(domainName, matchingTag, responseHeaders);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public JWSPolicyData postSignedPolicyRequest(String domainName, SignedPolicyRequest request, String matchingTag, Map<String, List<String>> responseHeaders) {
        try {
            return this.ztsClient.postSignedPolicyRequest(domainName, request, matchingTag, responseHeaders);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public Access getAccess(String domainName, String roleName, String principal) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getAccess(domainName, roleName, principal);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public ResourceAccess getResourceAccess(String action, String resource, String trustDomain, String principal) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getResourceAccess(action, resource, trustDomain, principal);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getMessage());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public ResourceAccess getResourceAccessExt(String action, String resource, String trustDomain, String principal) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getResourceAccessExt(action, resource, trustDomain, principal);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getMessage());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public InstanceIdentity postInstanceRegisterInformation(InstanceRegisterInformation info, Map<String, List<String>> responseHeaders) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.postInstanceRegisterInformation(info, responseHeaders);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public InstanceIdentity postInstanceRefreshInformation(String provider, String domain, String service, String instanceId, InstanceRefreshInformation info) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.postInstanceRefreshInformation(provider, domain, service, instanceId, info);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public void deleteInstanceIdentity(String provider, String domain, String service, String instanceId) {
        this.updateServicePrincipal();
        try {
            this.ztsClient.deleteInstanceIdentity(provider, domain, service, instanceId);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public CertificateAuthorityBundle getCertificateAuthorityBundle(String bundleName) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getCertificateAuthorityBundle(bundleName);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public Workloads getWorkloadsByIP(String ipAddress) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getWorkloadsByIP(ipAddress);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public Workloads getWorkloadsByService(String domain, String service) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getWorkloadsByService(domain, service);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public TransportRules getTransportRules(String domain, String service) {
        this.updateServicePrincipal();
        try {
            return this.ztsClient.getTransportRules(domain, service);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    public InstanceRegisterToken getInstanceRegisterToken(String provider, String domain, String service, String instanceId) {
        try {
            return this.ztsClient.getInstanceRegisterToken(provider, domain, service, instanceId);
        }
        catch (ResourceException ex) {
            throw new ZTSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZTSClientException(400, ex.getMessage());
        }
    }

    private static Set<String> loadSvcProviderTokens() {
        ztsTokenProviders = ServiceLoader.load(ZTSClientService.class);
        svcLoaderCacheKeys = new AtomicReference();
        HashSet<String> cacheKeySet = new HashSet<String>();
        for (ZTSClientService provider : ztsTokenProviders) {
            Collection<ZTSClientService.RoleTokenDescriptor> descs = provider.loadTokens();
            if (descs == null) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("loadSvcProviderTokens: provider didn't return tokens: prov={}", (Object)provider);
                continue;
            }
            for (ZTSClientService.RoleTokenDescriptor desc : descs) {
                String key;
                if (desc.signedToken == null || (key = ZTSClient.cacheSvcProvRoleToken(desc)) == null) continue;
                cacheKeySet.add(key);
            }
        }
        svcLoaderCacheKeys.set(cacheKeySet);
        return cacheKeySet;
    }

    static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    static boolean isEmpty(List<String> list) {
        return list == null || list.isEmpty();
    }

    static String multipleRoleKey(List<String> roles) {
        if (roles == null || roles.isEmpty()) {
            return null;
        }
        if (roles.size() == 1) {
            return roles.get(0);
        }
        ArrayList<String> modList = new ArrayList<String>(roles);
        Collections.sort(modList);
        return String.join((CharSequence)",", modList);
    }

    static String cacheSvcProvRoleToken(ZTSClientService.RoleTokenDescriptor desc) {
        if (cacheDisabled) {
            return null;
        }
        com.yahoo.athenz.auth.token.RoleToken rt = new com.yahoo.athenz.auth.token.RoleToken(desc.getSignedToken());
        String domainName = rt.getDomain();
        String principalName = rt.getPrincipal();
        boolean completeRoleSet = rt.getDomainCompleteRoleSet();
        String roleName = completeRoleSet ? null : ZTSClient.multipleRoleKey(rt.getRoles());
        int index = principalName.lastIndexOf(46);
        if (index == -1) {
            LOG.error("cacheSvcProvRoleToken: Invalid principal in token: {}", (Object)rt.getSignedToken());
            return null;
        }
        String tenantDomain = principalName.substring(0, index);
        String tenantService = principalName.substring(index + 1);
        Long expiryTime = rt.getExpiryTime();
        RoleToken roleToken = new RoleToken().setToken(desc.getSignedToken()).setExpiryTime(expiryTime.longValue());
        String key = ZTSClient.getRoleTokenCacheKey(tenantDomain, tenantService, domainName, roleName, null);
        if (LOG.isInfoEnabled()) {
            LOG.info("cacheSvcProvRoleToken: cache-add key: {} expiry: {}", (Object)key, (Object)expiryTime);
        }
        ROLE_TOKEN_CACHE.put(key, roleToken);
        ZTSClient.prefetchSvcProvTokens(tenantDomain, tenantService, domainName, key, roleName, null, null, expiryTime, null);
        return key;
    }

    static void prefetchSvcProvTokens(String domain, String service, String domainName, String cacheKey, String roleName, Integer minExpiryTime, Integer maxExpiryTime, Long expiryTimeUTC, String proxyForPrincipal) {
        if (domainName == null || domainName.trim().isEmpty()) {
            throw new ZTSClientException(400, "Domain Name cannot be empty");
        }
        PrefetchTokenScheduledItem item = new PrefetchTokenScheduledItem().setTokenType(TokenType.SVC_ROLE).setCacheKey(cacheKey).setDomainName(domainName).setRoleName(roleName).setProxyForPrincipal(proxyForPrincipal).setMinDuration(minExpiryTime).setMaxDuration(maxExpiryTime).setExpiresAtUTC(expiryTimeUTC).setIdentityDomain(domain).setIdentityName(service).setTokenMinExpiryTime(tokenMinExpiryTime);
        PREFETCH_SCHEDULED_ITEMS.remove(item);
        PREFETCH_SCHEDULED_ITEMS.add(item);
        ZTSClient.startPrefetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startPrefetch() {
        if (FETCH_TIMER != null) {
            return;
        }
        Object object = TIMER_LOCK;
        synchronized (object) {
            if (FETCH_TIMER == null) {
                FETCH_TIMER = new Timer(true);
                FETCH_TIMER.schedule((TimerTask)new TokenPrefetchTask(), 0L, prefetchInterval * 1000L);
            }
        }
    }

    static {
        TIMER_LOCK = new Object();
        FETCHER_LAST_RUN_AT = new AtomicLong(-1L);
        KEY_REFRESHER_LISTENER = new ClientKeyRefresherListener();
        PRIVATE_KEY_STORE = ZTSClient.loadServicePrivateKey();
    }

    public class AWSHostNameVerifier
    implements HostnameVerifier {
        String dnsHostname;

        public AWSHostNameVerifier(String hostname) {
            this.dnsHostname = hostname;
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            Certificate[] certs = null;
            try {
                certs = session.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
            if (certs == null) {
                return false;
            }
            for (Certificate cert : certs) {
                try {
                    X509Certificate x509Cert = (X509Certificate)cert;
                    if (!this.matchDnsHostname(x509Cert.getSubjectAlternativeNames())) continue;
                    return true;
                }
                catch (CertificateParsingException certificateParsingException) {
                    // empty catch block
                }
            }
            return false;
        }

        boolean matchDnsHostname(Collection<List<?>> altNames) {
            if (altNames == null) {
                return false;
            }
            for (List<?> item : altNames) {
                String dns;
                Integer type = (Integer)item.get(0);
                if (type != 2 || !this.dnsHostname.equalsIgnoreCase(dns = (String)item.get(1))) continue;
                return true;
            }
            return false;
        }
    }

    static class PrefetchTokenScheduledItem {
        TokenType tokenType = TokenType.ACCESS;
        String providedZTSUrl;
        ServiceIdentityProvider siaProvider;
        ZTSRDLGeneratedClient ztsClient;
        boolean isInvalid = false;
        String identityDomain;
        String identityName;
        String domainName;
        String cacheKey;
        String roleName;
        List<String> roleNames;
        String proxyForPrincipal;
        String externalId;
        String authorizationDetails;
        String idTokenServiceName;
        Integer minDuration;
        Integer maxDuration;
        long expiresAtUTC = 0L;
        long fetchTime = 0L;
        ZTSClientNotificationSender notificationSender = null;
        long lastFailTime = 0L;
        long lastNotificationTime = 0L;
        int tokenMinExpiryTime;
        SSLContext sslContext;
        String proxyUrl;

        PrefetchTokenScheduledItem() {
        }

        PrefetchTokenScheduledItem setTokenType(TokenType type) {
            this.tokenType = type;
            return this;
        }

        PrefetchTokenScheduledItem setProvidedZTSUrl(String u) {
            this.providedZTSUrl = u;
            return this;
        }

        PrefetchTokenScheduledItem setSiaIdentityProvider(ServiceIdentityProvider s) {
            this.siaProvider = s;
            return this;
        }

        PrefetchTokenScheduledItem setZtsClient(ZTSRDLGeneratedClient z) {
            this.ztsClient = z;
            return this;
        }

        PrefetchTokenScheduledItem setIsInvalid(boolean invalid) {
            this.isInvalid = invalid;
            return this;
        }

        PrefetchTokenScheduledItem setIdentityDomain(String d) {
            this.identityDomain = d;
            return this;
        }

        PrefetchTokenScheduledItem setIdentityName(String d) {
            this.identityName = d;
            return this;
        }

        PrefetchTokenScheduledItem setDomainName(String d) {
            this.domainName = d;
            return this;
        }

        PrefetchTokenScheduledItem setCacheKey(String key) {
            this.cacheKey = key;
            return this;
        }

        PrefetchTokenScheduledItem setRoleName(String s) {
            this.roleName = s;
            return this;
        }

        PrefetchTokenScheduledItem setRoleNames(List<String> stringList) {
            this.roleNames = stringList;
            return this;
        }

        PrefetchTokenScheduledItem setProxyForPrincipal(String u) {
            this.proxyForPrincipal = u;
            return this;
        }

        PrefetchTokenScheduledItem setExternalId(String id) {
            this.externalId = id;
            return this;
        }

        PrefetchTokenScheduledItem setAuthorizationDetails(String details) {
            this.authorizationDetails = details;
            return this;
        }

        PrefetchTokenScheduledItem setIdTokenServiceName(String serviceName) {
            this.idTokenServiceName = serviceName;
            return this;
        }

        PrefetchTokenScheduledItem setMinDuration(Integer min) {
            this.minDuration = min;
            return this;
        }

        PrefetchTokenScheduledItem setMaxDuration(Integer max) {
            this.maxDuration = max;
            return this;
        }

        PrefetchTokenScheduledItem setExpiresAtUTC(long e) {
            this.expiresAtUTC = e;
            return this;
        }

        PrefetchTokenScheduledItem setFetchTime(long time) {
            this.fetchTime = time;
            return this;
        }

        PrefetchTokenScheduledItem setNotificationSender(ZTSClientNotificationSender notificationSender) {
            this.notificationSender = notificationSender;
            return this;
        }

        PrefetchTokenScheduledItem setLastFailTime(long time) {
            this.lastFailTime = time;
            return this;
        }

        PrefetchTokenScheduledItem setLastNotificationTime(long time) {
            this.lastNotificationTime = time;
            return this;
        }

        PrefetchTokenScheduledItem setTokenMinExpiryTime(int t) {
            this.tokenMinExpiryTime = t;
            return this;
        }

        PrefetchTokenScheduledItem setSslContext(SSLContext ctx) {
            this.sslContext = ctx;
            return this;
        }

        PrefetchTokenScheduledItem setProxyUrl(String url) {
            this.proxyUrl = url;
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.domainName == null ? 0 : this.domainName.hashCode());
            result = 31 * result + (this.identityDomain == null ? 0 : this.identityDomain.hashCode());
            result = 31 * result + (this.identityName == null ? 0 : this.identityName.hashCode());
            result = 31 * result + (this.roleName == null ? 0 : this.roleName.hashCode());
            result = 31 * result + (this.roleNames == null ? 0 : this.roleNames.hashCode());
            result = 31 * result + (this.proxyForPrincipal == null ? 0 : this.proxyForPrincipal.hashCode());
            result = 31 * result + (this.externalId == null ? 0 : this.externalId.hashCode());
            result = 31 * result + (this.idTokenServiceName == null ? 0 : this.idTokenServiceName.hashCode());
            result = 31 * result + (this.sslContext == null ? 0 : this.sslContext.hashCode());
            result = 31 * result + (this.proxyUrl == null ? 0 : this.proxyUrl.hashCode());
            result = 31 * result + this.tokenType.hashCode();
            result = 31 * result + Boolean.hashCode(this.isInvalid);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrefetchTokenScheduledItem other = (PrefetchTokenScheduledItem)obj;
            if (this.domainName == null ? other.domainName != null : !this.domainName.equals(other.domainName)) {
                return false;
            }
            if (this.identityDomain == null ? other.identityDomain != null : !this.identityDomain.equals(other.identityDomain)) {
                return false;
            }
            if (this.identityName == null ? other.identityName != null : !this.identityName.equals(other.identityName)) {
                return false;
            }
            if (this.roleName == null ? other.roleName != null : !this.roleName.equals(other.roleName)) {
                return false;
            }
            if (this.roleNames == null ? other.roleNames != null : !this.roleNames.equals(other.roleNames)) {
                return false;
            }
            if (this.proxyForPrincipal == null ? other.proxyForPrincipal != null : !this.proxyForPrincipal.equals(other.proxyForPrincipal)) {
                return false;
            }
            if (this.externalId == null ? other.externalId != null : !this.externalId.equals(other.externalId)) {
                return false;
            }
            if (this.idTokenServiceName == null ? other.idTokenServiceName != null : !this.idTokenServiceName.equals(other.idTokenServiceName)) {
                return false;
            }
            if (this.isInvalid != other.isInvalid) {
                return false;
            }
            if (this.tokenType != other.tokenType) {
                return false;
            }
            if (this.sslContext == null) {
                return other.sslContext == null;
            }
            return this.sslContext.equals(other.sslContext);
        }

        public boolean shouldSendNotification() {
            if (this.notificationSender == null) {
                return false;
            }
            if (this.lastFailTime == 0L) {
                this.lastNotificationTime = 0L;
                return false;
            }
            return this.lastNotificationTime == 0L;
        }
    }

    static class ClientKeyRefresherListener
    implements KeyRefresherListener {
        long lastCertRefreshTime = 0L;

        ClientKeyRefresherListener() {
        }

        public void onKeyChangeEvent() {
            this.lastCertRefreshTime = System.currentTimeMillis() / 1000L;
        }

        long getLastCertRefreshTime() {
            return this.lastCertRefreshTime;
        }
    }

    static class TokenPrefetchTask
    extends TimerTask {
        TokenPrefetchTask() {
        }

        ZTSClient getZTSClient(PrefetchTokenScheduledItem item) {
            ZTSClient client = item.sslContext != null ? new ZTSClient(item.providedZTSUrl, item.proxyUrl, item.sslContext) : new ZTSClient(item.providedZTSUrl, item.identityDomain, item.identityName, item.siaProvider);
            return client;
        }

        boolean shouldRefresh(TokenType tokenType, long currentTime, long lastFetchTime, long lastFailTime, long expiryTime) {
            if (tokenType == TokenType.ACCESS && lastFetchTime < KEY_REFRESHER_LISTENER.getLastCertRefreshTime()) {
                return true;
            }
            if ((expiryTime - lastFetchTime) / 2L + lastFetchTime > currentTime) {
                return false;
            }
            if (lastFailTime == 0L) {
                return true;
            }
            return (expiryTime - lastFailTime) / 2L + lastFailTime <= currentTime;
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis() / 1000L;
            FETCHER_LAST_RUN_AT.set(currentTime);
            if (LOG.isDebugEnabled()) {
                LOG.debug("PrefetchTask: Fetching tokens from the scheduled queue. Size={}", (Object)PREFETCH_SCHEDULED_ITEMS.size());
            }
            if (PREFETCH_SCHEDULED_ITEMS.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("PrefetchTask: No items to fetch. Queue is empty");
                }
                return;
            }
            ArrayList<PrefetchTokenScheduledItem> toFetch = new ArrayList<PrefetchTokenScheduledItem>();
            boolean svcTokenRefresh = false;
            for (PrefetchTokenScheduledItem item : PREFETCH_SCHEDULED_ITEMS) {
                if (LOG.isDebugEnabled()) {
                    String itemName = item.sslContext == null ? item.identityDomain + "." + item.identityName : item.sslContext.toString();
                    LOG.debug("PrefetchTask: item={} type={} domain={} roleName={} fetch/fail/expire times {}/{}/{}", new Object[]{itemName, item.tokenType, item.domainName, item.roleName, item.fetchTime, item.lastFailTime, item.expiresAtUTC});
                }
                if (!this.shouldRefresh(item.tokenType, currentTime, item.fetchTime, item.lastFailTime, item.expiresAtUTC)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("PrefetchTask: domain={} roleName={}. Refresh this item.", (Object)item.domainName, (Object)item.roleName);
                }
                toFetch.add(item);
                if (item.tokenType != TokenType.SVC_ROLE) continue;
                svcTokenRefresh = true;
            }
            if (toFetch.isEmpty()) {
                return;
            }
            Set svcLoaderCache = null;
            if (svcTokenRefresh) {
                try {
                    svcLoaderCache = ZTSClient.loadSvcProviderTokens();
                }
                catch (Exception ex) {
                    LOG.error("Unable to load service provider tokens", (Throwable)ex);
                }
            }
            for (PrefetchTokenScheduledItem item : toFetch) {
                ZTSClient itemZtsClient = this.getZTSClient(item);
                Throwable throwable = null;
                try {
                    ZTSClient.processPrefetchTask(item, itemZtsClient, svcLoaderCache, currentTime);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (itemZtsClient == null) continue;
                    if (throwable != null) {
                        try {
                            itemZtsClient.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    itemZtsClient.close();
                }
            }
            toFetch.clear();
        }
    }

    static enum TokenType {
        ROLE,
        ACCESS,
        AWS,
        SVC_ROLE;

    }
}

