/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zts;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.yahoo.athenz.zts.AWSTemporaryCredentials;
import com.yahoo.athenz.zts.ZTSClient;
import com.yahoo.athenz.zts.ZTSClientNotificationSender;
import com.yahoo.rdl.Timestamp;
import java.io.Closeable;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSCredentialsProviderImpl
implements AWSCredentialsProvider,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AWSCredentialsProviderImpl.class);
    private static final String ZTS_CLIENT_PROP_AWS_AUTO_REFRESH_ENABLE = "athenz.zts.client.aws_auto_refresh_enable";
    private static boolean awsAutoRefreshEnable = Boolean.parseBoolean(System.getProperty("athenz.zts.client.aws_auto_refresh_enable", "true"));
    private String domainName;
    private String roleName;
    private String externalId;
    private Integer minExpiryTime;
    private Integer maxExpiryTime;
    private ZTSClient ztsClient;
    private Timestamp awsCredsTimestamp;
    private volatile AWSCredentials credentials;
    private boolean closeZTSClient;

    public AWSCredentialsProviderImpl(ZTSClient ztsClient, String domainName, String roleName) {
        this.initCredProvider(ztsClient, false, domainName, roleName, null, null, null);
    }

    public AWSCredentialsProviderImpl(ZTSClient ztsClient, String domainName, String roleName, String externalId, Integer minExpiryTime, Integer maxExpiryTime) {
        this.initCredProvider(ztsClient, false, domainName, roleName, externalId, minExpiryTime, maxExpiryTime);
    }

    public AWSCredentialsProviderImpl(String ztsUrl, SSLContext sslContext, String domainName, String roleName, String externalId, Integer minExpiryTime, Integer maxExpiryTime) {
        this.initCredProvider(new ZTSClient(ztsUrl, sslContext), true, domainName, roleName, externalId, minExpiryTime, maxExpiryTime);
    }

    public AWSCredentialsProviderImpl(String ztsUrl, SSLContext sslContext, String domainName, String roleName, String externalId, Integer minExpiryTime, Integer maxExpiryTime, ZTSClientNotificationSender ztsClientNotificationSender) {
        ZTSClient client = new ZTSClient(ztsUrl, sslContext);
        client.setNotificationSender(ztsClientNotificationSender);
        this.initCredProvider(client, true, domainName, roleName, externalId, minExpiryTime, maxExpiryTime);
    }

    public AWSCredentialsProviderImpl(String ztsUrl, SSLContext sslContext, String domainName, String roleName) {
        this.initCredProvider(new ZTSClient(ztsUrl, sslContext), true, domainName, roleName, null, null, null);
    }

    private void initCredProvider(ZTSClient ztsClient, boolean closeZTSClient, String domainName, String roleName, String externalId, Integer minExpiryTime, Integer maxExpiryTime) {
        this.domainName = domainName;
        this.roleName = roleName;
        this.minExpiryTime = minExpiryTime;
        this.maxExpiryTime = maxExpiryTime;
        this.externalId = externalId;
        this.ztsClient = ztsClient;
        this.closeZTSClient = closeZTSClient;
        this.awsCredsTimestamp = null;
        if (awsAutoRefreshEnable) {
            this.refresh();
        }
    }

    public static void setAwsAutoRefreshEnable(boolean state) {
        awsAutoRefreshEnable = state;
    }

    @Override
    public void close() throws IOException {
        if (this.closeZTSClient) {
            this.ztsClient.close();
        }
    }

    public AWSCredentials getCredentials() {
        this.refresh();
        return this.credentials;
    }

    public void refresh() {
        block4: {
            try {
                AWSTemporaryCredentials creds = this.ztsClient.getAWSTemporaryCredentials(this.domainName, this.roleName, this.externalId, this.minExpiryTime, this.maxExpiryTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Refresh: Credentials with id: {} and expiration {} were fetched", (Object)creds.getAccessKeyId(), (Object)creds.getExpiration());
                }
                this.awsCredsTimestamp = creds.getExpiration();
                this.credentials = new BasicSessionCredentials(creds.getAccessKeyId(), creds.getSecretAccessKey(), creds.getSessionToken());
            }
            catch (Exception ex) {
                if (this.awsCredsTimestamp != null && this.awsCredsTimestamp.millis() <= System.currentTimeMillis()) {
                    this.awsCredsTimestamp = null;
                    this.credentials = null;
                }
                LOG.error("Refresh: Failed to get the AWS temporary credentials from ZTS", (Throwable)ex);
                if (this.credentials != null) break block4;
                throw ex;
            }
        }
    }
}

