/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.examples;

import com.xiaomi.infra.galaxy.sds.client.ClientFactory;
import com.xiaomi.infra.galaxy.sds.client.TableScanner;
import com.xiaomi.infra.galaxy.sds.thrift.AdminService;
import com.xiaomi.infra.galaxy.sds.thrift.Credential;
import com.xiaomi.infra.galaxy.sds.thrift.DataType;
import com.xiaomi.infra.galaxy.sds.thrift.Datum;
import com.xiaomi.infra.galaxy.sds.thrift.DatumUtil;
import com.xiaomi.infra.galaxy.sds.thrift.KeySpec;
import com.xiaomi.infra.galaxy.sds.thrift.ProvisionThroughput;
import com.xiaomi.infra.galaxy.sds.thrift.PutRequest;
import com.xiaomi.infra.galaxy.sds.thrift.RemoveRequest;
import com.xiaomi.infra.galaxy.sds.thrift.Request;
import com.xiaomi.infra.galaxy.sds.thrift.ScanAction;
import com.xiaomi.infra.galaxy.sds.thrift.ScanOp;
import com.xiaomi.infra.galaxy.sds.thrift.ScanRequest;
import com.xiaomi.infra.galaxy.sds.thrift.TableMetadata;
import com.xiaomi.infra.galaxy.sds.thrift.TableQuota;
import com.xiaomi.infra.galaxy.sds.thrift.TableSchema;
import com.xiaomi.infra.galaxy.sds.thrift.TableService;
import com.xiaomi.infra.galaxy.sds.thrift.TableSpec;
import com.xiaomi.infra.galaxy.sds.thrift.UserType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ScanWithActionExample {
    private static ClientFactory clientFactory;
    private static AdminService.Iface adminClient;
    private static TableService.Iface tableClient;
    private static String secretKeyId;
    private static String secretKey;
    private static UserType userType;
    private static String endpoint;
    private static boolean isInit;
    private static String tableName;
    private static int numCity;
    private static String[] cities;

    private static void init() {
        Credential credential = new Credential().setSecretKey(secretKey).setSecretKeyId(secretKeyId).setType(userType);
        clientFactory = new ClientFactory().setCredential(credential);
        adminClient = clientFactory.newAdminClient(endpoint + "/v1/api/admin", 50000, 3000);
        tableClient = clientFactory.newTableClient(endpoint + "/v1/api/table", 10000, 3000, true, 5);
        isInit = true;
    }

    private static TableSpec tableSpec() {
        List<KeySpec> primaryKey = Arrays.asList(new KeySpec().setAttribute("cityId"), new KeySpec().setAttribute("timestamp").setAsc(false));
        HashMap<String, DataType> attributes = new HashMap<String, DataType>();
        attributes.put("cityId", DataType.STRING);
        attributes.put("timestamp", DataType.INT64);
        attributes.put("score", DataType.DOUBLE);
        attributes.put("pm25", DataType.INT64);
        TableSchema tableSchema = new TableSchema();
        tableSchema.setPrimaryIndex(primaryKey).setAttributes(attributes).setTtl(-1);
        TableMetadata tableMetadata = new TableMetadata();
        tableMetadata.setQuota(new TableQuota().setSize(0x6400000L)).setThroughput(new ProvisionThroughput().setReadCapacity(200L).setWriteCapacity(200L));
        return new TableSpec().setSchema(tableSchema).setMetadata(tableMetadata);
    }

    private static void printResult(Map<String, Datum> resultToPrint) {
        if (resultToPrint != null) {
            for (Map.Entry<String, Datum> e : resultToPrint.entrySet()) {
                System.out.print(String.format("[%s] => %s\t", e.getKey(), DatumUtil.fromDatum((Datum)e.getValue()).toString()));
            }
            System.out.println();
        }
    }

    private static void displayTable() throws Exception {
        ScanRequest scanRequest = new ScanRequest();
        scanRequest.setTableName(tableName);
        scanRequest.setLimit(numCity);
        TableScanner scanner = new TableScanner(tableClient, scanRequest);
        Iterator<Map<String, Datum>> iterator = scanner.iterator();
        while (iterator.hasNext()) {
            ScanWithActionExample.printResult(iterator.next());
        }
    }

    private static int scanWithAction(ScanRequest scanRequest) throws Exception {
        int count = 0;
        TableScanner scanner = new TableScanner(tableClient, scanRequest);
        Iterator<Map<String, Datum>> iterator = scanner.iterator();
        while (iterator.hasNext()) {
            count += ((Integer)DatumUtil.fromDatum((Datum)iterator.next().get("count"))).intValue();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ScanWithActionExample.init();
        TableSpec tableSpec = ScanWithActionExample.tableSpec();
        adminClient.createTable(tableName, tableSpec);
        try {
            Date now = new Date();
            PutRequest putRequest = new PutRequest();
            System.out.println("========== put data ==========");
            for (int i = 0; i < numCity; ++i) {
                putRequest.clear();
                putRequest.setTableName(tableName);
                putRequest.putToRecord("cityId", DatumUtil.toDatum((Object)cities[i]));
                putRequest.putToRecord("timestamp", DatumUtil.toDatum((Object)now.getTime()));
                putRequest.putToRecord("score", DatumUtil.toDatum((Object)new Random().nextInt(100)));
                putRequest.putToRecord("pm25", DatumUtil.toDatum((Object)new Random().nextInt(500)));
                tableClient.put(putRequest);
                System.out.println("put record #" + i);
            }
            System.out.println("========== records in table ==========");
            ScanWithActionExample.displayTable();
            ScanRequest scanRequest = new ScanRequest();
            scanRequest.setTableName(tableName);
            scanRequest.setLimit(numCity);
            System.out.println("========== scan with action COUNT ==========");
            scanRequest.setAction(new ScanAction().setAction(ScanOp.COUNT));
            int count = ScanWithActionExample.scanWithAction(scanRequest);
            System.out.println("There are totally " + count + " cities");
            HashMap<String, Datum> startKey = new HashMap<String, Datum>();
            HashMap<String, Datum> stopKey = new HashMap<String, Datum>();
            startKey.put("cityId", DatumUtil.toDatum((Object)"Guangzhou"));
            stopKey.put("cityId", DatumUtil.toDatum((Object)"Qingdao"));
            scanRequest.setStartKey(startKey);
            scanRequest.setStopKey(stopKey);
            count = ScanWithActionExample.scanWithAction(scanRequest);
            System.out.println("There are " + count + " cities between  Guangzhou and Qingdao");
            System.out.println("========== scan with action UPDATE==========");
            HashMap<String, Datum> record = new HashMap<String, Datum>();
            record.put("score", DatumUtil.toDatum((Object)60.0));
            scanRequest.setAction(new ScanAction().setAction(ScanOp.UPDATE).setRequest(Request.putRequest((PutRequest)new PutRequest().setRecord(record))));
            scanRequest.setStartKey(null);
            scanRequest.setStopKey(null);
            count = ScanWithActionExample.scanWithAction(scanRequest);
            System.out.println("There are " + count + " cities' score are set to 60.0, after update");
            ScanWithActionExample.displayTable();
            record.put("score", DatumUtil.toDatum((Object)90.0));
            scanRequest.setAction(new ScanAction().setAction(ScanOp.UPDATE).setRequest(Request.putRequest((PutRequest)new PutRequest().setRecord(record))));
            startKey.put("cityId", DatumUtil.toDatum((Object)"Dandong"));
            stopKey.put("cityId", DatumUtil.toDatum((Object)"Sanya"));
            scanRequest.setStartKey(startKey);
            scanRequest.setStopKey(stopKey);
            count = ScanWithActionExample.scanWithAction(scanRequest);
            System.out.println("There are " + count + " cities between Dandong and Sanya and their scores are set to 90.0, after update");
            ScanWithActionExample.displayTable();
            System.out.println("========== scan with action DELETE==========");
            ArrayList<String> deletedAttribute = new ArrayList<String>();
            deletedAttribute.add("pm25");
            scanRequest.setAction(new ScanAction().setAction(ScanOp.DELETE).setRequest(Request.removeRequest((RemoveRequest)new RemoveRequest().setAttributes(deletedAttribute))));
            scanRequest.setStartKey(null);
            scanRequest.setStopKey(null);
            count = ScanWithActionExample.scanWithAction(scanRequest);
            System.out.println("There are " + count + " cities' pm25 are deleted, after delete");
            ScanWithActionExample.displayTable();
            deletedAttribute.clear();
            deletedAttribute.add("score");
            scanRequest.setAction(new ScanAction().setAction(ScanOp.DELETE).setRequest(Request.removeRequest((RemoveRequest)new RemoveRequest().setAttributes(deletedAttribute))));
            startKey.put("cityId", DatumUtil.toDatum((Object)"Ningbo"));
            stopKey.put("cityId", DatumUtil.toDatum((Object)"Tianjin"));
            scanRequest.setStartKey(startKey);
            scanRequest.setStopKey(stopKey);
            count = ScanWithActionExample.scanWithAction(scanRequest);
            System.out.println("There are " + count + " cities between Ningbo and Tianjin and their score are deleted, after delete");
            ScanWithActionExample.displayTable();
            startKey.put("cityId", DatumUtil.toDatum((Object)"Rizhao"));
            stopKey.put("cityId", DatumUtil.toDatum((Object)"Xiamen"));
            scanRequest.setStartKey(startKey);
            scanRequest.setStopKey(stopKey);
            scanRequest.setAction(new ScanAction().setAction(ScanOp.DELETE));
            count = ScanWithActionExample.scanWithAction(scanRequest);
            System.out.println("There are " + count + " cities between Rizhao and Xiamen and they are deleted, after delete");
            ScanWithActionExample.displayTable();
        }
        finally {
            adminClient.disableTable(tableName);
            adminClient.dropTable(tableName);
        }
    }

    static {
        secretKeyId = "";
        secretKey = "";
        userType = UserType.APP_SECRET;
        endpoint = "http://cnbj-s0.sds.api.xiaomi.com";
        isInit = false;
        tableName = "java-test-weather1";
        numCity = 26;
        cities = new String[]{"Beihai", "Dalian", "Dandong", "Fuzhou", "Guangzhou", "Haikou", "Hankou", "Huangpu", "Jiujiang", "Lianyungang", "Nanjing", "Nantong", "Ningbo", "Qingdao", "Qinhuangdao", "Rizhao", "Sanya", "Shanghai", "Shantou", "Shenzhen", "Tianjin", "Weihai", "Wenzhou", "Xiamen", "Yangzhou", "Yantai"};
    }
}

