/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.examples;

import com.google.common.collect.LinkedListMultimap;
import com.xiaomi.infra.galaxy.client.authentication.HttpMethod;
import com.xiaomi.infra.galaxy.client.authentication.signature.SignAlgorithm;
import com.xiaomi.infra.galaxy.client.authentication.signature.Signer;
import com.xiaomi.infra.galaxy.sds.client.ClientFactory;
import com.xiaomi.infra.galaxy.sds.thrift.AdminService;
import com.xiaomi.infra.galaxy.sds.thrift.CannedAcl;
import com.xiaomi.infra.galaxy.sds.thrift.Credential;
import com.xiaomi.infra.galaxy.sds.thrift.DataType;
import com.xiaomi.infra.galaxy.sds.thrift.Datum;
import com.xiaomi.infra.galaxy.sds.thrift.DatumUtil;
import com.xiaomi.infra.galaxy.sds.thrift.EntityGroupSpec;
import com.xiaomi.infra.galaxy.sds.thrift.GetRequest;
import com.xiaomi.infra.galaxy.sds.thrift.GetResult;
import com.xiaomi.infra.galaxy.sds.thrift.KeySpec;
import com.xiaomi.infra.galaxy.sds.thrift.ProvisionThroughput;
import com.xiaomi.infra.galaxy.sds.thrift.TableMetadata;
import com.xiaomi.infra.galaxy.sds.thrift.TableQuota;
import com.xiaomi.infra.galaxy.sds.thrift.TableSchema;
import com.xiaomi.infra.galaxy.sds.thrift.TableService;
import com.xiaomi.infra.galaxy.sds.thrift.TableSpec;
import com.xiaomi.infra.galaxy.sds.thrift.UserType;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class RestfulExample {
    private static AdminService.Iface adminClient;
    private static TableService.Iface tableClient;
    private static String accountKey;
    private static String accountSecret;
    private static String endpoint;
    private static boolean isInit;
    private static String tableName;

    private static Credential getCredential(String secretKeyId, String secretKey, UserType userType) {
        return new Credential().setSecretKeyId(secretKeyId).setSecretKey(secretKey).setType(userType);
    }

    public static AdminService.Iface createAdminClient(String host) {
        Credential credential = RestfulExample.getCredential(accountKey, accountSecret, UserType.DEV_XIAOMI);
        ClientFactory clientFactory = new ClientFactory().setCredential(credential);
        return clientFactory.newAdminClient(host + "/v1/api/admin", 50000, 3000);
    }

    public static TableService.Iface createTableClient(String host) {
        Credential credential = RestfulExample.getCredential(accountKey, accountSecret, UserType.APP_SECRET);
        ClientFactory clientFactory = new ClientFactory().setCredential(credential);
        return clientFactory.newTableClient(host + "/v1/api/table", 10000, 3000, true, 5);
    }

    public static Map<String, List<CannedAcl>> cannedAclGrant(String appId, CannedAcl ... cannedAcls) {
        HashMap<String, List<CannedAcl>> appGrant = new HashMap<String, List<CannedAcl>>();
        appGrant.put(appId, Arrays.asList(cannedAcls));
        return appGrant;
    }

    private static void init() {
        adminClient = RestfulExample.createAdminClient(endpoint);
        tableClient = RestfulExample.createTableClient(endpoint);
        isInit = true;
    }

    private static URI generatePresignedUri(String baseUri, Integer expiration, HttpMethod httpMethod, String accessId, String accessSecret, SignAlgorithm signAlgorithm) throws Exception {
        try {
            URI uri = new URI(baseUri);
            Long expirationTime = new Date().getTime() + (long)expiration.intValue();
            URI encodedUri = new URI(baseUri + "?" + "GalaxyAccessKeyId" + "=" + accessId + "&" + "Expires" + "=" + expirationTime.toString());
            LinkedListMultimap headers = null;
            String signature = Signer.signToBase64((HttpMethod)httpMethod, (URI)encodedUri, headers, (String)accessSecret, (SignAlgorithm)signAlgorithm);
            return new URI(encodedUri.toString() + "&" + "Signature" + "=" + new String(signature));
        }
        catch (URISyntaxException e) {
            System.out.print("Invalid URI syntax");
            throw new Exception("Invalid URI syntax", e);
        }
        catch (InvalidKeyException e) {
            System.out.print("Invalid secret key spec");
            throw new Exception("Invalid secret key spec", e);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.print("Unsupported signature algorithm:" + signAlgorithm);
            throw new Exception("Unsupported signature algorithm:" + signAlgorithm, e);
        }
    }

    private static void sendPut(URI uri, byte[] body) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setEntity((HttpEntity)new ByteArrayEntity(body));
        try {
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPut);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                System.out.println("Send Put Success");
                HttpEntity httpEntity = httpResponse.getEntity();
                String response = EntityUtils.toString((HttpEntity)httpEntity);
                System.out.println(response);
            } else {
                System.out.println(httpResponse.getStatusLine().getStatusCode());
                System.out.println(httpResponse.getStatusLine().getReasonPhrase());
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static TableSpec tableSpec() {
        EntityGroupSpec entityGroupSpec = new EntityGroupSpec().setAttributes(Arrays.asList(new KeySpec().setAttribute("date"), new KeySpec().setAttribute("sn"))).setEnableHash(true);
        List<KeySpec> primaryKey = Arrays.asList(new KeySpec().setAttribute("recordid"));
        HashMap<String, DataType> attributes = new HashMap<String, DataType>();
        attributes.put("date", DataType.INT32);
        attributes.put("sn", DataType.STRING);
        attributes.put("recordid", DataType.STRING);
        attributes.put("recordvalue", DataType.BINARY);
        TableSchema tableSchema = new TableSchema();
        tableSchema.setEntityGroup(entityGroupSpec).setPrimaryIndex(primaryKey).setAttributes(attributes).setTtl(-1);
        TableMetadata tableMetadata = new TableMetadata();
        tableMetadata.setQuota(new TableQuota().setSize(0x6400000L)).setThroughput(new ProvisionThroughput().setReadCapacity(20L).setWriteCapacity(20L));
        return new TableSpec().setSchema(tableSchema).setMetadata(tableMetadata);
    }

    private static void printResult(Map<String, Datum> resultToPrint) {
        if (resultToPrint != null) {
            for (Map.Entry<String, Datum> e : resultToPrint.entrySet()) {
                if (e.getValue().getType() == DataType.BINARY) {
                    byte[] bytes = (byte[])DatumUtil.fromDatum((Datum)e.getValue());
                    String newstring = new String(bytes);
                    System.out.println(String.format("[%s] => %s", e.getKey(), newstring));
                    continue;
                }
                System.out.println(String.format("[%s] => %s", e.getKey(), DatumUtil.fromDatum((Datum)e.getValue()).toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        RestfulExample.init();
        TableSpec tableSpec = RestfulExample.tableSpec();
        try {
            adminClient.createTable(tableName, tableSpec);
            tableSpec = adminClient.describeTable(tableName);
            System.out.println("table " + tableName + ":");
            System.out.println(tableSpec);
            URI putUrlBase = RestfulExample.generatePresignedUri(endpoint + "/v1/api/restful", 6000000, HttpMethod.PUT, accountKey, accountSecret, SignAlgorithm.HmacSHA1);
            Integer i = 0;
            while (i < 10) {
                System.out.println("----------test-" + i + "----------");
                Integer data = 20170601 + i;
                String sn = "138710000123" + i;
                String recordid = "10;2" + i;
                URI putUrl = new URI(putUrlBase.toString() + "&tableName=" + tableName + "&" + "date=" + data.toString() + "&sn=" + sn + "&recordid=" + recordid + "&recordvalue=");
                System.out.println("presigned url =" + putUrl);
                RestfulExample.sendPut(putUrl, putUrl.toString().getBytes());
                GetRequest getRequest = new GetRequest();
                getRequest.setTableName(tableName);
                getRequest.putToKeys("date", DatumUtil.toDatum((Object)data));
                getRequest.putToKeys("sn", DatumUtil.toDatum((Object)sn));
                getRequest.putToKeys("recordid", DatumUtil.toDatum((Object)recordid));
                GetResult getResult = tableClient.get(getRequest);
                RestfulExample.printResult(getResult.getItem());
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        finally {
            adminClient.disableTable(tableName);
            adminClient.dropTable(tableName);
        }
    }

    static {
        accountKey = "1-100";
        accountSecret = "100";
        endpoint = "http://localhost:9086";
        isInit = false;
        tableName = "restful-example-test";
    }
}

