/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.examples;

import com.xiaomi.infra.galaxy.sds.client.ClientFactory;
import com.xiaomi.infra.galaxy.sds.thrift.AdminService;
import com.xiaomi.infra.galaxy.sds.thrift.CannedAcl;
import com.xiaomi.infra.galaxy.sds.thrift.Credential;
import com.xiaomi.infra.galaxy.sds.thrift.DataType;
import com.xiaomi.infra.galaxy.sds.thrift.Datum;
import com.xiaomi.infra.galaxy.sds.thrift.DatumUtil;
import com.xiaomi.infra.galaxy.sds.thrift.EntityGroupSpec;
import com.xiaomi.infra.galaxy.sds.thrift.GlobalSecondaryIndexSpec;
import com.xiaomi.infra.galaxy.sds.thrift.KeySpec;
import com.xiaomi.infra.galaxy.sds.thrift.ProvisionThroughput;
import com.xiaomi.infra.galaxy.sds.thrift.PutRequest;
import com.xiaomi.infra.galaxy.sds.thrift.ScanRequest;
import com.xiaomi.infra.galaxy.sds.thrift.ScanResult;
import com.xiaomi.infra.galaxy.sds.thrift.TableMetadata;
import com.xiaomi.infra.galaxy.sds.thrift.TableQuota;
import com.xiaomi.infra.galaxy.sds.thrift.TableSchema;
import com.xiaomi.infra.galaxy.sds.thrift.TableService;
import com.xiaomi.infra.galaxy.sds.thrift.TableSpec;
import com.xiaomi.infra.galaxy.sds.thrift.UserType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlobalIndexExample {
    private static AdminService.Iface adminClient;
    private static TableService.Iface tableClient;
    private static String appId;
    private static String appKey;
    private static String appSecret;
    private static String accountKey;
    private static String accountSecret;
    private static String endpoint;
    private static boolean isInit;
    private static String tableName;

    private static Credential getCredential(String secretKeyId, String secretKey, UserType userType) {
        return new Credential().setSecretKeyId(secretKeyId).setSecretKey(secretKey).setType(userType);
    }

    public static AdminService.Iface createAdminClient(String host) {
        Credential credential = GlobalIndexExample.getCredential(accountKey, accountSecret, UserType.DEV_XIAOMI);
        ClientFactory clientFactory = new ClientFactory().setCredential(credential);
        return clientFactory.newAdminClient(host + "/v1/api/admin", 50000, 3000);
    }

    public static TableService.Iface createTableClient(String host) {
        Credential credential = GlobalIndexExample.getCredential(appKey, appSecret, UserType.APP_SECRET);
        ClientFactory clientFactory = new ClientFactory().setCredential(credential);
        return clientFactory.newTableClient(host + "/v1/api/table", 10000, 3000, true, 5);
    }

    private static TableSpec tableSpec() {
        EntityGroupSpec entityGroupSpec = new EntityGroupSpec().setAttributes(Arrays.asList(new KeySpec().setAttribute("userId"))).setEnableHash(true);
        List<KeySpec> primaryKey = Arrays.asList(new KeySpec().setAttribute("time"), new KeySpec().setAttribute("deviceId"));
        HashMap<String, GlobalSecondaryIndexSpec> indexes = new HashMap<String, GlobalSecondaryIndexSpec>();
        GlobalSecondaryIndexSpec didIndex = new GlobalSecondaryIndexSpec();
        didIndex.setIndexEntityGroup(new EntityGroupSpec().setAttributes(Arrays.asList(new KeySpec().setAttribute("deviceId"))).setEnableHash(true));
        didIndex.setIndexPrimaryKey(Arrays.asList(new KeySpec().setAttribute("time").setAsc(false)));
        didIndex.setProjections(Arrays.asList("value"));
        didIndex.setThroughput(new ProvisionThroughput().setReadCapacity(20L).setWriteCapacity(20L));
        GlobalSecondaryIndexSpec timeIndex = new GlobalSecondaryIndexSpec();
        timeIndex.setIndexPrimaryKey(Arrays.asList(new KeySpec().setAttribute("time").setAsc(false)));
        timeIndex.setProjections(Arrays.asList("value"));
        timeIndex.setThroughput(new ProvisionThroughput().setReadCapacity(20L).setWriteCapacity(20L));
        indexes.put("didIndex", didIndex);
        indexes.put("timeIndex", timeIndex);
        HashMap<String, DataType> attributes = new HashMap<String, DataType>();
        attributes.put("userId", DataType.STRING);
        attributes.put("deviceId", DataType.STRING);
        attributes.put("time", DataType.INT64);
        attributes.put("value", DataType.STRING);
        TableSchema tableSchema = new TableSchema();
        tableSchema.setEntityGroup(entityGroupSpec).setPrimaryIndex(primaryKey).setGlobalSecondaryIndexes(indexes).setAttributes(attributes).setTtl(-1);
        TableMetadata tableMetadata = new TableMetadata();
        tableMetadata.setQuota(new TableQuota().setSize(0x6400000L)).setAppAcl(GlobalIndexExample.cannedAclGrant(appId, CannedAcl.APP_SECRET_READ, CannedAcl.APP_SECRET_WRITE)).setThroughput(new ProvisionThroughput().setReadCapacity(20L).setWriteCapacity(20L));
        return new TableSpec().setSchema(tableSchema).setMetadata(tableMetadata);
    }

    public static Map<String, List<CannedAcl>> cannedAclGrant(String appId, CannedAcl ... cannedAcls) {
        HashMap<String, List<CannedAcl>> appGrant = new HashMap<String, List<CannedAcl>>();
        appGrant.put(appId, Arrays.asList(cannedAcls));
        return appGrant;
    }

    private static void init() {
        adminClient = GlobalIndexExample.createAdminClient(endpoint);
        tableClient = GlobalIndexExample.createTableClient(endpoint);
        isInit = true;
    }

    private static void printResult(Map<String, Datum> resultToPrint) {
        for (Map.Entry<String, Datum> e : resultToPrint.entrySet()) {
            System.out.println(String.format("[%s] => %s", e.getKey(), DatumUtil.fromDatum((Datum)e.getValue()).toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        GlobalIndexExample.init();
        TableSpec tableSpec = GlobalIndexExample.tableSpec();
        adminClient.createTable(tableName, tableSpec);
        try {
            System.out.println("================= put data ====================");
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    PutRequest putRequest = new PutRequest();
                    putRequest.setTableName(tableName);
                    putRequest.putToRecord("userId", DatumUtil.toDatum((Object)("user" + i)));
                    putRequest.putToRecord("deviceId", DatumUtil.toDatum((Object)("device" + i)));
                    putRequest.putToRecord("time", DatumUtil.toDatum((Object)j));
                    putRequest.putToRecord("value", DatumUtil.toDatum((Object)("value " + i + "-" + j)));
                    tableClient.put(putRequest);
                }
            }
            System.out.println("================= scan by didIndex ====================");
            ScanRequest scanRequest = new ScanRequest();
            HashMap<String, Datum> startKey = new HashMap<String, Datum>();
            HashMap<String, Datum> stopKey = new HashMap<String, Datum>();
            scanRequest.setTableName(tableName);
            scanRequest.setIndexName("didIndex");
            startKey.clear();
            startKey.put("deviceId", DatumUtil.toDatum((Object)"device1"));
            startKey.put("time", DatumUtil.toDatum((Object)4L));
            stopKey.clear();
            stopKey.put("deviceId", DatumUtil.toDatum((Object)"device1"));
            stopKey.put("time", DatumUtil.toDatum((Object)2L));
            scanRequest.setStartKey(startKey);
            scanRequest.setStopKey(stopKey);
            scanRequest.setAttributes(Arrays.asList("userId", "value", "time"));
            scanRequest.setLimit(10);
            ScanResult scanResult = tableClient.scan(scanRequest);
            List kvsList = scanResult.getRecords();
            for (Map kvs : kvsList) {
                GlobalIndexExample.printResult(kvs);
            }
            System.out.println("================= scan by timeIndex ====================");
            scanRequest.setIndexName("timeIndex");
            startKey.clear();
            startKey.put("time", DatumUtil.toDatum((Object)3L));
            stopKey.clear();
            stopKey.put("time", DatumUtil.toDatum((Object)1L));
            scanRequest.setStartKey(startKey);
            scanRequest.setStopKey(stopKey);
            scanRequest.setAttributes(Arrays.asList("userId", "value", "time"));
            scanRequest.setLimit(10);
            scanResult = tableClient.scan(scanRequest);
            kvsList = scanResult.getRecords();
            for (Map kvs : kvsList) {
                GlobalIndexExample.printResult(kvs);
            }
        }
        finally {
            adminClient.disableTable(tableName);
            adminClient.dropTable(tableName);
        }
    }

    static {
        appId = "";
        appKey = "";
        appSecret = "";
        accountKey = "";
        accountSecret = "";
        endpoint = "http://awsbj0.sds.api.xiaomi.com";
        isInit = false;
        tableName = "java-test-global-index";
    }
}

