/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.examples;

import com.xiaomi.infra.galaxy.sds.client.ClientFactory;
import com.xiaomi.infra.galaxy.sds.thrift.AdminService;
import com.xiaomi.infra.galaxy.sds.thrift.AppInfo;
import com.xiaomi.infra.galaxy.sds.thrift.CannedAcl;
import com.xiaomi.infra.galaxy.sds.thrift.Credential;
import com.xiaomi.infra.galaxy.sds.thrift.DataType;
import com.xiaomi.infra.galaxy.sds.thrift.EntityGroupSpec;
import com.xiaomi.infra.galaxy.sds.thrift.KeySpec;
import com.xiaomi.infra.galaxy.sds.thrift.LocalSecondaryIndexSpec;
import com.xiaomi.infra.galaxy.sds.thrift.OAuthInfo;
import com.xiaomi.infra.galaxy.sds.thrift.ProvisionThroughput;
import com.xiaomi.infra.galaxy.sds.thrift.SecondaryIndexConsistencyMode;
import com.xiaomi.infra.galaxy.sds.thrift.TableMetadata;
import com.xiaomi.infra.galaxy.sds.thrift.TableQuota;
import com.xiaomi.infra.galaxy.sds.thrift.TableSchema;
import com.xiaomi.infra.galaxy.sds.thrift.TableSpec;
import com.xiaomi.infra.galaxy.sds.thrift.UserType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import libthrift091.TException;

public class ExtAppTableCreator {
    private static AdminService.Iface adminClient;
    private static final UserType userType;
    private String appId;
    private String secretKeyId;
    private String secretKey;
    private String endpoint;
    private String tableName;
    private OAuthInfo oauthIfo;
    private String extAppId;

    public ExtAppTableCreator(String appId, String secretKeyId, String secretKey, String tableName, String endpoint, OAuthInfo oauthIfo, String extAppId) throws TException {
        this.appId = appId;
        this.secretKeyId = secretKeyId;
        this.secretKey = secretKey;
        this.tableName = tableName;
        this.endpoint = endpoint;
        this.oauthIfo = oauthIfo;
        this.extAppId = extAppId;
        this.init();
    }

    private void init() throws TException {
        Credential credential = new Credential().setSecretKeyId(this.secretKeyId).setSecretKey(this.secretKey).setType(userType);
        ClientFactory clientFactory = new ClientFactory().setCredential(credential);
        adminClient = clientFactory.newAdminClient(this.endpoint + "/v1/api/admin", 50000, 3000);
        AppInfo appInfo = new AppInfo();
        appInfo.setAppId(this.appId);
        HashMap<String, String> oAuthMap = new HashMap<String, String>();
        oAuthMap.put(this.oauthIfo.getAppUserAuthProvider().name(), this.extAppId);
        appInfo.setOauthAppMapping(oAuthMap);
        adminClient.saveAppInfo(appInfo);
    }

    private TableSpec tableSpec() {
        EntityGroupSpec entityGroupSpec = new EntityGroupSpec().setAttributes(Arrays.asList(new KeySpec().setAttribute("userId")));
        List<KeySpec> primaryKey = Arrays.asList(new KeySpec().setAttribute("noteId"));
        HashMap<String, LocalSecondaryIndexSpec> secondaryIndexSpecMap = new HashMap<String, LocalSecondaryIndexSpec>();
        LocalSecondaryIndexSpec mtimeIndex = new LocalSecondaryIndexSpec();
        mtimeIndex.setIndexSchema(Arrays.asList(new KeySpec().setAttribute("mtime")));
        mtimeIndex.setProjections(Arrays.asList("title", "noteId"));
        mtimeIndex.setConsistencyMode(SecondaryIndexConsistencyMode.EAGER);
        secondaryIndexSpecMap.put("mtime", mtimeIndex);
        LocalSecondaryIndexSpec catIndex = new LocalSecondaryIndexSpec();
        catIndex.setIndexSchema(Arrays.asList(new KeySpec().setAttribute("category")));
        catIndex.setConsistencyMode(SecondaryIndexConsistencyMode.LAZY);
        secondaryIndexSpecMap.put("cat", catIndex);
        HashMap<String, DataType> attributes = new HashMap<String, DataType>();
        attributes.put("userId", DataType.STRING);
        attributes.put("noteId", DataType.INT64);
        attributes.put("title", DataType.STRING);
        attributes.put("content", DataType.STRING);
        attributes.put("version", DataType.INT64);
        attributes.put("mtime", DataType.INT64);
        attributes.put("category", DataType.STRING);
        TableSchema tableSchema = new TableSchema();
        tableSchema.setEntityGroup(entityGroupSpec).setPrimaryIndex(primaryKey).setSecondaryIndexes(secondaryIndexSpecMap).setAttributes(attributes).setTtl(-1);
        TableMetadata tableMetadata = new TableMetadata();
        HashMap<String, List<CannedAcl>> appGrant = new HashMap<String, List<CannedAcl>>();
        appGrant.put(this.appId, Arrays.asList(CannedAcl.APP_SECRET_READ, CannedAcl.APP_SECRET_WRITE, CannedAcl.APP_USER_ENTITY_GROUP_READ, CannedAcl.APP_USER_ENTITY_GROUP_WRITE));
        tableMetadata.setQuota(new TableQuota().setSize(0x6400000L)).setThroughput(new ProvisionThroughput().setReadCapacity(20L).setWriteCapacity(20L)).setAppAcl(appGrant);
        return new TableSpec().setSchema(tableSchema).setMetadata(tableMetadata);
    }

    public void createTable() throws Exception {
        this.init();
        try {
            adminClient.dropTable(this.tableName);
        }
        catch (Exception se) {
            // empty catch block
        }
        TableSpec tableSpec = this.tableSpec();
        adminClient.createTable(this.tableName, tableSpec);
        System.out.println("Create table successfully");
    }

    static {
        userType = UserType.APP_SECRET;
    }
}

