/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.examples;

import com.xiaomi.infra.galaxy.sds.client.ClientFactory;
import com.xiaomi.infra.galaxy.sds.thrift.AuthService;
import com.xiaomi.infra.galaxy.sds.thrift.Credential;
import com.xiaomi.infra.galaxy.sds.thrift.Datum;
import com.xiaomi.infra.galaxy.sds.thrift.DatumUtil;
import com.xiaomi.infra.galaxy.sds.thrift.GetRequest;
import com.xiaomi.infra.galaxy.sds.thrift.GetResult;
import com.xiaomi.infra.galaxy.sds.thrift.OAuthInfo;
import com.xiaomi.infra.galaxy.sds.thrift.PutRequest;
import com.xiaomi.infra.galaxy.sds.thrift.ScanRequest;
import com.xiaomi.infra.galaxy.sds.thrift.ScanResult;
import com.xiaomi.infra.galaxy.sds.thrift.TableService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import libthrift091.TException;

public class ExtAppTableAccessor {
    private static TableService.Iface tableClient;
    private static String[] categories;
    private static int M;
    private String endpoint;
    private String tableName;
    private OAuthInfo oauthInfo;

    public ExtAppTableAccessor(String tableName, String endpoint, OAuthInfo oauthInfo) throws TException {
        this.tableName = tableName;
        this.endpoint = endpoint;
        this.oauthInfo = oauthInfo;
        this.init();
    }

    private void init() throws TException {
        ClientFactory clientFactory = new ClientFactory();
        AuthService.Iface authClient = clientFactory.newAuthClient(this.endpoint + "/v1/api/auth");
        Credential credential = authClient.createCredential(this.oauthInfo);
        clientFactory = new ClientFactory().setCredential(credential);
        tableClient = clientFactory.newTableClient(this.endpoint + "/v1/api/table", 10000, 3000, true, 3);
    }

    private void printResult(Map<String, Datum> resultToPrint) {
        for (Map.Entry<String, Datum> e : resultToPrint.entrySet()) {
            System.out.println(String.format("[%s] => %s", e.getKey(), DatumUtil.fromDatum((Datum)e.getValue()).toString()));
        }
    }

    public void putData() throws Exception {
        Date now = new Date();
        for (int i = 0; i < M; ++i) {
            PutRequest putRequest = new PutRequest();
            putRequest.setTableName(this.tableName);
            putRequest.putToRecord("noteId", DatumUtil.toDatum((Object)i));
            putRequest.putToRecord("title", DatumUtil.toDatum((Object)("Title " + i)));
            putRequest.putToRecord("content", DatumUtil.toDatum((Object)("note " + i)));
            putRequest.putToRecord("version", DatumUtil.toDatum((Object)i));
            putRequest.putToRecord("mtime", DatumUtil.toDatum((Object)now.getTime()));
            putRequest.putToRecord("category", DatumUtil.toDatum((Object)categories[i % categories.length]));
            tableClient.put(putRequest);
            System.out.println("Put record # " + i);
        }
    }

    public void getData() throws Exception {
        GetRequest getRequest = new GetRequest();
        getRequest.setTableName(this.tableName);
        getRequest.putToKeys("noteId", DatumUtil.toDatum((Object)new Random().nextInt(M)));
        GetResult getResult = tableClient.get(getRequest);
        this.printResult(getResult.getItem());
    }

    public void scanData() throws Exception {
        HashMap<String, Datum> startKey = new HashMap<String, Datum>();
        startKey.put("noteId", DatumUtil.toDatum((Object)1L));
        HashMap<String, Datum> stopKey = new HashMap<String, Datum>();
        stopKey.put("noteId", DatumUtil.toDatum((Object)5L));
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("title");
        ScanRequest scanRequest = new ScanRequest().setTableName(this.tableName).setStartKey(startKey).setStopKey(stopKey).setLimit(100).setAttributes(attributes);
        ScanResult scanResult = tableClient.scan(scanRequest);
        List kvsList = scanResult.getRecords();
        for (Map kvs : kvsList) {
            for (Map.Entry e : kvs.entrySet()) {
                System.out.println((String)e.getKey() + "\t" + DatumUtil.fromDatum((Datum)((Datum)e.getValue())));
            }
        }
    }

    public void accessData() throws Exception {
        this.putData();
        this.getData();
        this.scanData();
    }

    static {
        categories = new String[]{"work", "travel", "food"};
        M = 10;
    }
}

