/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.examples;

import com.xiaomi.infra.galaxy.sds.client.ClientFactory;
import com.xiaomi.infra.galaxy.sds.client.TableScanner;
import com.xiaomi.infra.galaxy.sds.thrift.AdminService;
import com.xiaomi.infra.galaxy.sds.thrift.BatchOp;
import com.xiaomi.infra.galaxy.sds.thrift.BatchRequest;
import com.xiaomi.infra.galaxy.sds.thrift.BatchRequestItem;
import com.xiaomi.infra.galaxy.sds.thrift.BatchResult;
import com.xiaomi.infra.galaxy.sds.thrift.BatchResultItem;
import com.xiaomi.infra.galaxy.sds.thrift.CannedAcl;
import com.xiaomi.infra.galaxy.sds.thrift.Credential;
import com.xiaomi.infra.galaxy.sds.thrift.DataType;
import com.xiaomi.infra.galaxy.sds.thrift.Datum;
import com.xiaomi.infra.galaxy.sds.thrift.DatumUtil;
import com.xiaomi.infra.galaxy.sds.thrift.GetRequest;
import com.xiaomi.infra.galaxy.sds.thrift.GetResult;
import com.xiaomi.infra.galaxy.sds.thrift.KeySpec;
import com.xiaomi.infra.galaxy.sds.thrift.ProvisionThroughput;
import com.xiaomi.infra.galaxy.sds.thrift.PutRequest;
import com.xiaomi.infra.galaxy.sds.thrift.Request;
import com.xiaomi.infra.galaxy.sds.thrift.ScanRequest;
import com.xiaomi.infra.galaxy.sds.thrift.ScanResult;
import com.xiaomi.infra.galaxy.sds.thrift.TableMetadata;
import com.xiaomi.infra.galaxy.sds.thrift.TableQuota;
import com.xiaomi.infra.galaxy.sds.thrift.TableSchema;
import com.xiaomi.infra.galaxy.sds.thrift.TableService;
import com.xiaomi.infra.galaxy.sds.thrift.TableSpec;
import com.xiaomi.infra.galaxy.sds.thrift.UserType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Basic {
    private static AdminService.Iface adminClient;
    private static TableService.Iface tableClient;
    private static String accountKey;
    private static String accountSecret;
    private static String endpoint;
    private static boolean isInit;
    private static String tableName;
    private static String[] cities;

    private static Credential getCredential(String secretKeyId, String secretKey, UserType userType) {
        return new Credential().setSecretKeyId(secretKeyId).setSecretKey(secretKey).setType(userType);
    }

    public static AdminService.Iface createAdminClient(String host) {
        Credential credential = Basic.getCredential(accountKey, accountSecret, UserType.DEV_XIAOMI);
        ClientFactory clientFactory = new ClientFactory().setCredential(credential);
        return clientFactory.newAdminClient(host + "/v1/api/admin", 50000, 3000);
    }

    public static TableService.Iface createTableClient(String host) {
        Credential credential = Basic.getCredential(accountKey, accountSecret, UserType.APP_SECRET);
        ClientFactory clientFactory = new ClientFactory().setCredential(credential);
        return clientFactory.newTableClient(host + "/v1/api/table", 10000, 3000, true, 5);
    }

    public static Map<String, List<CannedAcl>> cannedAclGrant(String appId, CannedAcl ... cannedAcls) {
        HashMap<String, List<CannedAcl>> appGrant = new HashMap<String, List<CannedAcl>>();
        appGrant.put(appId, Arrays.asList(cannedAcls));
        return appGrant;
    }

    private static void init() {
        adminClient = Basic.createAdminClient(endpoint);
        tableClient = Basic.createTableClient(endpoint);
        isInit = true;
    }

    private static TableSpec tableSpec() {
        List<KeySpec> primaryKey = Arrays.asList(new KeySpec().setAttribute("cityId"), new KeySpec().setAttribute("timestamp").setAsc(false));
        HashMap<String, DataType> attributes = new HashMap<String, DataType>();
        attributes.put("cityId", DataType.STRING);
        attributes.put("timestamp", DataType.INT64);
        attributes.put("score", DataType.DOUBLE);
        attributes.put("pm25", DataType.INT64);
        TableSchema tableSchema = new TableSchema();
        tableSchema.setPrimaryIndex(primaryKey).setAttributes(attributes).setTtl(-1);
        TableMetadata tableMetadata = new TableMetadata();
        tableMetadata.setQuota(new TableQuota().setSize(0x6400000L)).setThroughput(new ProvisionThroughput().setReadCapacity(20L).setWriteCapacity(20L));
        return new TableSpec().setSchema(tableSchema).setMetadata(tableMetadata);
    }

    private static void printResult(Map<String, Datum> resultToPrint) {
        if (resultToPrint != null) {
            for (Map.Entry<String, Datum> e : resultToPrint.entrySet()) {
                System.out.println(String.format("[%s] => %s", e.getKey(), DatumUtil.fromDatum((Datum)e.getValue()).toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Basic.init();
        TableSpec tableSpec = Basic.tableSpec();
        adminClient.createTable(tableName, tableSpec);
        try {
            System.out.println("table " + tableName + ":");
            System.out.println(adminClient.describeTable(tableName));
            System.out.println("All tables belong to you:");
            System.out.println(adminClient.findAllTables());
            Date now = new Date();
            PutRequest putRequest = new PutRequest();
            for (int i = 0; i < 10; ++i) {
                putRequest.clear();
                putRequest.setTableName(tableName);
                putRequest.putToRecord("cityId", DatumUtil.toDatum((Object)cities[i]));
                putRequest.putToRecord("timestamp", DatumUtil.toDatum((Object)now.getTime()));
                putRequest.putToRecord("score", DatumUtil.toDatum((Object)new Random().nextInt(100)));
                putRequest.putToRecord("pm25", DatumUtil.toDatum((Object)new Random().nextInt(500)));
                tableClient.put(putRequest);
                System.out.println("put record #" + i);
            }
            ArrayList<BatchRequestItem> batch = new ArrayList<BatchRequestItem>();
            for (int i = 11; i < 20; ++i) {
                BatchRequestItem item = new BatchRequestItem().setAction(BatchOp.PUT);
                HashMap<String, Datum> record = new HashMap<String, Datum>();
                record.put("cityId", DatumUtil.toDatum((Object)cities[i]));
                putRequest.putToRecord("timestamp", DatumUtil.toDatum((Object)now.getTime()));
                putRequest.putToRecord("score", DatumUtil.toDatum((Object)new Random().nextInt(100)));
                putRequest.putToRecord("pm25", DatumUtil.toDatum((Object)new Random().nextInt(500)));
                item.setRequest(Request.putRequest((PutRequest)new PutRequest().setTableName(tableName).setRecord(record)));
                batch.add(item);
            }
            while (true) {
                BatchResult br = tableClient.partialAllowedBatch(new BatchRequest().setItems(batch));
                ArrayList request = new ArrayList();
                for (int i = 0; i < br.getItems().size(); ++i) {
                    if (((BatchResultItem)br.getItems().get(i)).isSuccess()) continue;
                    request.add(batch.get(i));
                }
                if (request.isEmpty()) break;
                Thread.sleep(100L);
                batch = request;
            }
            GetRequest getRequest = new GetRequest();
            getRequest.setTableName(tableName);
            getRequest.putToKeys("cityId", DatumUtil.toDatum((Object)cities[0]));
            getRequest.putToKeys("timestamp", DatumUtil.toDatum((Object)now.getTime()));
            getRequest.addToAttributes("pm25");
            GetResult getResult = tableClient.get(getRequest);
            Basic.printResult(getResult.getItem());
            ScanRequest scanRequest = new ScanRequest();
            scanRequest.setTableName(tableName);
            scanRequest.addToAttributes("cityId");
            scanRequest.addToAttributes("score");
            scanRequest.setCondition("score > 50");
            scanRequest.setLimit(10);
            ScanResult scanResult = tableClient.scan(scanRequest);
            List kvsList = scanResult.getRecords();
            for (Map kvs : kvsList) {
                Basic.printResult(kvs);
            }
            scanRequest.clear();
            scanRequest.setTableName(tableName);
            TableScanner scanner = new TableScanner(tableClient, scanRequest);
            Iterator<Map<String, Datum>> iterator = scanner.iterator();
            while (iterator.hasNext()) {
                Basic.printResult(iterator.next());
            }
        }
        finally {
            adminClient.disableTable(tableName);
            adminClient.dropTable(tableName);
        }
    }

    static {
        accountKey = "";
        accountSecret = "";
        endpoint = "http://cnbj-s0.sds.api.xiaomi.com";
        isInit = false;
        tableName = "java-test-weather";
        cities = new String[]{"\u5317\u4eac", "Beihai", "Dalian", "Dandong", "Fuzhou", "Guangzhou", "Haikou", "Hankou", "Huangpu", "Jiujiang", "Lianyungang", "Nanjing", "Nantong", "Ningbo", "Qingdao", "Qinhuangdao", "Rizhao", "Sanya", "Shanghai", "Shantou", "Shenzhen", "Tianjin", "Weihai", "Wenzhou", "Xiamen", "Yangzhou", "Yantai"};
    }
}

