/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.client.metrics;

import com.xiaomi.infra.galaxy.sds.client.metrics.RequestMetrics;
import com.xiaomi.infra.galaxy.sds.thrift.AdminService;
import com.xiaomi.infra.galaxy.sds.thrift.ClientMetrics;
import com.xiaomi.infra.galaxy.sds.thrift.MetricData;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollector {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsCollector.class);
    private AdminService.Iface adminService = null;
    private BlockingDeque<MetricData> queue = new LinkedBlockingDeque<MetricData>();
    private MetricUploaderThread metricUploaderThread = new MetricUploaderThread(this.queue);

    public MetricsCollector() {
        this.metricUploaderThread.setDaemon(true);
        this.metricUploaderThread.start();
    }

    public void setAdminService(AdminService.Iface adminService) {
        this.adminService = adminService;
    }

    public AdminService.Iface getAdminService() {
        return this.adminService;
    }

    public void collect(RequestMetrics requestMetrics) {
        this.queue.addAll(requestMetrics.toClientMetrics().getMetricDataList());
    }

    private class MetricUploaderThread
    extends Thread {
        private static final String THREAD_NAME = "sds-java-sdk-metrics-uploader";
        private final long timeoutNano;
        private final BlockingQueue<MetricData> queue;

        public MetricUploaderThread(BlockingQueue<MetricData> queue) {
            super(THREAD_NAME);
            this.timeoutNano = TimeUnit.MINUTES.toNanos(1L);
            this.queue = queue;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ClientMetrics clientMetrics = this.nextUploadUnits();
                        MetricsCollector.this.adminService.putClientMetrics(clientMetrics);
                        LOG.info("Pushed " + clientMetrics.getMetricDataListSize() + " client metrics.");
                    }
                }
                catch (Exception ex) {
                    LOG.warn("Unexpected exception, ignored, ", (Throwable)ex);
                    continue;
                }
                break;
            }
        }

        private ClientMetrics nextUploadUnits() throws InterruptedException {
            ClientMetrics clientMetrics = new ClientMetrics();
            long startNano = System.nanoTime();
            long elapsedNano;
            while ((elapsedNano = System.nanoTime() - startNano) <= this.timeoutNano) {
                MetricData metricData = this.queue.poll(this.timeoutNano - elapsedNano, TimeUnit.NANOSECONDS);
                if (metricData == null) {
                    return clientMetrics;
                }
                clientMetrics.addToMetricDataList(metricData);
            }
            return clientMetrics;
        }
    }
}

