/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.client;

import com.google.common.collect.LinkedListMultimap;
import com.xiaomi.infra.galaxy.client.authentication.HttpMethod;
import com.xiaomi.infra.galaxy.client.authentication.HttpUtils;
import com.xiaomi.infra.galaxy.client.authentication.signature.SignAlgorithm;
import com.xiaomi.infra.galaxy.client.authentication.signature.Signer;
import com.xiaomi.infra.galaxy.sds.client.HttpTTransportException;
import com.xiaomi.infra.galaxy.sds.shared.BytesUtil;
import com.xiaomi.infra.galaxy.sds.shared.DigestUtil;
import com.xiaomi.infra.galaxy.sds.shared.clock.AdjustableClock;
import com.xiaomi.infra.galaxy.sds.thrift.AuthenticationConstants;
import com.xiaomi.infra.galaxy.sds.thrift.CommonConstants;
import com.xiaomi.infra.galaxy.sds.thrift.Credential;
import com.xiaomi.infra.galaxy.sds.thrift.HttpStatusCode;
import com.xiaomi.infra.galaxy.sds.thrift.ThriftProtocol;
import com.xiaomi.infra.galaxy.sds.thrift.UserType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import libthrift091.transport.TTransport;
import libthrift091.transport.TTransportException;
import libthrift091.transport.TTransportFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdsTHttpClient
extends TTransport {
    private static final Logger LOG = LoggerFactory.getLogger(SdsTHttpClient.class);
    private static final int REQUEST_ID_LENGTH = 8;
    private URL url_ = null;
    private final ByteArrayOutputStream requestBuffer_ = new ByteArrayOutputStream();
    private InputStream inputStream_ = null;
    private int connectTimeout_ = 0;
    private int socketTimeout_ = 0;
    private Map<String, String> customHeaders_ = null;
    private final HttpHost host;
    private final HttpClient client;
    private Credential credential;
    private AdjustableClock clock;
    private ThriftProtocol protocol_ = ThriftProtocol.TCOMPACT;
    private String queryString = null;
    private boolean supportAccountKey = false;
    private String sid;

    public SdsTHttpClient(String url, HttpClient client, Credential credential) throws TTransportException {
        this(url, client, credential, new AdjustableClock());
    }

    public SdsTHttpClient(String url, HttpClient client, Credential credential, AdjustableClock clock) throws TTransportException {
        try {
            this.url_ = new URL(url);
            this.client = client;
            this.host = new HttpHost(this.url_.getHost(), -1 == this.url_.getPort() ? this.url_.getDefaultPort() : this.url_.getPort(), this.url_.getProtocol());
            this.credential = credential;
            this.clock = clock;
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
    }

    public int getConnectTimeout() {
        if (null != this.client) {
            return this.client.getParams().getIntParameter("http.connection.timeout", 0);
        }
        return -1;
    }

    public int getSocketTimeout() {
        if (null != this.client) {
            return this.client.getParams().getIntParameter("http.socket.timeout", 0);
        }
        return -1;
    }

    public SdsTHttpClient setProtocol(ThriftProtocol protocol) {
        this.protocol_ = protocol;
        return this;
    }

    public ThriftProtocol getProtocol() {
        return this.protocol_;
    }

    public SdsTHttpClient setConnectTimeout(int timeout) {
        this.connectTimeout_ = timeout;
        if (null != this.client) {
            this.client.getParams().setParameter("http.connection.timeout", (Object)this.connectTimeout_);
        }
        return this;
    }

    public SdsTHttpClient setSocketTimeout(int timeout) {
        this.socketTimeout_ = timeout;
        if (null != this.client) {
            this.client.getParams().setParameter("http.socket.timeout", (Object)this.socketTimeout_);
        }
        return this;
    }

    public SdsTHttpClient setCustomHeaders(Map<String, String> headers) {
        this.customHeaders_ = headers;
        return this;
    }

    public SdsTHttpClient setCustomHeader(String key, String value) {
        if (this.customHeaders_ == null) {
            this.customHeaders_ = new HashMap<String, String>();
        }
        this.customHeaders_.put(key, value);
        return this;
    }

    public SdsTHttpClient setQueryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public SdsTHttpClient setSupportAccountKey(boolean supportAccountKey) {
        this.supportAccountKey = supportAccountKey;
        return this;
    }

    public SdsTHttpClient setSid(String sid) {
        this.sid = sid;
        return this;
    }

    public void open() {
    }

    public void close() {
        if (null != this.inputStream_) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream_ = null;
        }
    }

    public boolean isOpen() {
        return true;
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (this.inputStream_ == null) {
            throw new TTransportException("Response buffer is empty, no request.");
        }
        try {
            int ret = this.inputStream_.read(buf, off, len);
            if (ret == -1) {
                throw new TTransportException("No more data available.");
            }
            return ret;
        }
        catch (IOException iox) {
            throw new TTransportException((Throwable)iox);
        }
    }

    public void write(byte[] buf, int off, int len) {
        this.requestBuffer_.write(buf, off, len);
    }

    private static void consume(HttpEntity entity) throws IOException {
        InputStream instream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (instream = entity.getContent()) != null) {
            instream.close();
        }
    }

    private void flushUsingHttpClient() throws TTransportException {
        if (null == this.client) {
            throw new RuntimeException("Null HttpClient, aborting.");
        }
        byte[] data = this.requestBuffer_.toByteArray();
        this.requestBuffer_.reset();
        HttpPost post = null;
        InputStream is = null;
        try {
            String requestId = SdsTHttpClient.generateRandomId(8);
            StringBuilder sb = new StringBuilder();
            sb.append(this.url_.getFile()).append("?id=").append(requestId);
            if (this.queryString != null) {
                sb.append("&").append(this.queryString);
            }
            String uri = sb.toString();
            post = new HttpPost(uri);
            post.setHeader("Content-Type", (String)CommonConstants.THRIFT_HEADER_MAP.get(this.protocol_));
            post.setHeader("Accept", (String)CommonConstants.THRIFT_HEADER_MAP.get(this.protocol_));
            post.setHeader("User-Agent", "Java/THttpClient/HC");
            this.setCustomHeaders(post);
            this.setAuthenticationHeaders(post, data);
            post.setEntity((HttpEntity)new ByteArrayEntity(data));
            HttpResponse response = this.client.execute(this.host, (HttpRequest)post);
            int responseCode = response.getStatusLine().getStatusCode();
            String reasonPhrase = response.getStatusLine().getReasonPhrase();
            is = response.getEntity().getContent();
            if (responseCode != 200) {
                this.adjustClock(response, responseCode);
                throw new HttpTTransportException(responseCode, reasonPhrase);
            }
            byte[] buf = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int len = 0;
            do {
                if ((len = is.read(buf)) <= 0) continue;
                baos.write(buf, 0, len);
            } while (-1 != len);
            try {
                SdsTHttpClient.consume(response.getEntity());
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.inputStream_ = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ioe) {
            if (null != post) {
                post.abort();
            }
            throw new TTransportException((Throwable)ioe);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    throw new TTransportException((Throwable)ioe);
                }
            }
        }
    }

    public void flush() throws TTransportException {
        if (this.client == null) {
            throw new RuntimeException("not supported");
        }
        this.flushUsingHttpClient();
    }

    private SdsTHttpClient setCustomHeaders(HttpPost post) {
        if (this.client != null && this.customHeaders_ != null) {
            for (Map.Entry<String, String> header : this.customHeaders_.entrySet()) {
                post.setHeader(header.getKey(), header.getValue());
            }
        }
        return this;
    }

    private SdsTHttpClient setAuthenticationHeaders(HttpPost post, byte[] data) {
        if (this.client != null && this.credential != null && this.credential.getType() != null && this.credential.getSecretKeyId() != null) {
            if (((Boolean)AuthenticationConstants.SIGNATURE_SUPPORT.get(this.credential.getType())).booleanValue()) {
                String host = this.host.toHostString();
                host = host.split(":")[0];
                post.setHeader("Host", host);
                String timestamp = Long.toString(this.clock.getCurrentEpoch());
                post.setHeader("X-Xiaomi-Timestamp", timestamp);
                post.setHeader("x-xiaomi-date", HttpUtils.getGMTDatetime((Date)new Date()));
                String md5 = BytesUtil.bytesToHex((byte[])DigestUtil.digest((DigestUtil.DigestAlgorithm)DigestUtil.DigestAlgorithm.MD5, (byte[])data));
                post.setHeader("X-Xiaomi-Content-MD5", md5);
                LinkedListMultimap headers = LinkedListMultimap.create();
                for (Header header : post.getAllHeaders()) {
                    headers.put((Object)header.getName().toLowerCase(), (Object)header.getValue());
                }
                try {
                    String authType = "Galaxy-V2 ";
                    if (this.supportAccountKey) {
                        authType = "Galaxy-V3 ";
                    }
                    if (this.credential.getType() == UserType.APP_ACCESS_TOKEN) {
                        authType = "OAuth ";
                    }
                    String authString = authType + this.credential.getSecretKeyId() + ":" + Signer.signToBase64((HttpMethod)HttpMethod.POST, (URI)post.getURI(), (LinkedListMultimap)headers, (String)this.credential.getSecretKey(), (SignAlgorithm)SignAlgorithm.HmacSHA1);
                    post.setHeader("Authorization", authString);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to sign", e);
                }
            } else if (this.credential.getType() == UserType.APP_XIAOMI_SSO) {
                String authString = "SSO " + this.sid + ":" + this.credential.getSecretKey() + ":" + this.credential.getSecretKeyId();
                post.setHeader("Authorization", authString);
            } else if (this.credential.getType() == UserType.APP_ANONYMOUS) {
                String authString = "Guest " + this.credential.getSecretKeyId();
                post.setHeader("Authorization", authString);
            } else {
                throw new RuntimeException("Unsupported user type: " + this.credential.getType());
            }
        }
        return this;
    }

    private boolean adjustClock(HttpResponse response, int httpStatusCode) {
        if (httpStatusCode == HttpStatusCode.CLOCK_TOO_SKEWED.getValue()) {
            Header[] headers;
            for (Header h : headers = response.getHeaders("X-Xiaomi-Timestamp")) {
                String hv = h.getValue();
                long serverTime = Long.parseLong(hv);
                long min = 1261440000L;
                long max = 1892160000L;
                if (serverTime <= min || serverTime >= max) continue;
                LOG.debug("Adjusting client time from {} to {}", (Object)new Date(this.clock.getCurrentEpoch() * 1000L), (Object)new Date(serverTime * 1000L));
                this.clock.adjust(serverTime);
                return true;
            }
        }
        return false;
    }

    private static String generateRandomId(int length) {
        return UUID.randomUUID().toString().substring(0, length);
    }

    public static class Factory
    extends TTransportFactory {
        private final String url;
        private final HttpClient client;
        private final Credential credential;
        private final AdjustableClock clock;

        public Factory(String url, HttpClient client, Credential credential, AdjustableClock clock) {
            this.url = url;
            this.client = client;
            this.credential = credential;
            this.clock = clock;
        }

        public TTransport getTransport(TTransport trans) {
            try {
                return new SdsTHttpClient(this.url, this.client, this.credential, this.clock);
            }
            catch (TTransportException tte) {
                return null;
            }
        }
    }
}

