/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.client;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdsClientConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SdsClientConfig.class);
    private int maxRetry;
    private int clientTimeout;
    private int clientConnTimeout;
    private int adminOperationTimeout;
    protected String serviceEndpoint;
    private int maxTotalConnections;
    private int maxTotalConnectionsPerRoute;
    private boolean isRetry;
    protected Properties properties;

    public SdsClientConfig(String fileName) {
        this(SdsClientConfig.loadProperties(fileName));
    }

    public SdsClientConfig(Properties pro) {
        this.properties = pro;
        this.maxRetry = Integer.parseInt(this.properties.getProperty("galaxy.sds.client.max.retry", String.valueOf(1)));
        this.clientTimeout = Integer.parseInt(this.properties.getProperty("galaxy.sds.client.timeout.milli.secs", String.valueOf(10000)));
        this.clientConnTimeout = Integer.parseInt(this.properties.getProperty("galaxy.sds.client.conn.timeout.milli.secs", String.valueOf(5000)));
        this.adminOperationTimeout = Integer.parseInt(this.properties.getProperty("galaxy.sds.client.admin.timeout.milli.secs", String.valueOf(30000)));
        this.serviceEndpoint = this.properties.getProperty("galaxy.sds.service.endpoint", null);
        if (this.serviceEndpoint == null) {
            throw new RuntimeException("The property of 'galaxy.sds.service.endpoint' must be set");
        }
        this.maxTotalConnections = Integer.parseInt(this.properties.getProperty("galaxy.sds.http.max.total.connection", String.valueOf(160)));
        this.maxTotalConnectionsPerRoute = Integer.parseInt(this.properties.getProperty("galaxy.sds.http.max.total.connection.per.route", String.valueOf(160)));
        this.isRetry = Boolean.parseBoolean(this.properties.getProperty("galaxy.sds.client.is.retry", String.valueOf(false)));
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public int getClientTimeout() {
        return this.clientTimeout;
    }

    public int getClientConnTimeout() {
        return this.clientConnTimeout;
    }

    public int getAdminOperationTimeout() {
        return this.adminOperationTimeout;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public int getMaxTotalConnectionsPerRoute() {
        return this.maxTotalConnectionsPerRoute;
    }

    public boolean isRetry() {
        return this.isRetry;
    }

    public static Properties loadProperties(String fileName) {
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Load properties file error for: " + fileName, e);
        }
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            LOG.warn("Load FileInputStream exception", (Throwable)e);
        }
        return properties;
    }
}

