/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.client;

import com.xiaomi.infra.galaxy.sds.client.AutoRetryClient;
import com.xiaomi.infra.galaxy.sds.client.ThreadSafeClient;
import com.xiaomi.infra.galaxy.sds.client.metrics.MetricsCollector;
import com.xiaomi.infra.galaxy.sds.shared.clock.AdjustableClock;
import com.xiaomi.infra.galaxy.sds.thrift.AdminService;
import com.xiaomi.infra.galaxy.sds.thrift.AuthService;
import com.xiaomi.infra.galaxy.sds.thrift.Credential;
import com.xiaomi.infra.galaxy.sds.thrift.TableService;
import com.xiaomi.infra.galaxy.sds.thrift.ThriftProtocol;
import com.xiaomi.infra.galaxy.sds.thrift.Version;
import com.xiaomi.infra.galaxy.sds.thrift.VersionUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ClientFactory.class);
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final Version VERSION = new Version();
    private static final String SID = "galaxysds";
    private Credential credential = null;
    private Map<String, String> customHeaders = null;
    private HttpClient httpClient;
    private AdjustableClock clock = new AdjustableClock();
    private ThriftProtocol protocol;
    private MetricsCollector metricsCollector = null;
    private boolean isMetricsEnabled = false;

    private static HttpClient generateHttpClient() {
        return ClientFactory.generateHttpClient(1, 1, 3000);
    }

    public static HttpClient generateHttpClient(int maxTotalConnections, int maxTotalConnectionsPerRoute) {
        return ClientFactory.generateHttpClient(maxTotalConnections, maxTotalConnectionsPerRoute, 3000);
    }

    public static HttpClient generateHttpClient(int maxTotalConnections, final int maxTotalConnectionsPerRoute, int connTimeout) {
        BasicHttpParams params = new BasicHttpParams();
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)maxTotalConnections);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRoute(){

            public int getMaxForRoute(HttpRoute route) {
                return maxTotalConnectionsPerRoute;
            }
        });
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connTimeout);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        SSLSocketFactory sslSocketFactory = SSLSocketFactory.getSocketFactory();
        sslSocketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        schemeRegistry.register(new Scheme("https", (SocketFactory)sslSocketFactory, 443));
        ThreadSafeClientConnManager conMgr = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        return new DefaultHttpClient((ClientConnectionManager)conMgr, (HttpParams)params);
    }

    public ClientFactory() {
        this.httpClient = ClientFactory.generateHttpClient();
        this.protocol = ThriftProtocol.TBINARY;
    }

    public ClientFactory setCredential(Credential credential) {
        this.credential = credential;
        return this;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public ClientFactory setClock(AdjustableClock clock) {
        this.clock = clock;
        return this;
    }

    public AdjustableClock getClock() {
        return this.clock;
    }

    public ClientFactory setMetricsEnabled(boolean isMetricsEnabled) {
        this.isMetricsEnabled = isMetricsEnabled;
        return this;
    }

    public boolean getMetricsEnabled() {
        return this.isMetricsEnabled;
    }

    public ClientFactory setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ClientFactory setProtocol(ThriftProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public ThriftProtocol getProtocol() {
        return this.protocol;
    }

    public ClientFactory setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public Version getSDKVersion() {
        return VERSION;
    }

    public AuthService.Iface newAuthClient() {
        String url = "http://sds.api.xiaomi.com/v1/api/auth";
        return this.newAuthClient(url);
    }

    public AuthService.Iface newAuthClient(boolean supportAccountKey) {
        String url = "http://sds.api.xiaomi.com/v1/api/auth";
        return this.newAuthClient(url, supportAccountKey);
    }

    public AuthService.Iface newAuthClient(String url) {
        return this.newAuthClient(url, false);
    }

    public AuthService.Iface newAuthClient(String url, boolean supportAccountKey) {
        return this.newAuthClient(url, 10000, 3000, supportAccountKey);
    }

    public AuthService.Iface newAuthClient(String url, int socketTimeout, int connTimeout) {
        return this.newAuthClient(url, socketTimeout, connTimeout, false);
    }

    public AuthService.Iface newAuthClient(String url, int socketTimeout, int connTimeout, boolean supportAccountKey) {
        return this.createClient(AuthService.Iface.class, AuthService.Client.class, url, socketTimeout, connTimeout, false, 1, supportAccountKey);
    }

    public AuthService.Iface newAuthClient(String url, boolean isRetry, int maxRetry) {
        return this.newAuthClient(url, isRetry, maxRetry, false);
    }

    public AuthService.Iface newAuthClient(String url, boolean isRetry, int maxRetry, boolean supportAccountKey) {
        return this.createClient(AuthService.Iface.class, AuthService.Client.class, url, 10000, 3000, isRetry, maxRetry, supportAccountKey);
    }

    public AuthService.Iface newAuthClient(String url, int socketTimeout, int connTimeout, boolean isRetry, int maxRetry) {
        return this.newAuthClient(url, socketTimeout, connTimeout, isRetry, maxRetry, false);
    }

    public AuthService.Iface newAuthClient(String url, int socketTimeout, int connTimeout, boolean isRetry, int maxRetry, boolean supportAccountKey) {
        return this.createClient(AuthService.Iface.class, AuthService.Client.class, url, socketTimeout, connTimeout, isRetry, maxRetry, supportAccountKey);
    }

    public AdminService.Iface newAdminClient() {
        if (this.credential == null) {
            throw new IllegalArgumentException("Credential is not set");
        }
        String url = "http://sds.api.xiaomi.com/v1/api/admin";
        return this.newAdminClient(url);
    }

    public AdminService.Iface newAdminClient(boolean supportAccountKey) {
        if (this.credential == null) {
            throw new IllegalArgumentException("Credential is not set");
        }
        String url = "http://sds.api.xiaomi.com/v1/api/admin";
        return this.newAdminClient(url, supportAccountKey);
    }

    public AdminService.Iface newAdminClient(String url) {
        return this.newAdminClient(url, false);
    }

    public AdminService.Iface newAdminClient(String url, boolean supportAccountKey) {
        return this.newAdminClient(url, 30000, 3000, supportAccountKey);
    }

    public AdminService.Iface newAdminClient(String url, int socketTimeout, int connTimeout) {
        return this.newAdminClient(url, socketTimeout, connTimeout, false);
    }

    public AdminService.Iface newAdminClient(String url, int socketTimeout, int connTimeout, boolean supportAccountKey) {
        return this.createClient(AdminService.Iface.class, AdminService.Client.class, url, socketTimeout, connTimeout, false, 1, supportAccountKey);
    }

    public AdminService.Iface newAdminClient(String url, boolean isRetry, int maxRetry) {
        return this.newAdminClient(url, isRetry, maxRetry, false);
    }

    public AdminService.Iface newAdminClient(String url, boolean isRetry, int maxRetry, boolean supportAccountKey) {
        return this.createClient(AdminService.Iface.class, AdminService.Client.class, url, 30000, 3000, isRetry, maxRetry, supportAccountKey);
    }

    public AdminService.Iface newAdminClient(String url, int socketTimeout, int connTimeout, boolean isRetry, int maxRetry) {
        return this.newAdminClient(url, socketTimeout, connTimeout, isRetry, maxRetry, false);
    }

    public AdminService.Iface newAdminClient(String url, int socketTimeout, int connTimeout, boolean isRetry, int maxRetry, boolean supportAccountKey) {
        return this.createClient(AdminService.Iface.class, AdminService.Client.class, url, socketTimeout, connTimeout, isRetry, maxRetry, supportAccountKey);
    }

    public TableService.Iface newTableClient() {
        if (this.credential == null) {
            throw new IllegalArgumentException("Credential is not set");
        }
        String url = "http://sds.api.xiaomi.com/v1/api/table";
        return this.newTableClient(url);
    }

    public TableService.Iface newTableClient(boolean supportAccountKey) {
        if (this.credential == null) {
            throw new IllegalArgumentException("Credential is not set");
        }
        String url = "http://sds.api.xiaomi.com/v1/api/table";
        return this.newTableClient(url, supportAccountKey);
    }

    public TableService.Iface newTableClient(String url) {
        return this.newTableClient(url, false);
    }

    public TableService.Iface newTableClient(String url, boolean supportAccountKey) {
        return this.newTableClient(url, 10000, 3000, supportAccountKey);
    }

    public TableService.Iface newTableClient(String url, int socketTimeout, int connTimeout) {
        return this.newTableClient(url, socketTimeout, connTimeout, false);
    }

    public TableService.Iface newTableClient(String url, int socketTimeout, int connTimeout, boolean supportAccountKey) {
        return this.createClient(TableService.Iface.class, TableService.Client.class, url, socketTimeout, connTimeout, false, 1, supportAccountKey);
    }

    public TableService.Iface newTableClient(String url, boolean isRetry, int maxRetry) {
        return this.newTableClient(url, isRetry, maxRetry, false);
    }

    public TableService.Iface newTableClient(String url, boolean isRetry, int maxRetry, boolean supportAccountKey) {
        return this.createClient(TableService.Iface.class, TableService.Client.class, url, 10000, 3000, isRetry, maxRetry, supportAccountKey);
    }

    public TableService.Iface newTableClient(String url, int socketTimeout, int connTimeout, boolean isRetry, int maxRetry) {
        return this.newTableClient(url, socketTimeout, connTimeout, isRetry, maxRetry, false);
    }

    public TableService.Iface newTableClient(String url, int socketTimeout, int connTimeout, boolean isRetry, int maxRetry, boolean supportAccountKey) {
        return this.createClient(TableService.Iface.class, TableService.Client.class, url, socketTimeout, connTimeout, isRetry, maxRetry, supportAccountKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <IFace, Impl> IFace createClient(Class<IFace> ifaceClass, Class<Impl> implClass, String url, int socketTimeout, int connTimeout, boolean isRetry, int maxRetry, boolean supportAccountKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(USER_AGENT_HEADER, this.createUserAgentHeader());
        headers.put("X-Xiaomi-Request-Timeout", String.valueOf(socketTimeout));
        if (this.customHeaders != null) {
            headers.putAll(this.customHeaders);
        }
        if (this.isMetricsEnabled) {
            ClientFactory clientFactory = this;
            synchronized (clientFactory) {
                if (this.metricsCollector == null) {
                    AdminService.Iface adminClient = ThreadSafeClient.getClient(this.httpClient, headers, this.credential, this.clock, this.protocol, AdminService.Iface.class, AdminService.Client.class, url, 10000, 3000, false, SID);
                    AdminService.Iface metricAdminServiceClient = AutoRetryClient.getAutoRetryClient(AdminService.Iface.class, adminClient, true, 3);
                    this.metricsCollector = new MetricsCollector();
                    this.metricsCollector.setAdminService(metricAdminServiceClient);
                }
            }
        }
        IFace client = ThreadSafeClient.getClient(this.httpClient, headers, this.credential, this.clock, this.protocol, ifaceClass, implClass, url, socketTimeout, connTimeout, supportAccountKey, SID, this.metricsCollector);
        return AutoRetryClient.getAutoRetryClient(ifaceClass, client, isRetry, maxRetry);
    }

    protected String createUserAgentHeader() {
        return String.format("Java-SDK/%s Java/%s", VersionUtil.versionString((Version)VERSION), System.getProperty("java.version"));
    }
}

