/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.client;

import com.xiaomi.infra.galaxy.sds.client.RetryUtils;
import com.xiaomi.infra.galaxy.sds.client.ThrottleUtils;
import com.xiaomi.infra.galaxy.sds.thrift.ErrorCode;
import com.xiaomi.infra.galaxy.sds.thrift.RetryType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoRetryClient {
    public static <T> T getAutoRetryClient(Class<T> interfaceClass, Object instance, boolean isRetry, int maxRetry) {
        return (T)Proxy.newProxyInstance(AutoRetryClient.class.getClassLoader(), new Class[]{interfaceClass}, new AutoRetryHandler<T>(interfaceClass, instance, isRetry, maxRetry));
    }

    private static class AutoRetryHandler<T>
    implements InvocationHandler {
        private static final Logger LOG = LoggerFactory.getLogger(AutoRetryHandler.class);
        private final Object instance;
        private final boolean isRetry;
        private final int maxRetry;
        private ThreadLocal<Long> lastPauseTime = new ThreadLocal<Long>(){

            @Override
            public Long initialValue() {
                return 0L;
            }
        };

        public AutoRetryHandler(Class<T> interfaceClass, Object instance, boolean isRetry, int maxRetry) {
            this.instance = instance;
            this.isRetry = isRetry;
            this.maxRetry = maxRetry;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            int retry = 0;
            long pauseTime = ThrottleUtils.getPauseTime(this.lastPauseTime.get());
            while (true) {
                try {
                    if (retry == 0) {
                        ThrottleUtils.sleepPauseTime(pauseTime);
                    }
                    Object ret = method.invoke(this.instance, args);
                    this.lastPauseTime.set(pauseTime < 0L ? 0L : pauseTime);
                    return ret;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (this.maxRetry < 0 || retry >= this.maxRetry) {
                        this.lastPauseTime.set(pauseTime < 0L ? 0L : pauseTime);
                        LOG.debug("reach max retry number, retry = {}", (Object)retry);
                        throw cause;
                    }
                    ErrorCode code = RetryUtils.getErrorCode(cause);
                    RetryType retryType = RetryUtils.getRetryType(code);
                    pauseTime = ThrottleUtils.getPauseTime(code, retry);
                    if (!this.isRetry && (retryType == null || !retryType.equals((Object)RetryType.SAFE)) || pauseTime < 0L) {
                        this.lastPauseTime.set(pauseTime < 0L ? 0L : pauseTime);
                        LOG.debug("Won't retry, retry = {}", (Object)retry);
                        throw cause;
                    }
                    if (pauseTime >= 0L) {
                        ThrottleUtils.sleepPauseTime(pauseTime);
                        LOG.debug("sleep for {} ms in the {} retry", (Object)pauseTime, (Object)retry);
                    }
                    LOG.debug("Auto retrying RPC call {} for {} time", (Object)method.getName(), (Object)(++retry));
                    continue;
                }
                break;
            }
        }
    }
}

