/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.fds.example;

import com.xiaomi.infra.galaxy.fds.client.FDSClientConfiguration;
import com.xiaomi.infra.galaxy.fds.client.GalaxyFDSClient;
import com.xiaomi.infra.galaxy.fds.client.credential.BasicFDSCredential;
import com.xiaomi.infra.galaxy.fds.client.exception.GalaxyFDSClientException;
import com.xiaomi.infra.galaxy.fds.client.model.FDSBucket;
import com.xiaomi.infra.galaxy.fds.client.model.FDSObject;
import com.xiaomi.infra.galaxy.fds.client.model.FDSObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;

public class FDSClient {
    private static final String APP_ACCESS_KEY = "APP_ACCESS_KEY";
    private static final String APP_ACCESS_SECRET = "APP_ACCESS_SECRET";
    private static final String BUCKET_NAME = "BUCKET_NAME";
    private static final String OBJECT_NAME = "OBJECT_NAME";

    public static void main(String[] args) throws GalaxyFDSClientException, IOException {
        List<FDSBucket> buckets;
        BasicFDSCredential credential = new BasicFDSCredential(APP_ACCESS_KEY, APP_ACCESS_SECRET);
        FDSClientConfiguration fdsConfig = new FDSClientConfiguration();
        fdsConfig.enableHttps(true);
        fdsConfig.enableCdnForUpload(false);
        fdsConfig.enableCdnForDownload(true);
        GalaxyFDSClient fdsClient = new GalaxyFDSClient(credential, fdsConfig);
        if (!fdsClient.doesBucketExist(BUCKET_NAME)) {
            fdsClient.createBucket(BUCKET_NAME);
        }
        if ((buckets = fdsClient.listBuckets()) != null) {
            for (FDSBucket bucket : buckets) {
                System.out.println(bucket.getName());
            }
        }
        if (!fdsClient.doesObjectExist(BUCKET_NAME, OBJECT_NAME)) {
            String content = "This is a test object";
            fdsClient.putObject(BUCKET_NAME, OBJECT_NAME, new ByteArrayInputStream(content.getBytes()), null);
        }
        FDSObject object = fdsClient.getObject(BUCKET_NAME, OBJECT_NAME);
        FDSObjectInputStream in = object.getObjectContent();
        byte[] buffer = new byte[1024];
        int totalReadLen = 0;
        int readLen = 0;
        while ((readLen = in.read(buffer, totalReadLen, buffer.length - totalReadLen)) > 0) {
            totalReadLen += readLen;
        }
        in.close();
        fdsClient.deleteObject(BUCKET_NAME, OBJECT_NAME);
        fdsClient.deleteBucket(BUCKET_NAME);
    }
}

