/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.fds.client.model;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FDSMd5InputStream
extends FilterInputStream {
    private MessageDigest messageDigest = MessageDigest.getInstance("MD5");
    byte[] md5 = null;
    int md5left;

    public FDSMd5InputStream(InputStream in) throws NoSuchAlgorithmException {
        super(in);
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        if (this.read(buf) > 0) {
            return buf[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.md5 != null) {
            if (this.md5left > 0) {
                int ret = Math.min(this.md5left, len);
                System.arraycopy(this.md5, this.md5.length - this.md5left, b, off, ret);
                this.md5left -= ret;
                return ret;
            }
            return -1;
        }
        int read = super.read(b, off, len);
        if (read > 0) {
            this.messageDigest.update(b, off, read);
        }
        if (read < 0) {
            this.md5 = this.messageDigest.digest();
            int ret = Math.min(this.md5.length, len);
            System.arraycopy(this.md5, 0, b, off, ret);
            this.md5left = this.md5.length - ret;
            return ret;
        }
        return read;
    }
}

