/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.fds.client.metrics;

import com.google.common.base.Preconditions;
import com.xiaomi.infra.galaxy.fds.Action;
import com.xiaomi.infra.galaxy.fds.client.metrics.ClientMetrics;
import com.xiaomi.infra.galaxy.fds.client.metrics.MetricData;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestMetrics {
    private static final Log LOG = LogFactory.getLog(RequestMetrics.class);
    private Action action;
    private Map<ClientMetrics.LatencyMetricType, TimingInfo> latencyMetrics = new HashMap<ClientMetrics.LatencyMetricType, TimingInfo>();

    public void setRequestTypeName(Action action) {
        this.action = action;
    }

    public void startEvent(ClientMetrics.LatencyMetricType metricType) {
        TimingInfo timingInfo = new TimingInfo(System.currentTimeMillis(), null);
        this.latencyMetrics.put(metricType, timingInfo);
    }

    public void endEvent(ClientMetrics.LatencyMetricType metricType) {
        TimingInfo timingInfo = this.latencyMetrics.get((Object)metricType);
        if (timingInfo == null) {
            LOG.warn((Object)"Try to end event which wasn't started.");
            return;
        }
        timingInfo.setEndTimeMilli(System.currentTimeMillis());
    }

    public ClientMetrics toClientMetrics() {
        ClientMetrics clientMetrics = new ClientMetrics();
        for (Map.Entry<ClientMetrics.LatencyMetricType, TimingInfo> entry : this.latencyMetrics.entrySet()) {
            TimingInfo timingInfo = entry.getValue();
            Preconditions.checkNotNull((Object)timingInfo.getStartTimeMilli());
            Preconditions.checkNotNull((Object)timingInfo.getEndTimeMilli());
            String metricName = this.action.toString() + "." + entry.getKey().toString();
            MetricData metricData = new MetricData().withMetricType(MetricData.MetricType.Latency).withMetricName(metricName).withValue(timingInfo.getEndTimeMilli() - timingInfo.getStartTimeMilli()).withTimeStamp(timingInfo.getEndTimeMilli() / 1000L);
            clientMetrics.add(metricData);
        }
        return clientMetrics;
    }

    private class TimingInfo {
        private Long startTimeMilli;
        private Long endTimeMilli;

        public TimingInfo(Long startTimeMilli, Long endTimeMilli) {
            this.startTimeMilli = startTimeMilli;
            this.endTimeMilli = endTimeMilli;
        }

        public Long getStartTimeMilli() {
            return this.startTimeMilli;
        }

        public void setStartTimeMilli(Long startTimeMilli) {
            this.startTimeMilli = startTimeMilli;
        }

        public Long getEndTimeMilli() {
            return this.endTimeMilli;
        }

        public void setEndTimeMilli(Long endTimeMilli) {
            this.endTimeMilli = endTimeMilli;
        }
    }
}

