/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.fds.client.metrics;

import com.xiaomi.infra.galaxy.fds.client.GalaxyFDSClient;
import com.xiaomi.infra.galaxy.fds.client.metrics.ClientMetrics;
import com.xiaomi.infra.galaxy.fds.client.metrics.MetricData;
import com.xiaomi.infra.galaxy.fds.client.metrics.RequestMetrics;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetricsCollector {
    private static final Log LOG = LogFactory.getLog(MetricsCollector.class);
    private GalaxyFDSClient fdsClient;
    private BlockingQueue<MetricData> queue;
    private MetricUploaderThread metricUploaderThread;

    public MetricsCollector(GalaxyFDSClient fdsClient) {
        this.fdsClient = fdsClient;
        this.queue = new LinkedBlockingDeque<MetricData>();
        this.metricUploaderThread = new MetricUploaderThread(this.queue);
        this.metricUploaderThread.setDaemon(true);
        this.metricUploaderThread.start();
    }

    public void collect(RequestMetrics requestMetrics) {
        this.queue.addAll(requestMetrics.toClientMetrics().getMetrics());
    }

    private class MetricUploaderThread
    extends Thread {
        private static final String THREAD_NAME = "fds-java-sdk-metrics-uploader";
        private final long timeoutNano;
        private final BlockingQueue<MetricData> queue;

        public MetricUploaderThread(BlockingQueue<MetricData> queue) {
            super(THREAD_NAME);
            this.timeoutNano = TimeUnit.MINUTES.toNanos(1L);
            this.queue = queue;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ClientMetrics clientMetrics = this.nextUploadUnits();
                        MetricsCollector.this.fdsClient.putClientMetrics(clientMetrics);
                        LOG.info((Object)("Pushed " + clientMetrics.getMetrics().size() + " client metrics."));
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Unexpected exception, ignored, ", (Throwable)ex);
                    continue;
                }
                break;
            }
        }

        private ClientMetrics nextUploadUnits() throws InterruptedException {
            ClientMetrics clientMetrics = new ClientMetrics();
            long startNano = System.nanoTime();
            long elapsedNano;
            while ((elapsedNano = System.nanoTime() - startNano) <= this.timeoutNano) {
                MetricData metricData = this.queue.poll(this.timeoutNano - elapsedNano, TimeUnit.NANOSECONDS);
                if (metricData == null) {
                    return clientMetrics;
                }
                clientMetrics.add(metricData);
            }
            return clientMetrics;
        }
    }
}

