/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.fds.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class FDSClientConfiguration {
    private static final String URI_HTTP_PREFIX = "http://";
    private static final String URI_HTTPS_PREFIX = "https://";
    private static final String URI_CDN = "cdn";
    private static final String URI_SUFFIX = "fds.api.xiaomi.com";
    private static final String URI_CDN_SUFFIX = "fds.api.mi-img.com";
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 50000;
    public static final int DEFAULT_CONNECTION_TIMEOUT_MS = 50000;
    private static final int DEFAULT_MAX_CONNECTIONS = 20;
    public static final int DEFAULT_MAX_BATCH_DELETE_SIZE = 1000;
    private String regionName = "cnbj0";
    private String endpoint;
    private boolean enableHttps = true;
    private boolean enableCdnForUpload = false;
    private boolean enableCdnForDownload = true;
    private boolean enableMd5Calculate = false;
    private boolean enableUnitTestMode = false;
    private String baseUriForUnitTest = "";
    private boolean enableMetrics = false;
    private boolean enableApacheConnector = false;
    private int connectionTimeoutMs = 50000;
    private int socketTimeoutMs = 50000;
    private int maxConnection = 20;
    private int batchDeleteSize = 1000;

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isHttpsEnabled() {
        return this.enableHttps;
    }

    public void enableHttps(boolean enableHttps) {
        this.enableHttps = enableHttps;
    }

    public boolean isCdnEnabledForUpload() {
        return this.enableCdnForUpload;
    }

    public void enableCdnForUpload(boolean enableCdnForUpload) {
        this.enableCdnForUpload = enableCdnForUpload;
    }

    public boolean isCdnEnabledForDownload() {
        return this.enableCdnForDownload;
    }

    public void enableCdnForDownload(boolean enableCdnForDownload) {
        this.enableCdnForDownload = enableCdnForDownload;
    }

    public boolean isMd5CalculateEnabled() {
        return this.enableMd5Calculate;
    }

    public void setEnableMd5Calculate(boolean enableMd5Calculate) {
        this.enableMd5Calculate = enableMd5Calculate;
    }

    public void enableMetrics() {
        this.enableMetrics = true;
    }

    public void disableMetrics() {
        this.enableMetrics = false;
    }

    public boolean isApacheConnectorEnabled() {
        return this.enableApacheConnector;
    }

    public void enableApacheConnector(boolean enableApacheConnector) {
        this.enableApacheConnector = enableApacheConnector;
    }

    public boolean isMetricsEnabled() {
        return this.enableMetrics;
    }

    boolean isEnabledUnitTestMode() {
        return this.enableUnitTestMode;
    }

    void enableUnitTestMode(boolean enableUnitTestMode) {
        this.enableUnitTestMode = enableUnitTestMode;
    }

    void setBaseUriForUnitTest(String baseUriForUnitTest) {
        this.baseUriForUnitTest = baseUriForUnitTest;
    }

    String getBaseUri() {
        return this.buildBaseUri(false);
    }

    String getCdnBaseUri() {
        return this.buildBaseUri(true);
    }

    String getDownloadBaseUri() {
        return this.buildBaseUri(this.enableCdnForDownload);
    }

    String getUploadBaseUri() {
        return this.buildBaseUri(this.enableCdnForUpload);
    }

    String buildBaseUri(boolean enableCdn) {
        if (this.enableUnitTestMode) {
            return this.baseUriForUnitTest;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.enableHttps ? URI_HTTPS_PREFIX : URI_HTTP_PREFIX);
        if (!Strings.isNullOrEmpty((String)this.endpoint)) {
            sb.append(this.endpoint);
        } else if (enableCdn) {
            sb.append("cdn." + this.regionName + "." + URI_CDN_SUFFIX);
        } else {
            sb.append(this.regionName + "." + URI_SUFFIX);
        }
        sb.append("/");
        return sb.toString();
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public FDSClientConfiguration withConnectionTimeoutMs(int connectionTimeout) {
        this.setConnectionTimeoutMs(connectionTimeout);
        return this;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public FDSClientConfiguration withSocketTimeoutMs(int socketTimeout) {
        this.setSocketTimeoutMs(socketTimeout);
        return this;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public void setMaxBatchDeleteSize(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)("size should be positive, got" + size));
        Preconditions.checkArgument((size <= 1000 ? 1 : 0) != 0, (Object)("size should <= 1000 got " + size));
        this.batchDeleteSize = size;
    }

    public int getMaxBatchDeleteSize() {
        return this.batchDeleteSize;
    }
}

