/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.client.examples;

import com.xiaomi.infra.galaxy.sds.client.ClientFactory;
import com.xiaomi.infra.galaxy.sds.thrift.AdminService;
import com.xiaomi.infra.galaxy.sds.thrift.Credential;
import com.xiaomi.infra.galaxy.sds.thrift.DataType;
import com.xiaomi.infra.galaxy.sds.thrift.Datum;
import com.xiaomi.infra.galaxy.sds.thrift.DatumUtil;
import com.xiaomi.infra.galaxy.sds.thrift.KeySpec;
import com.xiaomi.infra.galaxy.sds.thrift.ProvisionThroughput;
import com.xiaomi.infra.galaxy.sds.thrift.TableInfo;
import com.xiaomi.infra.galaxy.sds.thrift.TableMetadata;
import com.xiaomi.infra.galaxy.sds.thrift.TableQuota;
import com.xiaomi.infra.galaxy.sds.thrift.TableSchema;
import com.xiaomi.infra.galaxy.sds.thrift.TableService;
import com.xiaomi.infra.galaxy.sds.thrift.TableSpec;
import com.xiaomi.infra.galaxy.sds.thrift.UserType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Basic {
    private static ClientFactory clientFactory;
    private static AdminService.Iface adminClient;
    private static TableService.Iface tableClient;
    private static String secretKeyId;
    private static String secretKey;
    public static String appKey;
    public static String appSecret;
    private static UserType userType;
    private static String endpoint;
    private static boolean isInit;
    private static String tableName;
    private static String[] cities;

    private static void init() {
        Credential credential = new Credential().setSecretKey(secretKey).setSecretKeyId(secretKeyId).setType(userType);
        clientFactory = new ClientFactory().setCredential(credential);
        adminClient = clientFactory.newAdminClient(endpoint + "/v1/api/admin", 50000, 3000);
        tableClient = clientFactory.newTableClient(endpoint + "/v1/api/table", 10000, 3000, true, 5);
        isInit = true;
    }

    private static TableSpec tableSpec() {
        List<KeySpec> primaryKey = Arrays.asList(new KeySpec().setAttribute("cityId"), new KeySpec().setAttribute("timestamp").setAsc(false));
        HashMap<String, DataType> attributes = new HashMap<String, DataType>();
        attributes.put("cityId", DataType.STRING);
        attributes.put("timestamp", DataType.INT64);
        attributes.put("score", DataType.DOUBLE);
        attributes.put("pm25", DataType.INT64);
        TableSchema tableSchema = new TableSchema();
        tableSchema.setPrimaryIndex(primaryKey).setAttributes(attributes).setTtl(-1);
        TableMetadata tableMetadata = new TableMetadata();
        tableMetadata.setQuota(new TableQuota().setSize(0x6400000L)).setThroughput(new ProvisionThroughput().setReadCapacity(20L).setWriteCapacity(20L));
        return new TableSpec().setSchema(tableSchema).setMetadata(tableMetadata);
    }

    private static void printResult(Map<String, Datum> resultToPrint) {
        if (resultToPrint != null) {
            for (Map.Entry<String, Datum> e : resultToPrint.entrySet()) {
                System.out.println(String.format("[%s] => %s", e.getKey(), DatumUtil.fromDatum((Datum)e.getValue()).toString()));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Basic.init();
        List tableInfos = adminClient.findAllTables();
        System.out.println("table infos are " + tableInfos);
        for (TableInfo tableInfo : tableInfos) {
            adminClient.dropTable(tableInfo.getName());
        }
    }

    static {
        secretKeyId = "5661730319041";
        secretKey = "7a2VN6s55Yah4dlwufUcYQ==";
        appKey = "5661730319041";
        appSecret = "7a2VN6s55Yah4dlwufUcYQ==";
        userType = UserType.APP_SECRET;
        endpoint = "http://staging.sds.api.xiaomi.com";
        isInit = false;
        tableName = "java-test-weather";
        cities = new String[]{"\u5317\u4eac", "Beihai", "Dalian", "Dandong", "Fuzhou", "Guangzhou", "Haikou", "Hankou", "Huangpu", "Jiujiang", "Lianyungang", "Nanjing", "Nantong", "Ningbo", "Qingdao", "Qinhuangdao", "Rizhao", "Sanya", "Shanghai", "Shantou", "Shenzhen", "Tianjin", "Weihai", "Wenzhou", "Xiamen", "Yangzhou", "Yantai"};
    }
}

