/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.client;

import com.xiaomi.infra.galaxy.sds.client.SdsRequestUtils;
import com.xiaomi.infra.galaxy.sds.client.SdsTHttpClient;
import com.xiaomi.infra.galaxy.sds.client.metrics.MetricsCollector;
import com.xiaomi.infra.galaxy.sds.client.metrics.RequestMetrics;
import com.xiaomi.infra.galaxy.sds.shared.clock.AdjustableClock;
import com.xiaomi.infra.galaxy.sds.thrift.CommonConstants;
import com.xiaomi.infra.galaxy.sds.thrift.Credential;
import com.xiaomi.infra.galaxy.sds.thrift.LatencyMetricType;
import com.xiaomi.infra.galaxy.sds.thrift.ThriftProtocol;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import libthrift091.protocol.TProtocol;
import libthrift091.transport.TTransport;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadSafeClient<IFace, Impl> {
    public static <IFace, Impl> IFace getClient(HttpClient client, Map<String, String> customHeaders, Credential credential, AdjustableClock clock, ThriftProtocol protocol, Class<IFace> ifaceClass, Class<Impl> implClass, String url, int socketTimeout, int connTimeout, boolean supportAccountKey, String sid) {
        return ThreadSafeClient.getClient(client, customHeaders, credential, clock, protocol, ifaceClass, implClass, url, socketTimeout, connTimeout, supportAccountKey, sid, null);
    }

    public static <IFace, Impl> IFace getClient(HttpClient client, Map<String, String> customHeaders, Credential credential, AdjustableClock clock, ThriftProtocol protocol, Class<IFace> ifaceClass, Class<Impl> implClass, String url, int socketTimeout, int connTimeout, boolean supportAccountKey, String sid, MetricsCollector metricsCollector) {
        return (IFace)Proxy.newProxyInstance(ThreadSafeClient.class.getClassLoader(), new Class[]{ifaceClass}, new ThreadSafeInvocationHandler(client, customHeaders, credential, clock, protocol, ifaceClass, implClass, url, socketTimeout, connTimeout, supportAccountKey, sid, metricsCollector));
    }

    private static class ThreadSafeInvocationHandler<IFace, Impl>
    implements InvocationHandler {
        private static final Logger LOG = LoggerFactory.getLogger(ThreadSafeInvocationHandler.class);
        private static final Map<Class, Constructor> ctorCache = new ConcurrentHashMap<Class, Constructor>();
        private final HttpClient client;
        private final Map<String, String> customHeaders;
        private final Credential credential;
        private final AdjustableClock clock;
        private final ThriftProtocol protocol;
        final Class<IFace> ifaceClass;
        final Class<Impl> implClass;
        final String url;
        private int socketTimeout = 0;
        private int connTimeout = 0;
        private boolean supportAccountKey = false;
        private boolean isMetricsEnabled = false;
        private String sid;
        private MetricsCollector metricsCollector;

        private ThreadSafeInvocationHandler(HttpClient client, Map<String, String> customHeaders, Credential credential, AdjustableClock clock, ThriftProtocol protocol, Class<IFace> ifaceClass, Class<Impl> implClass, String url, int socketTimeout, int connTimeout, boolean supportAccountKey, String sid, MetricsCollector metricsCollector) {
            this.client = client;
            this.customHeaders = customHeaders;
            this.credential = credential;
            this.clock = clock;
            this.protocol = protocol;
            this.ifaceClass = ifaceClass;
            this.implClass = implClass;
            this.url = url;
            this.socketTimeout = socketTimeout;
            this.connTimeout = connTimeout;
            this.supportAccountKey = supportAccountKey;
            this.sid = sid;
            this.metricsCollector = metricsCollector;
            if (metricsCollector != null) {
                this.isMetricsEnabled = true;
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            RequestMetrics requestMetrics = null;
            try {
                if (this.isMetricsEnabled) {
                    requestMetrics = new RequestMetrics();
                    requestMetrics.startEvent(LatencyMetricType.ExecutionTime);
                    requestMetrics.setRequestTypeName(method.getName());
                }
                SdsTHttpClient sdsHttpClient = new SdsTHttpClient(this.url, this.client, this.credential, this.clock);
                sdsHttpClient.setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connTimeout).setProtocol(this.protocol).setQueryString(SdsRequestUtils.getQuery(method, args)).setSupportAccountKey(this.supportAccountKey).setSid(this.sid);
                if (this.customHeaders != null) {
                    for (Map.Entry<String, String> header : this.customHeaders.entrySet()) {
                        sdsHttpClient.setCustomHeader(header.getKey(), header.getValue());
                    }
                }
                String protocolClassName = "libthrift091.protocol." + (String)CommonConstants.THRIFT_PROTOCOL_MAP.get(this.protocol);
                Class<?> protocolClass = Class.forName(protocolClassName);
                Constructor<?> ctor = protocolClass.getDeclaredConstructor(TTransport.class);
                Impl client = ThreadSafeInvocationHandler.getDeclaredConstructor(this.implClass).newInstance(ctor.newInstance(new Object[]{sdsHttpClient}));
                Object object = method.invoke(client, args);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (this.isMetricsEnabled) {
                    requestMetrics.endEvent(LatencyMetricType.ExecutionTime);
                    this.metricsCollector.collect(requestMetrics);
                }
            }
        }

        public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz) throws NoSuchMethodException {
            Constructor<T> ctor = ctorCache.get(clazz);
            if (ctor == null) {
                ctor = clazz.getDeclaredConstructor(TProtocol.class);
                ctorCache.put(clazz, ctor);
            }
            return ctor;
        }
    }
}

