/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.client;

import com.xiaomi.infra.galaxy.sds.client.ThrottleUtils;
import com.xiaomi.infra.galaxy.sds.thrift.Datum;
import com.xiaomi.infra.galaxy.sds.thrift.ErrorCode;
import com.xiaomi.infra.galaxy.sds.thrift.ScanRequest;
import com.xiaomi.infra.galaxy.sds.thrift.ScanResult;
import com.xiaomi.infra.galaxy.sds.thrift.TableService;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class TableScanner
implements Iterable<Map<String, Datum>> {
    private final TableService.Iface tableClient;
    private final ScanRequest scan;

    public TableScanner(TableService.Iface tableClient, ScanRequest scan) {
        this.tableClient = tableClient;
        this.scan = scan;
    }

    @Override
    public Iterator<Map<String, Datum>> iterator() {
        return new RecordIterator(this.tableClient, this.scan.deepCopy());
    }

    class RecordIterator
    implements Iterator<Map<String, Datum>> {
        private final TableService.Iface tableClient;
        private final ScanRequest scan;
        private boolean finished = false;
        private int retry = 0;
        private static final int MAX_RETRY = 256;
        private Iterator<Map<String, Datum>> bufferIterator = null;
        private ScanResult lastResult = null;
        private ThreadLocal<Long> lastPauseTime = new ThreadLocal<Long>(){

            @Override
            public Long initialValue() {
                return 0L;
            }
        };

        public RecordIterator(TableService.Iface tableClient, ScanRequest scan) {
            this.tableClient = tableClient;
            this.scan = scan;
        }

        @Override
        public boolean hasNext() {
            long pauseTime;
            if (this.bufferIterator != null && this.bufferIterator.hasNext()) {
                return true;
            }
            if (this.finished) {
                return false;
            }
            if (this.retry > 0) {
                if (this.lastResult != null && this.lastResult.isThrottled()) {
                    pauseTime = ThrottleUtils.getPauseTime(ErrorCode.THROUGHPUT_EXCEED, this.retry);
                    ThrottleUtils.sleepPauseTime(pauseTime);
                    this.lastPauseTime.set(pauseTime < 0L ? 0L : pauseTime);
                }
            } else {
                assert (this.retry == 0);
                pauseTime = ThrottleUtils.getPauseTime(this.lastPauseTime.get());
                ThrottleUtils.sleepPauseTime(pauseTime);
                this.lastPauseTime.set(pauseTime < 0L ? 0L : pauseTime);
            }
            ScanResult result = null;
            try {
                result = this.tableClient.scan(this.scan);
            }
            catch (Throwable e) {
                throw new RuntimeException("Scan request " + this.scan + " failed", e);
            }
            if (result.getRecords() != null) {
                List buffer = result.getRecords();
                this.bufferIterator = buffer.iterator();
            }
            if (result.getNextStartKey() == null || result.getNextStartKey().isEmpty()) {
                this.finished = true;
            } else {
                if (result.getRecordsSize() < this.scan.getLimit() && result.isThrottled()) {
                    ++this.retry;
                    if (this.retry > 256) {
                        throw new RuntimeException("Scan request " + this.scan + " failed with " + this.retry + " retries");
                    }
                } else {
                    this.retry = 0;
                }
                this.lastResult = result;
                this.scan.setStartKey(result.getNextStartKey());
            }
            return this.hasNext();
        }

        @Override
        public Map<String, Datum> next() throws NoSuchElementException {
            if (this.hasNext()) {
                return this.bufferIterator.next();
            }
            throw new NoSuchElementException("Scanner reaches the end");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }
}

