/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.sds.client;

import com.xiaomi.infra.galaxy.sds.thrift.BatchRequest;
import com.xiaomi.infra.galaxy.sds.thrift.BatchRequestItem;
import com.xiaomi.infra.galaxy.sds.thrift.GetRequest;
import com.xiaomi.infra.galaxy.sds.thrift.IncrementRequest;
import com.xiaomi.infra.galaxy.sds.thrift.PutRequest;
import com.xiaomi.infra.galaxy.sds.thrift.RemoveRequest;
import com.xiaomi.infra.galaxy.sds.thrift.ScanRequest;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SdsRequestUtils {
    private static final Set<String> methods = new HashSet<String>();

    public static String getQuery(Method method, Object[] args) {
        if (methods.contains(method.getName()) && args.length == 1) {
            return SdsRequestUtils.getQuery(method.getName(), args[0]);
        }
        return new StringBuilder("type=".length() + method.getName().length()).append("type=").append(method.getName()).toString();
    }

    private static String getTableName(Object request) {
        if (request instanceof PutRequest) {
            return ((PutRequest)request).getTableName();
        }
        if (request instanceof IncrementRequest) {
            return ((IncrementRequest)request).getTableName();
        }
        if (request instanceof GetRequest) {
            return ((GetRequest)request).getTableName();
        }
        if (request instanceof RemoveRequest) {
            return ((RemoveRequest)request).getTableName();
        }
        if (request instanceof ScanRequest) {
            return ((ScanRequest)request).getTableName();
        }
        if (request instanceof BatchRequest) {
            BatchRequestItem batchRequestItem = (BatchRequestItem)((BatchRequest)request).getItems().get(0);
            switch (batchRequestItem.getAction()) {
                case PUT: {
                    return batchRequestItem.getRequest().getPutRequest().getTableName();
                }
                case GET: {
                    return batchRequestItem.getRequest().getGetRequest().getTableName();
                }
                case INCREMENT: {
                    return batchRequestItem.getRequest().getIncrementRequest().getTableName();
                }
                case REMOVE: {
                    return batchRequestItem.getRequest().getRemoveRequest().getTableName();
                }
            }
            throw new RuntimeException("Unknown batch action " + batchRequestItem.getAction());
        }
        throw new RuntimeException("Unknown request type " + request.getClass().toString());
    }

    private static String getQuery(String methodName, Object request) {
        return "type=" + methodName + "&name=" + SdsRequestUtils.getTableName(request);
    }

    static {
        methods.addAll(Arrays.asList("get", "put", "increment", "remove", "scan", "batch", "putToRebuildIndex"));
    }
}

