/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.rpc.client;

import com.xiaomi.infra.galaxy.rpc.thrift.ErrorCode;
import com.xiaomi.infra.galaxy.rpc.thrift.ErrorsConstants;
import java.util.Random;

public class ThrottleUtils {
    private static final Random RANDOM = new Random();
    public static int[] RETRY_BACKOFF = new int[]{1, 4, 8, 16, 32, 64};

    private static long getRandom(long normalPause) {
        long jitter = (long)((float)normalPause * RANDOM.nextFloat() * 0.1f);
        return normalPause + jitter;
    }

    private static long getBackoffTime(long pause, int tries) {
        int ntries = tries;
        if (ntries >= RETRY_BACKOFF.length) {
            ntries = RETRY_BACKOFF.length - 1;
        }
        long normalPause = pause * (long)RETRY_BACKOFF[ntries];
        return ThrottleUtils.getRandom(normalPause);
    }

    public static long getPauseTime(ErrorCode code, int retry) {
        Long time = (Long)ErrorsConstants.ERROR_BACKOFF.get(code);
        if (time == null) {
            return -1L;
        }
        return ThrottleUtils.getBackoffTime(time, retry);
    }

    public static long getPauseTime(long lastPauseTime) {
        if (lastPauseTime == 0L) {
            return 0L;
        }
        long pauseTime = lastPauseTime - ThrottleUtils.getRandom(Math.max((long)((double)lastPauseTime * 0.2), 200L));
        pauseTime = pauseTime < 0L ? 0L : pauseTime;
        return pauseTime;
    }

    public static void sleepPauseTime(long pauseTime) {
        if (pauseTime > 0L) {
            try {
                Thread.sleep(pauseTime);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("thread sleep failed", ie);
            }
        }
    }
}

