/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.rpc.client;

import com.xiaomi.infra.galaxy.rpc.client.GalaxyHttpClient;
import com.xiaomi.infra.galaxy.rpc.thrift.Credential;
import com.xiaomi.infra.galaxy.rpc.thrift.ThriftProtocol;
import com.xiaomi.infra.galaxy.rpc.util.clock.AdjustableClock;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import libthrift091.protocol.TCompactProtocol;
import libthrift091.protocol.TProtocol;
import libthrift091.transport.TTransport;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadSafeClient<IFace, Impl> {
    public static <IFace, Impl> IFace getClient(HttpClient client, Map<String, String> customHeaders, Credential credential, AdjustableClock clock, Class<IFace> ifaceClass, Class<Impl> implClass, String url, int socketTimeout, int connTimeout, boolean supportAccountKey) {
        return (IFace)Proxy.newProxyInstance(ThreadSafeClient.class.getClassLoader(), new Class[]{ifaceClass}, new ThreadSafeInvocationHandler(client, customHeaders, credential, clock, ifaceClass, implClass, url, socketTimeout, connTimeout, supportAccountKey));
    }

    private static class ThreadSafeInvocationHandler<IFace, Impl>
    implements InvocationHandler {
        private static final Logger LOG = LoggerFactory.getLogger(ThreadSafeInvocationHandler.class);
        private static final Map<Class, Constructor> ctorCache = new ConcurrentHashMap<Class, Constructor>();
        private final HttpClient client;
        private final Map<String, String> customHeaders;
        private final Credential credential;
        private final AdjustableClock clock;
        final Class<IFace> ifaceClass;
        final Class<Impl> implClass;
        final String url;
        private int socketTimeout = 0;
        private int connTimeout = 0;
        private boolean supportAccountKey = false;

        private ThreadSafeInvocationHandler(HttpClient client, Map<String, String> customHeaders, Credential credential, AdjustableClock clock, Class<IFace> ifaceClass, Class<Impl> implClass, String url, int socketTimeout, int connTimeout, boolean supportAccountKey) {
            this.client = client;
            this.customHeaders = customHeaders;
            this.credential = credential;
            this.clock = clock;
            this.ifaceClass = ifaceClass;
            this.implClass = implClass;
            this.url = url;
            this.socketTimeout = socketTimeout;
            this.connTimeout = connTimeout;
            this.supportAccountKey = supportAccountKey;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                GalaxyHttpClient galaxyHttpClient = new GalaxyHttpClient(this.url, this.client, this.credential, this.clock);
                galaxyHttpClient.setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connTimeout).setProtocol(ThriftProtocol.TCOMPACT).setQueryString("type=" + method.getName()).setSupportAccountKey(this.supportAccountKey);
                TCompactProtocol proto = new TCompactProtocol((TTransport)galaxyHttpClient);
                if (this.customHeaders != null) {
                    for (Map.Entry<String, String> header : this.customHeaders.entrySet()) {
                        galaxyHttpClient.setCustomHeader(header.getKey(), header.getValue());
                    }
                }
                Impl client = ThreadSafeInvocationHandler.getDeclaredConstructor(this.implClass).newInstance(proto);
                return method.invoke(client, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz) throws NoSuchMethodException {
            Constructor<T> ctor = ctorCache.get(clazz);
            if (ctor == null) {
                ctor = clazz.getDeclaredConstructor(TProtocol.class);
                ctorCache.put(clazz, ctor);
            }
            return ctor;
        }
    }
}

