/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.rpc.client;

import com.xiaomi.infra.galaxy.rpc.client.AutoRetryClient;
import com.xiaomi.infra.galaxy.rpc.client.ThreadSafeClient;
import com.xiaomi.infra.galaxy.rpc.thrift.Credential;
import com.xiaomi.infra.galaxy.rpc.thrift.Version;
import com.xiaomi.infra.galaxy.rpc.util.VersionUtil;
import com.xiaomi.infra.galaxy.rpc.util.clock.AdjustableClock;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BaseClientFactory.class);
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final Version VERSION = new Version();
    private Credential credential;
    private Map<String, String> customHeaders;
    private HttpClient httpClient;
    private AdjustableClock clock;

    private static HttpClient generateHttpClient() {
        BasicHttpParams params = new BasicHttpParams();
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)1);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)3000);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        SSLSocketFactory sslSocketFactory = SSLSocketFactory.getSocketFactory();
        sslSocketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        schemeRegistry.register(new Scheme("https", (SocketFactory)sslSocketFactory, 443));
        ThreadSafeClientConnManager conMgr = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        return new DefaultHttpClient((ClientConnectionManager)conMgr, (HttpParams)params);
    }

    public BaseClientFactory setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public BaseClientFactory() {
        this(new AdjustableClock());
    }

    public BaseClientFactory(Credential credential) {
        this(credential, new AdjustableClock());
    }

    public BaseClientFactory(AdjustableClock clock) {
        this(null, clock);
    }

    public BaseClientFactory(Credential credential, AdjustableClock clock) {
        this(credential, clock, BaseClientFactory.generateHttpClient());
    }

    public BaseClientFactory(Credential credential, HttpClient httpClient) {
        this(credential, new AdjustableClock(), httpClient);
    }

    public BaseClientFactory(Credential credential, AdjustableClock clock, HttpClient httpClient) {
        this.credential = credential;
        this.clock = clock;
        this.httpClient = httpClient;
    }

    public Version getSDKVersion() {
        return VERSION;
    }

    protected <IFace, Impl> IFace createClient(Class<IFace> ifaceClass, Class<Impl> implClass, String url, int socketTimeout, int connTimeout, boolean isRetry, int maxRetry, boolean supportAccountKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(USER_AGENT_HEADER, this.createUserAgentHeader());
        headers.put("X-Xiaomi-Request-Timeout", String.valueOf(socketTimeout));
        if (this.customHeaders != null) {
            headers.putAll(this.customHeaders);
        }
        IFace client = ThreadSafeClient.getClient(this.httpClient, headers, this.credential, this.clock, ifaceClass, implClass, url, socketTimeout, connTimeout, supportAccountKey);
        return AutoRetryClient.getAutoRetryClient(ifaceClass, client, isRetry, maxRetry);
    }

    protected String createUserAgentHeader() {
        return String.format("Java-SDK/%s Java/%s", VersionUtil.versionString((Version)VERSION), System.getProperty("java.version"));
    }
}

