/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.emr.client;

import com.xiaomi.infra.galaxy.emr.thrift.EMRAdminService;
import com.xiaomi.infra.galaxy.emr.thrift.EMRMasterService;
import com.xiaomi.infra.galaxy.emr.thrift.EMRSchedulerService;
import com.xiaomi.infra.galaxy.rpc.client.BaseClientFactory;
import com.xiaomi.infra.galaxy.rpc.thrift.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMRClientFactory
extends BaseClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(EMRClientFactory.class);

    public EMRClientFactory() {
    }

    public EMRClientFactory(Credential credential) {
        super(credential);
    }

    public EMRSchedulerService.Iface newEMRSchedulerService() {
        String url = "http://emr.api.xiaomi.com/v1/api";
        return this.newEMRSchedulerService(url);
    }

    public EMRSchedulerService.Iface newEMRSchedulerService(boolean supportAccountKey) {
        String url = "http://emr.api.xiaomi.com/v1/api";
        return this.newEMRSchedulerService(url, supportAccountKey);
    }

    public EMRSchedulerService.Iface newEMRSchedulerService(String url) {
        return this.newEMRSchedulerService(url, false);
    }

    public EMRSchedulerService.Iface newEMRSchedulerService(String url, boolean supportAccountKey) {
        return this.newEMRSchedulerService(url, 10000, 3000, supportAccountKey);
    }

    public EMRSchedulerService.Iface newEMRSchedulerService(String url, int socketTimeout, int connTimeout) {
        return this.newEMRSchedulerService(url, socketTimeout, connTimeout, false);
    }

    public EMRSchedulerService.Iface newEMRSchedulerService(String url, int socketTimeout, int connTimeout, boolean supportAccountKey) {
        return this.newEMRSchedulerService(url, socketTimeout, connTimeout, false, 1, supportAccountKey);
    }

    public EMRSchedulerService.Iface newEMRSchedulerService(String url, boolean isRetry, int maxRetry) {
        return this.newEMRSchedulerService(url, isRetry, maxRetry, false);
    }

    public EMRSchedulerService.Iface newEMRSchedulerService(String url, boolean isRetry, int maxRetry, boolean supportAccountKey) {
        return this.newEMRSchedulerService(url, 10000, 3000, isRetry, maxRetry, supportAccountKey);
    }

    public EMRSchedulerService.Iface newEMRSchedulerService(String url, int socketTimeout, int connTimeout, boolean isRetry, int maxRetry) {
        return this.newEMRSchedulerService(url, socketTimeout, connTimeout, isRetry, maxRetry, false);
    }

    public EMRSchedulerService.Iface newEMRSchedulerService(String url, int socketTimeout, int connTimeout, boolean isRetry, int maxRetry, boolean supportAccountKey) {
        return this.createClient(EMRSchedulerService.Iface.class, EMRSchedulerService.Client.class, url, socketTimeout, connTimeout, isRetry, maxRetry, supportAccountKey);
    }

    public EMRMasterService.Iface newEMRMasterService(String endpoint) {
        return this.newEMRMasterService(endpoint, false, 1);
    }

    public EMRMasterService.Iface newEMRMasterService(String endpoint, boolean isRetry, int maxRetry) {
        String url = endpoint + "/v1/api/master";
        return this.newEMRMasterService(url, 10000, 3000, isRetry, maxRetry, false);
    }

    public EMRMasterService.Iface newEMRMasterService(String url, int socketTimeout, int connTimeout, boolean isRetry, int maxRetry, boolean supportAccountKey) {
        return this.createClient(EMRMasterService.Iface.class, EMRMasterService.Client.class, url, socketTimeout, connTimeout, isRetry, maxRetry, supportAccountKey);
    }

    public EMRAdminService.Iface newEMRAdminService(String endpoint) {
        return this.newEMRAdminService(endpoint, false, 1);
    }

    public EMRAdminService.Iface newEMRAdminService(String endpoint, boolean isRetry, int maxRetry) {
        String url = endpoint + "/v1/api/metrics";
        return this.newEMRAdminService(url, 10000, 3000, isRetry, maxRetry, false);
    }

    private EMRAdminService.Iface newEMRAdminService(String url, int socketTimeout, int connTimeout, boolean isRetry, int maxRetry, boolean supportAccountKey) {
        return this.createClient(EMRAdminService.Iface.class, EMRAdminService.Client.class, url, socketTimeout, connTimeout, isRetry, maxRetry, supportAccountKey);
    }
}

