/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.client.io;

import com.xiaomi.infra.galaxy.api.io.ByteArrayRecordReader;
import com.xiaomi.infra.galaxy.api.io.ByteArrayRecordWriter;
import com.xiaomi.infra.galaxy.api.io.RecordReader;
import com.xiaomi.infra.galaxy.api.io.RecordWriter;
import com.xiaomi.infra.galaxy.client.io.SDSDatumMapRecordReader;
import com.xiaomi.infra.galaxy.client.io.SDSDatumMapRecordWriter;
import com.xiaomi.infra.galaxy.client.io.SDSRCBasicRecordReader;
import com.xiaomi.infra.galaxy.client.io.SDSRCBasicRecordWriter;
import com.xiaomi.infra.galaxy.io.thrift.Compression;
import com.xiaomi.infra.galaxy.io.thrift.RSFileHeader;
import com.xiaomi.infra.galaxy.sds.thrift.DataType;
import com.xiaomi.infra.galaxy.sds.thrift.Datum;
import com.xiaomi.infra.galaxy.sds.thrift.DatumMapMeta;
import com.xiaomi.infra.galaxy.sds.thrift.RCBasicMeta;
import com.xiaomi.infra.galaxy.sds.thrift.SLFileMeta;
import com.xiaomi.infra.galaxy.sds.thrift.SLFileType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import libthrift091.TBase;
import libthrift091.TDeserializer;
import libthrift091.TException;
import libthrift091.TSerializer;
import libthrift091.protocol.TCompactProtocol;
import libthrift091.protocol.TProtocolFactory;

public class SDSRecordReaderWriterFactory {
    public static RecordReader<Map<String, Datum>> getRecordReader(InputStream inputStream) throws IOException {
        ByteArrayRecordReader recordReader = new ByteArrayRecordReader(inputStream);
        RSFileHeader header = recordReader.readHeader();
        if (header.getMetadata() != null) {
            SLFileMeta metadata = new SLFileMeta();
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
            try {
                deserializer.deserialize((TBase)metadata, header.getMetadata());
            }
            catch (TException te) {
                throw new IOException("Failed to serialize header metadata", te);
            }
            switch (metadata.getType()) {
                case DATUM_MAP: {
                    return new SDSDatumMapRecordReader(recordReader, metadata.getDatumMapMeta());
                }
                case RC_BASIC: {
                    return new SDSRCBasicRecordReader(recordReader, metadata.getRcBasicMeta());
                }
            }
            throw new IllegalArgumentException("Unsupported file type: " + metadata.getType());
        }
        throw new IllegalArgumentException("Invalid file format, not sds metadata found");
    }

    public static RecordWriter<Map<String, Datum>> getDatumMapRecordWriter(OutputStream outputStream, Map<String, DataType> dataTypes, Compression compression) throws IOException {
        byte[] metaBytes;
        TSerializer serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
        HashMap<Short, String> keyIdMap = new HashMap<Short, String>();
        short i = 0;
        if (dataTypes != null) {
            for (String key : dataTypes.keySet()) {
                short s = i;
                i = (short)(i + 1);
                keyIdMap.put(s, key);
            }
        }
        SLFileMeta metadata = new SLFileMeta().setType(SLFileType.DATUM_MAP).setDatumMapMeta(new DatumMapMeta().setKeyIdMap(keyIdMap));
        try {
            metaBytes = serializer.serialize((TBase)metadata);
        }
        catch (TException te) {
            throw new IOException("Failed to serialize metadata", te);
        }
        RSFileHeader header = new RSFileHeader().setCompression(compression).setMetadata(metaBytes);
        ByteArrayRecordWriter recordWriter = new ByteArrayRecordWriter(outputStream, header);
        return new SDSDatumMapRecordWriter(recordWriter, metadata.getDatumMapMeta());
    }

    public static RecordWriter<Map<String, Datum>> getRCBasicRecordWriter(OutputStream outputStream, Map<String, DataType> dataTypes, int rowGroupSize, Compression compression) throws IOException {
        byte[] metaBytes;
        TSerializer serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
        ArrayList<String> keys = null;
        if (dataTypes != null) {
            keys = new ArrayList<String>();
            for (Map.Entry<String, DataType> entry : dataTypes.entrySet()) {
                keys.add(entry.getKey());
            }
        }
        SLFileMeta metadata = new SLFileMeta().setType(SLFileType.RC_BASIC).setRcBasicMeta(new RCBasicMeta().setKeys(keys).setTypes(dataTypes));
        try {
            metaBytes = serializer.serialize((TBase)metadata);
        }
        catch (TException te) {
            throw new IOException("Failed to serialize metadata", te);
        }
        RSFileHeader header = new RSFileHeader().setCompression(compression).setMetadata(metaBytes);
        ByteArrayRecordWriter recordWriter = new ByteArrayRecordWriter(outputStream, header);
        return new SDSRCBasicRecordWriter(recordWriter, metadata.getRcBasicMeta(), rowGroupSize);
    }

    public static RecordWriter<Map<String, Datum>> getRecordWriter(OutputStream outputStream, Map<String, DataType> dataTypes, SLFileType fileType, Compression compression) throws IOException {
        switch (fileType) {
            case DATUM_MAP: {
                return SDSRecordReaderWriterFactory.getDatumMapRecordWriter(outputStream, dataTypes, compression);
            }
            case RC_BASIC: {
                return SDSRecordReaderWriterFactory.getRCBasicRecordWriter(outputStream, dataTypes, 1000, compression);
            }
        }
        throw new IllegalArgumentException("Unsupported file type: " + fileType);
    }
}

