/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.client.io;

import com.xiaomi.infra.galaxy.api.io.ByteArrayRecordWriter;
import com.xiaomi.infra.galaxy.api.io.RecordWriter;
import com.xiaomi.infra.galaxy.sds.thrift.Datum;
import com.xiaomi.infra.galaxy.sds.thrift.RCBasicMeta;
import com.xiaomi.infra.galaxy.sds.thrift.RCBasicRowGroupHeader;
import com.xiaomi.infra.galaxy.sds.thrift.Value;
import com.xiaomi.infra.galaxy.sds.thrift.ValueList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import libthrift091.TBase;
import libthrift091.TException;
import libthrift091.TSerializer;
import libthrift091.protocol.TCompactProtocol;
import libthrift091.protocol.TProtocolFactory;

class SDSRCBasicRecordWriter
implements RecordWriter<Map<String, Datum>> {
    private ByteArrayRecordWriter writer;
    private List<String> keys;
    private List<Map<String, Datum>> groupBuffer;
    private int groupSize;

    public SDSRCBasicRecordWriter(ByteArrayRecordWriter writer, RCBasicMeta meta, int groupSize) {
        this.writer = writer;
        this.keys = meta.getKeys();
        this.groupSize = groupSize;
        this.groupBuffer = new ArrayList<Map<String, Datum>>(groupSize);
        if (this.keys == null || this.keys.isEmpty()) {
            throw new UnsupportedOperationException("Table schema must be defined before write");
        }
    }

    public void append(Map<String, Datum> record) throws IOException {
        if (this.groupBuffer.size() == this.groupSize) {
            this.flush();
        }
        this.groupBuffer.add(record);
    }

    public void seal() throws IOException {
        this.flush();
        this.writer.seal();
    }

    private void flush() throws IOException {
        if (!this.groupBuffer.isEmpty()) {
            TSerializer serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
            int numKeys = this.keys.size();
            ArrayList<Integer> offsets = new ArrayList<Integer>(numKeys);
            ArrayList<byte[]> buffers = new ArrayList<byte[]>(numKeys);
            int offset = 0;
            for (String key : this.keys) {
                byte[] bytes;
                ArrayList<Value> values = new ArrayList<Value>();
                for (Map<String, Datum> row : this.groupBuffer) {
                    Datum datum = row.get(key);
                    Value value = datum == null ? Value.nullValue((boolean)true) : datum.getValue();
                    values.add(value);
                }
                try {
                    bytes = serializer.serialize((TBase)new ValueList().setValues(values));
                }
                catch (TException te) {
                    throw new IOException("Failed to serialize column: " + key, te);
                }
                offsets.add(offset);
                offset += bytes.length;
                buffers.add(bytes);
            }
            RCBasicRowGroupHeader groupHeader = new RCBasicRowGroupHeader().setCount(this.groupBuffer.size()).setOffset(offsets);
            try {
                this.writer.append(serializer.serialize((TBase)groupHeader));
            }
            catch (TException te) {
                throw new IOException("Failed to serialize row group header", te);
            }
            for (byte[] bytes : buffers) {
                this.writer.append(bytes);
            }
            this.groupBuffer.clear();
        }
    }

    public void close() throws IOException {
        this.seal();
        this.writer.close();
    }
}

