/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.client.io;

import com.xiaomi.infra.galaxy.api.io.ByteArrayRecordReader;
import com.xiaomi.infra.galaxy.api.io.RecordReader;
import com.xiaomi.infra.galaxy.io.thrift.RSFileHeader;
import com.xiaomi.infra.galaxy.sds.thrift.DataType;
import com.xiaomi.infra.galaxy.sds.thrift.Datum;
import com.xiaomi.infra.galaxy.sds.thrift.RCBasicMeta;
import com.xiaomi.infra.galaxy.sds.thrift.RCBasicRowGroupHeader;
import com.xiaomi.infra.galaxy.sds.thrift.Value;
import com.xiaomi.infra.galaxy.sds.thrift.ValueList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import libthrift091.TBase;
import libthrift091.TDeserializer;
import libthrift091.TException;
import libthrift091.protocol.TCompactProtocol;
import libthrift091.protocol.TProtocolFactory;

class SDSRCBasicRecordReader
implements RecordReader<Map<String, Datum>> {
    private ByteArrayRecordReader reader;
    private RCBasicMeta meta;
    private Iterator<Map<String, Datum>> groupBufferIterator;

    public SDSRCBasicRecordReader(ByteArrayRecordReader reader, RCBasicMeta meta) {
        this.reader = reader;
        this.meta = meta;
    }

    public RSFileHeader readHeader() throws IOException {
        throw new UnsupportedOperationException("The header must be already read");
    }

    public boolean hasNext() throws IOException {
        if (this.groupBufferIterator != null && this.groupBufferIterator.hasNext()) {
            return true;
        }
        return this.reader.hasNext();
    }

    public Map<String, Datum> next() throws IOException {
        if (this.groupBufferIterator == null || !this.groupBufferIterator.hasNext()) {
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
            byte[] headerBytes = this.reader.next();
            RCBasicRowGroupHeader groupHeader = new RCBasicRowGroupHeader();
            try {
                deserializer.deserialize((TBase)groupHeader, headerBytes);
            }
            catch (TException te) {
                throw new IOException("Failed to parse row group header", te);
            }
            int numKeys = this.meta.getKeys().size();
            List keys = this.meta.getKeys();
            Map dataTypes = this.meta.getTypes();
            ArrayList groupBuffer = new ArrayList(groupHeader.getCount());
            for (int i = 0; i < groupHeader.getCount(); ++i) {
                groupBuffer.add(new HashMap());
            }
            for (int kid = 0; kid < numKeys; ++kid) {
                String key = (String)keys.get(kid);
                byte[] bytes = this.reader.next();
                ValueList columnList = new ValueList();
                try {
                    deserializer.deserialize((TBase)columnList, bytes);
                }
                catch (TException te) {
                    throw new IOException("Failed to parse column: " + key, te);
                }
                assert (columnList.getValuesSize() == groupHeader.getCount());
                DataType dataType = (DataType)dataTypes.get(key);
                for (int i = 0; i < columnList.getValuesSize(); ++i) {
                    Value value = (Value)columnList.getValues().get(i);
                    if (value.isSetNullValue() && value.getNullValue()) continue;
                    ((Map)groupBuffer.get(i)).put(key, new Datum().setValue(value).setType(dataType));
                }
            }
            this.groupBufferIterator = groupBuffer.iterator();
        }
        return this.groupBufferIterator.next();
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

