/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.client.io;

import com.xiaomi.infra.galaxy.api.io.ByteArrayRecordWriter;
import com.xiaomi.infra.galaxy.api.io.RecordWriter;
import com.xiaomi.infra.galaxy.sds.thrift.Datum;
import com.xiaomi.infra.galaxy.sds.thrift.DatumMapMeta;
import com.xiaomi.infra.galaxy.sds.thrift.DatumMapRecord;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import libthrift091.TBase;
import libthrift091.TException;
import libthrift091.TSerializer;
import libthrift091.protocol.TCompactProtocol;
import libthrift091.protocol.TProtocolFactory;

class SDSDatumMapRecordWriter
implements RecordWriter<Map<String, Datum>> {
    private ByteArrayRecordWriter writer;
    private Map<String, Short> keyIdLookupTable = new HashMap<String, Short>();
    private TSerializer serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());

    SDSDatumMapRecordWriter(ByteArrayRecordWriter writer, DatumMapMeta metadata) {
        this.writer = writer;
        if (metadata.getKeyIdMap() != null) {
            for (Map.Entry entry : metadata.getKeyIdMap().entrySet()) {
                this.keyIdLookupTable.put((String)entry.getValue(), (Short)entry.getKey());
            }
        }
    }

    public void append(Map<String, Datum> record) throws IOException {
        byte[] bytes;
        HashMap<Short, Datum> rec = new HashMap<Short, Datum>();
        boolean containsAll = true;
        short maxKeyId = -1;
        for (Map.Entry<String, Datum> e : record.entrySet()) {
            Short keyId = this.keyIdLookupTable.get(e.getKey());
            if (keyId == null) {
                containsAll = false;
                continue;
            }
            if (maxKeyId < keyId) {
                maxKeyId = keyId;
            }
            rec.put(keyId, e.getValue());
        }
        DatumMapRecord dmr = new DatumMapRecord();
        if (!containsAll) {
            HashMap<Short, String> newKeyIdMap = new HashMap<Short, String>();
            for (Map.Entry<String, Datum> e : record.entrySet()) {
                Short keyId = this.keyIdLookupTable.get(e.getKey());
                if (keyId != null) continue;
                maxKeyId = (short)(maxKeyId + 1);
                keyId = maxKeyId;
                newKeyIdMap.put(keyId, e.getKey());
                rec.put(keyId, e.getValue());
            }
            dmr.setKeyIdMap(newKeyIdMap);
        }
        try {
            bytes = this.serializer.serialize((TBase)dmr.setData(rec));
        }
        catch (TException te) {
            throw new IOException("Failed to serialize record", te);
        }
        this.writer.append(bytes);
    }

    public void seal() throws IOException {
        this.writer.seal();
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

