/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.client.io;

import com.xiaomi.infra.galaxy.api.io.ByteArrayRecordReader;
import com.xiaomi.infra.galaxy.api.io.RecordReader;
import com.xiaomi.infra.galaxy.io.thrift.RSFileHeader;
import com.xiaomi.infra.galaxy.sds.thrift.Datum;
import com.xiaomi.infra.galaxy.sds.thrift.DatumMapMeta;
import com.xiaomi.infra.galaxy.sds.thrift.DatumMapRecord;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import libthrift091.TBase;
import libthrift091.TDeserializer;
import libthrift091.TException;
import libthrift091.protocol.TCompactProtocol;
import libthrift091.protocol.TProtocolFactory;

class SDSDatumMapRecordReader
implements RecordReader<Map<String, Datum>> {
    private ByteArrayRecordReader reader;
    private Map<Short, String> keyIdMap = new HashMap<Short, String>();

    SDSDatumMapRecordReader(ByteArrayRecordReader reader, DatumMapMeta meta) {
        this.reader = reader;
        if (meta != null && meta.getKeyIdMap() != null) {
            this.keyIdMap.putAll(meta.getKeyIdMap());
        }
    }

    public RSFileHeader readHeader() throws IOException {
        throw new UnsupportedOperationException("The header must be already read");
    }

    public boolean hasNext() throws IOException {
        return this.reader.hasNext();
    }

    public Map<String, Datum> next() throws IOException {
        byte[] bytes = this.reader.next();
        TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
        DatumMapRecord dmr = new DatumMapRecord();
        try {
            deserializer.deserialize((TBase)dmr, bytes);
        }
        catch (TException te) {
            throw new IOException("Failed to parse record", te);
        }
        if (dmr.isSetKeyIdMap()) {
            this.keyIdMap.putAll(dmr.getKeyIdMap());
        }
        HashMap<String, Datum> record = new HashMap<String, Datum>();
        for (Map.Entry entry : dmr.getData().entrySet()) {
            String key = this.keyIdMap.get(entry.getKey());
            if (key == null) {
                throw new IllegalArgumentException("Illegal file, unknown key id: " + entry.getKey());
            }
            record.put(key, (Datum)entry.getValue());
        }
        return record;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

