/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.client.authentication.signature;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.xiaomi.infra.galaxy.client.authentication.HttpMethod;
import com.xiaomi.infra.galaxy.client.authentication.signature.SignAlgorithm;
import com.xiaomi.infra.galaxy.client.authentication.signature.SubResource;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Signer {
    private static final Set<String> SUB_RESOURCE_SET = new HashSet<String>();
    private static final String XIAOMI_DATE = "x-xiaomi-date";

    public static byte[] sign(HttpMethod httpMethod, URI uri, LinkedListMultimap<String, String> httpHeaders, String secretAccessKeyId, SignAlgorithm algorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        Preconditions.checkNotNull((Object)((Object)httpMethod), (Object)"Http method");
        Preconditions.checkNotNull((Object)uri, (Object)"uri");
        Preconditions.checkNotNull((Object)secretAccessKeyId, (Object)"secret access key");
        Preconditions.checkNotNull((Object)((Object)algorithm), (Object)"algorithm");
        String stringToSign = Signer.constructStringToSign(httpMethod, uri, httpHeaders);
        Mac mac = Mac.getInstance(algorithm.name());
        mac.init(new SecretKeySpec(secretAccessKeyId.getBytes(), algorithm.name()));
        return mac.doFinal(stringToSign.getBytes());
    }

    public static String signToBase64(HttpMethod httpMethod, URI uri, LinkedListMultimap<String, String> httpHeaders, String secretAccessKeyId, SignAlgorithm algorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        return Base64.encode(Signer.sign(httpMethod, uri, httpHeaders, secretAccessKeyId, algorithm));
    }

    public static String getAuthorizationHeader(HttpMethod httpMethod, URI uri, LinkedListMultimap<String, String> httpHeaders, String accessKeyId, String secretAccessKeyId, SignAlgorithm algorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        String signature = Signer.signToBase64(httpMethod, uri, httpHeaders, secretAccessKeyId, algorithm);
        return "Galaxy-V2 " + accessKeyId + ":" + signature;
    }

    private static LinkedListMultimap<String, String> parseUriParameters(URI uri) {
        LinkedListMultimap params = LinkedListMultimap.create();
        String query = uri.getQuery();
        if (query != null) {
            for (String param : query.split("&")) {
                String[] kv = param.split("=");
                if (kv.length >= 2) {
                    params.put((Object)kv[0], (Object)param.substring(kv[0].length() + 1));
                    continue;
                }
                params.put((Object)kv[0], (Object)"");
            }
        }
        return params;
    }

    static String constructStringToSign(HttpMethod httpMethod, URI uri, LinkedListMultimap<String, String> httpHeaders) {
        StringBuilder builder = new StringBuilder();
        builder.append(httpMethod.name()).append("\n");
        builder.append(Signer.checkAndGet(httpHeaders, "content-md5").get(0)).append("\n");
        builder.append(Signer.checkAndGet(httpHeaders, "content-type").get(0)).append("\n");
        long expires = Signer.getExpires(uri);
        if (expires > 0L) {
            builder.append(expires).append("\n");
        } else {
            String xiaomiDate = Signer.checkAndGet(httpHeaders, XIAOMI_DATE).get(0);
            String date = "";
            if ("".equals(xiaomiDate)) {
                date = Signer.checkAndGet(httpHeaders, "date").get(0);
            }
            builder.append(Signer.checkAndGet(date)).append("\n");
        }
        builder.append(Signer.canonicalizeXiaomiHeaders(httpHeaders));
        builder.append(Signer.canonicalizeResource(uri));
        return builder.toString();
    }

    static String canonicalizeXiaomiHeaders(LinkedListMultimap<String, String> headers) {
        if (headers == null) {
            return "";
        }
        TreeMap<String, String> sortedHeaders = new TreeMap<String, String>();
        for (String key : headers.keySet()) {
            if (!key.toLowerCase().startsWith("x-xiaomi-")) continue;
            StringBuilder builder = new StringBuilder();
            int index = 0;
            for (String value : headers.get((Object)key)) {
                if (index != 0) {
                    builder.append(",");
                }
                builder.append(value);
                ++index;
            }
            sortedHeaders.put(key, builder.toString());
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : sortedHeaders.entrySet()) {
            result.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("\n");
        }
        return result.toString();
    }

    static String canonicalizeResource(URI uri) {
        StringBuilder result = new StringBuilder();
        result.append(uri.getPath());
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        LinkedListMultimap<String, String> params = Signer.parseUriParameters(uri);
        for (String key : params.keySet()) {
            for (String value : params.get((Object)key)) {
                if (!SUB_RESOURCE_SET.contains(key)) continue;
                sortedParams.put(key, value);
            }
        }
        if (!sortedParams.isEmpty()) {
            result.append("?");
            boolean isFirst = true;
            for (Map.Entry entry : sortedParams.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                    result.append((String)entry.getKey());
                } else {
                    result.append("&").append((String)entry.getKey());
                }
                if (((String)entry.getValue()).isEmpty()) continue;
                result.append("=").append((String)entry.getValue());
            }
        }
        return result.toString();
    }

    static String checkAndGet(String name) {
        return name == null ? "" : name;
    }

    static List<String> checkAndGet(LinkedListMultimap<String, String> headers, String header) {
        LinkedList<String> result = new LinkedList<String>();
        if (headers == null) {
            result.add("");
            return result;
        }
        List values = headers.get((Object)header);
        if (values == null || values.isEmpty()) {
            result.add("");
            return result;
        }
        return values;
    }

    static long getExpires(URI uri) {
        LinkedListMultimap<String, String> params = Signer.parseUriParameters(uri);
        List expires = params.get((Object)"Expires");
        if (expires != null && !expires.isEmpty()) {
            return Long.parseLong((String)expires.get(0));
        }
        return 0L;
    }

    static {
        for (SubResource r : SubResource.values()) {
            SUB_RESOURCE_SET.add(r.getName());
        }
    }
}

