/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.client.authentication.signature;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.xiaomi.infra.galaxy.client.authentication.HttpUtils;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SignatureUtil {
    private static final Log LOG = LogFactory.getLog(SignatureUtil.class);

    public static boolean isPreSignedUri(URI uri) {
        LinkedListMultimap<String, String> params;
        Preconditions.checkNotNull((Object)uri);
        String query = uri.getQuery();
        return query != null && (params = HttpUtils.parseUriParameters(uri)).containsKey((Object)"GalaxyAccessKeyId") && params.containsKey((Object)"Expires") && params.containsKey((Object)"Signature");
    }

    public static String getAccessKeyId(URI uri) {
        LinkedListMultimap<String, String> params;
        List keyIds;
        Preconditions.checkNotNull((Object)uri);
        String query = uri.getQuery();
        if (query != null && !(keyIds = (params = HttpUtils.parseUriParameters(uri)).get((Object)"GalaxyAccessKeyId")).isEmpty()) {
            return (String)params.get((Object)"GalaxyAccessKeyId").get(0);
        }
        return null;
    }

    public static String getAccessKeyId(String authorizationValue) {
        Preconditions.checkNotNull((Object)authorizationValue);
        String[] tokens = authorizationValue.split(" ");
        if (tokens.length == 2 && (tokens = tokens[1].split(":")).length == 2) {
            return tokens[0].trim();
        }
        return null;
    }

    public static String getSignature(URI uri) {
        LinkedListMultimap<String, String> params;
        List signatures;
        Preconditions.checkNotNull((Object)uri);
        String query = uri.getQuery();
        if (query != null && !(signatures = (params = HttpUtils.parseUriParameters(uri)).get((Object)"Signature")).isEmpty()) {
            return (String)params.get((Object)"Signature").get(0);
        }
        return null;
    }

    public static String getSignature(String authorizationValue) {
        Preconditions.checkNotNull((Object)authorizationValue);
        String[] tokens = authorizationValue.split(" ");
        if (tokens.length == 2 && (tokens = tokens[1].split(":")).length == 2) {
            return tokens[1].trim();
        }
        return null;
    }

    public static long getDateTime(LinkedListMultimap<String, String> headers) {
        List dateList = headers.get((Object)"x-xiaomi-date");
        if (dateList.isEmpty()) {
            dateList = headers.get((Object)"date");
        }
        if (!dateList.isEmpty()) {
            String datetime = (String)dateList.get(0);
            return HttpUtils.parseDateTimeToMilliseconds(datetime);
        }
        return 0L;
    }

    public static long getExpireTime(URI uri) {
        LinkedListMultimap<String, String> params = HttpUtils.parseUriParameters(uri);
        List expireList = params.get((Object)"Expires");
        if (!expireList.isEmpty()) {
            return Long.parseLong((String)expireList.get(0));
        }
        return 0L;
    }

    public static boolean checkExpireTime(URI uri) {
        long expireTime = SignatureUtil.getExpireTime(uri);
        if (expireTime > 0L) {
            return expireTime >= System.currentTimeMillis();
        }
        return false;
    }

    public static boolean checkDateTime(LinkedListMultimap<String, String> headers) {
        long timestamp = SignatureUtil.getDateTime(headers);
        if (timestamp > 0L) {
            long currentTime = System.currentTimeMillis();
            if (timestamp + 900000L >= currentTime) {
                return true;
            }
            LOG.warn((Object)("Request time is too skewed, requestTime=" + timestamp + ", currentTime=" + currentTime + ", skewed=" + (currentTime - timestamp)));
        } else {
            LOG.warn((Object)"Request time is not specified");
        }
        return false;
    }
}

