/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.client.authentication;

import java.util.HashMap;
import java.util.Map;

public class SessionInfo {
    private String userId;
    private String developerId;
    private String appId;
    private String accessKeyId;
    private String secretAccessKeyId;
    private UserType userType;
    private AuthType authType;
    private String requestId;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    private SessionInfo() {
    }

    public String getUserId() {
        return this.userId;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getSecretAccessKeyId() {
        return this.secretAccessKeyId;
    }

    public void setSecretAccessKeyId(String secretAccessKeyId) {
        this.secretAccessKeyId = secretAccessKeyId;
    }

    public String getDeveloperId() {
        return this.developerId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public String toString() {
        return "SessionInfo{userId='" + this.userId + '\'' + ", developerId='" + this.developerId + '\'' + ", appId='" + this.appId + '\'' + ", accessKeyId='" + this.accessKeyId + '\'' + ", secretAccessKeyId='" + this.secretAccessKeyId + '\'' + ", userType=" + (Object)((Object)this.userType) + ", authType=" + (Object)((Object)this.authType) + ", requestId='" + this.requestId + '\'' + ", properties=" + this.properties + '}';
    }

    public static class Builder {
        private String userId;
        private String developerId;
        private String appId;
        private String accessKeyId;
        private String secretAccessKeyId;
        private UserType userType;
        private AuthType authType;
        private String requestId;

        public Builder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder withDeveloperId(String developerId) {
            this.developerId = developerId;
            return this;
        }

        public Builder withAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder withAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder withSecretAccessKeyId(String secretAccessKeyId) {
            this.secretAccessKeyId = secretAccessKeyId;
            return this;
        }

        public Builder withUserType(UserType userType) {
            this.userType = userType;
            return this;
        }

        public Builder withAuthType(AuthType authType) {
            this.authType = authType;
            return this;
        }

        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public SessionInfo build() {
            SessionInfo sessionInfo = new SessionInfo();
            sessionInfo.userId = this.userId;
            sessionInfo.developerId = this.developerId;
            sessionInfo.appId = this.appId;
            sessionInfo.accessKeyId = this.accessKeyId;
            sessionInfo.secretAccessKeyId = this.secretAccessKeyId;
            sessionInfo.userType = this.userType;
            sessionInfo.authType = this.authType;
            sessionInfo.requestId = this.requestId;
            return sessionInfo;
        }
    }

    public static enum AuthType {
        DEVELOPER,
        APPLICATION,
        APPROOT;

    }

    public static enum UserType {
        GUEST,
        LOGIN_USER,
        ADMIN;

    }
}

