/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.infra.galaxy.client.authentication;

import com.google.common.collect.LinkedListMultimap;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class HttpUtils {
    private static final ThreadLocal<SimpleDateFormat> RFC_822_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> RFC_850_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss z", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };
    private static final ThreadLocal<SimpleDateFormat> ANSI_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };

    public static LinkedListMultimap<String, String> parseUriParameters(URI uri) {
        LinkedListMultimap params = LinkedListMultimap.create();
        String query = uri.getQuery();
        if (query != null) {
            for (String param : query.split("&")) {
                String[] kv = param.split("=");
                if (kv.length >= 2) {
                    params.put((Object)kv[0], (Object)param.substring(kv[0].length() + 1));
                    continue;
                }
                params.put((Object)kv[0], (Object)"");
            }
        }
        return params;
    }

    public static String getSingleHeader(String header, LinkedListMultimap<String, String> headers) {
        List values = headers.get((Object)header);
        if (values == null) {
            values = headers.get((Object)header.toLowerCase());
        }
        if (values != null && !values.isEmpty()) {
            return (String)values.get(0);
        }
        return null;
    }

    public static String getSingleParam(String name, URI uri) {
        LinkedListMultimap<String, String> params = HttpUtils.parseUriParameters(uri);
        if (params != null && !params.isEmpty()) {
            List values = params.get((Object)name);
            if (values == null) {
                values = params.get((Object)name.toLowerCase());
            }
            if (values != null & !values.isEmpty()) {
                return (String)values.get(0);
            }
        }
        return null;
    }

    public static Date parseDateTimeFromString(String datetime) {
        Date date = HttpUtils.tryToParse(datetime, RFC_822_DATE_FORMAT.get());
        if (date == null) {
            date = HttpUtils.tryToParse(datetime, RFC_850_DATE_FORMAT.get());
        }
        if (date == null) {
            date = HttpUtils.tryToParse(datetime, ANSI_DATE_FORMAT.get());
        }
        return date;
    }

    public static long parseDateTimeToMilliseconds(String datetime) {
        Date date = HttpUtils.parseDateTimeFromString(datetime);
        if (date != null) {
            return date.getTime();
        }
        return 0L;
    }

    public static String getGMTDatetime(Date datetime) {
        return RFC_822_DATE_FORMAT.get().format(datetime);
    }

    private static Date tryToParse(String datetime, SimpleDateFormat format) {
        try {
            return format.parse(datetime);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

