/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.captcha;

import com.xiaoleilu.hutool.captcha.ICaptcha;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.io.IORuntimeException;
import com.xiaoleilu.hutool.util.ImageUtil;
import com.xiaoleilu.hutool.util.RandomUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.concurrent.ThreadLocalRandom;

public class LineCaptcha
implements ICaptcha {
    private static final long serialVersionUID = 8691294460763091089L;
    private int width = 100;
    private int height = 37;
    private int codeCount = 4;
    private int lineCount = 150;
    private Font font;
    private int charWidth;
    private int charY;
    private String code;
    private BufferedImage image;

    public LineCaptcha(int width, int height) {
        this(width, height, 4, 150);
    }

    public LineCaptcha(int width, int height, int codeCount, int lineCount) {
        this.width = width;
        this.height = height;
        this.codeCount = codeCount;
        this.lineCount = lineCount;
        this.charWidth = width / (codeCount + 2);
        this.charY = height - 4;
        this.font = new Font("Arial", 0, this.height - 2);
    }

    @Override
    public void createCode() {
        this.image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = this.image.createGraphics();
        ThreadLocalRandom random = RandomUtil.getRandom();
        g.setColor(ImageUtil.randomColor(random));
        g.fillRect(0, 0, this.width, this.height);
        g.setFont(this.font);
        this.drawRandomLines(g, random);
        StringBuffer randomCode = new StringBuffer();
        for (int i = 0; i < this.codeCount; ++i) {
            String randomCharStr = RandomUtil.randomString(1);
            g.setColor(ImageUtil.randomColor(random));
            g.drawString(randomCharStr, (i + 1) * this.charWidth, this.charY);
            randomCode.append(randomCharStr);
        }
        this.code = randomCode.toString();
    }

    public void write(String path) throws IORuntimeException {
        this.write(FileUtil.getOutputStream(path));
    }

    public void write(File file) throws IORuntimeException {
        this.write(FileUtil.getOutputStream(file));
    }

    @Override
    public void write(OutputStream out) throws IORuntimeException {
        ImageUtil.write((Image)this.getImage(), "png", out);
    }

    public BufferedImage getImage() {
        if (null == this.image) {
            this.createCode();
        }
        return this.image;
    }

    @Override
    public String getCode() {
        if (null == this.code) {
            this.createCode();
        }
        return this.code;
    }

    @Override
    public boolean verify(String userInputCode) {
        if (StrUtil.isNotBlank(userInputCode)) {
            return StrUtil.equalsIgnoreCase(this.getCode(), userInputCode);
        }
        return false;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    private void drawRandomLines(Graphics2D g, ThreadLocalRandom random) {
        for (int i = 0; i < this.lineCount; ++i) {
            int xs = random.nextInt(this.width);
            int ys = random.nextInt(this.height);
            int xe = xs + random.nextInt(this.width / 8);
            int ye = ys + random.nextInt(this.height / 8);
            g.setColor(ImageUtil.randomColor(random));
            g.drawLine(xs, ys, xe, ye);
        }
    }
}

