/*
 * Decompiled with CFR 0.152.
 */
package com.webguys.maven.plugin.st;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.stringtemplate.v4.ST;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class Controller {
    private String className;
    private String method;
    private Map<String, String> properties;
    private boolean compile = true;
    private String sourceVersion = "1.6";
    private String targetVersion = "1.6";
    private String compilerVersion = "3.0";
    private Object controllerInstance = null;

    public void invoke(ST st, MojoExecutor.ExecutionEnvironment executionEnvironment, ProjectDependenciesResolver dependenciesResolver, Log log) throws MojoExecutionException {
        try {
            Class controllerClass = this.findControllerClass(dependenciesResolver, executionEnvironment, log);
            Method method = this.getMethod(controllerClass);
            this.applyProperties(controllerClass, this.properties, log);
            Object results = this.invoke(controllerClass, method, log, new Object[0]);
            this.applyResults(st, results);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Unable to invoke controller: %s (%s)", this.className, e.getMessage()), e);
        }
    }

    private Class findControllerClass(ProjectDependenciesResolver dependenciesResolver, MojoExecutor.ExecutionEnvironment executionEnvironment, Log log) throws MojoExecutionException, ClassNotFoundException, MalformedURLException, ArtifactResolutionException, ArtifactNotFoundException {
        try {
            return this.loadController(executionEnvironment.getMavenProject(), executionEnvironment.getMavenSession(), dependenciesResolver);
        }
        catch (ClassNotFoundException e) {
            if (this.compile) {
                log.info((CharSequence)String.format("Unable to find the class: %s.  Attempting to compile it...", this.className));
                return this.compileAndLoadController(log, dependenciesResolver, executionEnvironment);
            }
            throw new MojoExecutionException(String.format("The class %s is not in the classpath, and compilation is not enabled.", this.className), (Exception)e);
        }
    }

    private Class compileAndLoadController(Log log, ProjectDependenciesResolver dependenciesResolver, MojoExecutor.ExecutionEnvironment executionEnvironment) throws MojoExecutionException, ClassNotFoundException, MalformedURLException, ArtifactResolutionException, ArtifactNotFoundException {
        MavenProject project = executionEnvironment.getMavenProject();
        Set<Artifact> originalArtifacts = this.configureArtifacts(project);
        this.executeCompilerPlugin(executionEnvironment, log);
        Class result = this.loadController(project, executionEnvironment.getMavenSession(), dependenciesResolver);
        project.setArtifacts(originalArtifacts);
        return result;
    }

    private Set<Artifact> configureArtifacts(MavenProject project) {
        Set originalArtifacts = project.getArtifacts();
        project.setArtifacts(project.getDependencyArtifacts());
        return originalArtifacts;
    }

    private void executeCompilerPlugin(MojoExecutor.ExecutionEnvironment executionEnvironment, Log log) throws MojoExecutionException {
        String path = this.className.replace(".", File.separator) + ".java";
        log.info((CharSequence)String.format("Compiling %s...", path));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-compiler-plugin"), (String)MojoExecutor.version((String)this.compilerVersion)), (String)MojoExecutor.goal((String)"compile"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"source"), (String)this.sourceVersion), MojoExecutor.element((String)MojoExecutor.name((String)"target"), (String)this.targetVersion), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"include", (String)path)})}), (MojoExecutor.ExecutionEnvironment)executionEnvironment);
    }

    private Class loadController(MavenProject project, MavenSession session, ProjectDependenciesResolver dependenciesResolver) throws MalformedURLException, ClassNotFoundException, ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList<String> scopes = new ArrayList<String>(1);
        scopes.add("runtime");
        Set artifacts = dependenciesResolver.resolve(project, scopes, session);
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new File(project.getBuild().getOutputDirectory()).getAbsoluteFile().toURI().toURL());
        for (Artifact artifact : artifacts) {
            urls.add(artifact.getFile().getAbsoluteFile().toURI().toURL());
        }
        URLClassLoader loader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
        return loader.loadClass(this.className);
    }

    private Method getMethod(Class controllerClass) throws NoSuchMethodException, MojoExecutionException {
        Method method = controllerClass.getMethod(this.method, new Class[0]);
        if (!method.getReturnType().isAssignableFrom(Map.class)) {
            throw new MojoExecutionException(String.format("The return type of the method %s was not of type Map<String, Object>", this.method));
        }
        return method;
    }

    private void applyProperties(Class controllerClass, Map<String, String> properties, Log log) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (null == properties || properties.isEmpty()) {
            return;
        }
        Method setProperties = null;
        try {
            setProperties = controllerClass.getMethod("setProperties", Map.class);
        }
        catch (NoSuchMethodException ignored) {
            // empty catch block
        }
        if (null != setProperties) {
            this.invoke(controllerClass, setProperties, log, properties);
        }
    }

    private Object invoke(Class controllerClass, Method method, Log log, Object ... args) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object controller = null;
        if (!Modifier.isStatic(method.getModifiers())) {
            if (null == this.controllerInstance) {
                this.controllerInstance = controllerClass.newInstance();
            }
            controller = this.controllerInstance;
        }
        log.info((CharSequence)String.format("Invoking controller method: %s.%s()", controllerClass.getName(), method.getName()));
        return method.invoke(controller, args);
    }

    private void applyResults(ST st, Object result) throws MojoExecutionException {
        if (null == result) {
            throw new MojoExecutionException(String.format("The result invoking %s.%s was null.", this.className, this.method));
        }
        Map attributes = (Map)result;
        for (Map.Entry entry : attributes.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof String)) {
                String msg = String.format("A non-String key of type %s was found in the %s.%s results.", key.getClass().getName(), this.className, this.method);
                throw new MojoExecutionException(msg);
            }
            st.add((String)key, entry.getValue());
        }
    }
}

