/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.standard.app.development.utils;

import com.webank.wedatasphere.dss.common.utils.DSSExceptionUtils;
import com.webank.wedatasphere.dss.standard.app.development.operation.DevelopmentOperation;
import com.webank.wedatasphere.dss.standard.app.development.ref.DSSContextRequestRef;
import com.webank.wedatasphere.dss.standard.app.development.ref.DSSJobContentRequestRef;
import com.webank.wedatasphere.dss.standard.app.development.ref.DevelopmentRequestRef;
import com.webank.wedatasphere.dss.standard.app.development.ref.ProjectRefRequestRef;
import com.webank.wedatasphere.dss.standard.app.development.ref.RefJobContentRequestRef;
import com.webank.wedatasphere.dss.standard.app.development.service.DevelopmentService;
import com.webank.wedatasphere.dss.standard.common.entity.ref.ResponseRef;
import com.webank.wedatasphere.dss.standard.common.exception.operation.ExternalOperationFailedException;
import com.webank.wedatasphere.dss.standard.common.exception.operation.ExternalOperationWarnException;
import com.webank.wedatasphere.dss.standard.common.utils.RequestRefUtils;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.exception.WarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevelopmentOperationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevelopmentOperationUtils.class);

    public static <K extends DevelopmentRequestRef, V extends ResponseRef> V tryDevelopmentOperation(Supplier<DevelopmentService> getDevelopmentService, Function<DevelopmentService, DevelopmentOperation> getDevelopmentOperation, Consumer<DSSJobContentRequestRef> jobContentRequestRefConsumer, Consumer<RefJobContentRequestRef> refJobContentRequestRefConsumer, Consumer<DSSContextRequestRef> contextRequestRefConsumer, Consumer<ProjectRefRequestRef> projectRefRequestRefConsumer, BiFunction<DevelopmentOperation, K, V> requestRefOperationFunction, BiConsumer<K, V> responseRefConsumer, String errorMsg) {
        ResponseRef responseRef;
        DevelopmentService developmentService = getDevelopmentService.get();
        if (developmentService == null) {
            LOGGER.error("{} failed. Caused by: The AppConn has no DevelopmentService.", (Object)errorMsg);
            throw new ExternalOperationWarnException(60092, errorMsg + " failed. Caused by: The AppConn has no DevelopmentService.");
        }
        DevelopmentOperation operation = getDevelopmentOperation.apply(developmentService);
        if (operation == null) {
            LOGGER.error("{} failed. Caused by: The corresponding development operation is not exists.", (Object)errorMsg);
            throw new ExternalOperationWarnException(60092, errorMsg + " failed. Caused by: The AppConn has no corresponding development operation.");
        }
        DevelopmentRequestRef requestRef = (DevelopmentRequestRef)RequestRefUtils.getRequestRef((Object)operation);
        if (jobContentRequestRefConsumer != null && requestRef instanceof DSSJobContentRequestRef) {
            jobContentRequestRefConsumer.accept((DSSJobContentRequestRef)requestRef);
        }
        if (refJobContentRequestRefConsumer != null && requestRef instanceof RefJobContentRequestRef) {
            refJobContentRequestRefConsumer.accept((RefJobContentRequestRef)requestRef);
        }
        if (contextRequestRefConsumer != null && requestRef instanceof DSSContextRequestRef) {
            contextRequestRefConsumer.accept((DSSContextRequestRef)requestRef);
        }
        if (projectRefRequestRefConsumer != null && requestRef instanceof ProjectRefRequestRef) {
            projectRefRequestRefConsumer.accept((ProjectRefRequestRef)requestRef);
        }
        try {
            responseRef = (ResponseRef)requestRefOperationFunction.apply(operation, requestRef);
        }
        catch (WarnException e) {
            String error = StringUtils.isBlank((CharSequence)e.getDesc()) ? String.format("%s failed, no detail error returned by this AppConn, please ask admin for help.", errorMsg) : String.format("%s failed. Caused by: %s.", errorMsg, e.getDesc());
            throw new ExternalOperationFailedException(50010, error, (Throwable)e);
        }
        catch (RuntimeException e) {
            String error = String.format("%s failed. Caused by: %s.", errorMsg, ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new ExternalOperationFailedException(50010, error, (Throwable)e);
        }
        if (responseRef.isFailed()) {
            LOGGER.error("{} failed. Caused by: {}.", (Object)errorMsg, (Object)responseRef.getErrorMsg());
            DSSExceptionUtils.dealWarnException((int)61123, (String)String.format("%s failed. Caused by: %s.", errorMsg, responseRef.getErrorMsg()), ExternalOperationWarnException.class);
        }
        if (responseRefConsumer != null) {
            responseRefConsumer.accept(requestRef, responseRef);
        }
        return (V)responseRef;
    }

    public static <K extends DevelopmentRequestRef, V extends ResponseRef> V tryDevelopmentOperation(Supplier<DevelopmentService> getDevelopmentService, Function<DevelopmentService, DevelopmentOperation> getDevelopmentOperation, Consumer<DSSJobContentRequestRef> jobContentRequestRefConsumer, Consumer<RefJobContentRequestRef> refJobContentRequestRefConsumer, Consumer<DSSContextRequestRef> contextRequestRefConsumer, Consumer<ProjectRefRequestRef> projectRefRequestRefConsumer, BiFunction<DevelopmentOperation, K, V> requestRefOperationFunction, String errorMsg) {
        return DevelopmentOperationUtils.tryDevelopmentOperation(getDevelopmentService, getDevelopmentOperation, jobContentRequestRefConsumer, refJobContentRequestRefConsumer, contextRequestRefConsumer, projectRefRequestRefConsumer, requestRefOperationFunction, null, errorMsg);
    }

    public static <K extends DevelopmentRequestRef, V extends ResponseRef> V tryRefJobContentRequestRefOperation(Supplier<DevelopmentService> getDevelopmentService, Function<DevelopmentService, DevelopmentOperation> getDevelopmentOperation, Consumer<RefJobContentRequestRef> refJobContentRequestRefConsumer, Consumer<DSSContextRequestRef> contextRequestRefConsumer, Consumer<ProjectRefRequestRef> projectRefRequestRefConsumer, BiFunction<DevelopmentOperation, K, V> responseRefConsumer, String errorMsg) {
        return DevelopmentOperationUtils.tryDevelopmentOperation(getDevelopmentService, getDevelopmentOperation, null, refJobContentRequestRefConsumer, contextRequestRefConsumer, projectRefRequestRefConsumer, responseRefConsumer, errorMsg);
    }

    public static <K extends DevelopmentRequestRef, V extends ResponseRef> V tryDSSJobContentRequestRefOperation(Supplier<DevelopmentService> getDevelopmentService, Function<DevelopmentService, DevelopmentOperation> getDevelopmentOperation, Consumer<DSSJobContentRequestRef> jobContentRequestRefConsumer, Consumer<DSSContextRequestRef> contextRequestRefConsumer, Consumer<ProjectRefRequestRef> projectRefRequestRefConsumer, BiFunction<DevelopmentOperation, K, V> responseRefConsumer, String errorMsg) {
        return DevelopmentOperationUtils.tryDevelopmentOperation(getDevelopmentService, getDevelopmentOperation, jobContentRequestRefConsumer, null, contextRequestRefConsumer, projectRefRequestRefConsumer, responseRefConsumer, errorMsg);
    }

    public static <K extends DevelopmentRequestRef, V extends ResponseRef> V tryDevelopmentRequestRefOperation(Supplier<DevelopmentService> getDevelopmentService, Function<DevelopmentService, DevelopmentOperation> getDevelopmentOperation, Consumer<DSSContextRequestRef> contextRequestRefConsumer, Consumer<ProjectRefRequestRef> projectRefRequestRefConsumer, BiFunction<DevelopmentOperation, K, V> responseRefConsumer, String errorMsg) {
        return DevelopmentOperationUtils.tryDevelopmentOperation(getDevelopmentService, getDevelopmentOperation, null, null, contextRequestRefConsumer, projectRefRequestRefConsumer, responseRefConsumer, errorMsg);
    }
}

