/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.common.utils;

import com.webank.wedatasphere.dss.common.exception.DSSErrorException;
import com.webank.wedatasphere.dss.common.utils.FileHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipHelper {
    private static final Logger logger = LoggerFactory.getLogger(ZipHelper.class);
    private static final String ZIP_CMD = "zip";
    private static final String UN_ZIP_CMD = "unzip";
    private static final String RECURSIVE = "-r";
    private static final String ZIP_TYPE = ".zip";

    public static String zip(String dirPath) throws DSSErrorException {
        return ZipHelper.zip(dirPath, true);
    }

    public static String zip(String dirPath, boolean deleteOriginDir) throws DSSErrorException {
        BufferedReader errorReader;
        BufferedReader infoReader;
        String longZipFilePath;
        block14: {
            if (!FileHelper.checkDirExists(dirPath)) {
                logger.error("{} \u4e0d\u5b58\u5728, \u4e0d\u80fd\u521b\u5efazip\u6587\u4ef6", (Object)dirPath);
                throw new DSSErrorException(90001, dirPath + " does not exist, can not zip");
            }
            String[] strArr = dirPath.split(File.separator);
            String shortPath = strArr[strArr.length - 1];
            String workPath = dirPath.substring(0, dirPath.length() - shortPath.length() - 1);
            ArrayList<String> list = new ArrayList<String>();
            list.add(ZIP_CMD);
            list.add(RECURSIVE);
            String zipFilePath = shortPath + ZIP_TYPE;
            longZipFilePath = dirPath + ZIP_TYPE;
            list.add(zipFilePath);
            list.add(shortPath);
            ProcessBuilder processBuilder = new ProcessBuilder(list);
            processBuilder.redirectErrorStream(true);
            processBuilder.directory(new File(workPath));
            infoReader = null;
            errorReader = null;
            try {
                Process process = processBuilder.start();
                infoReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                String infoLine = null;
                while ((infoLine = infoReader.readLine()) != null) {
                    logger.info("process output: {} ", (Object)infoLine);
                }
                String errorLine = null;
                StringBuilder errMsg = new StringBuilder();
                while ((errorLine = errorReader.readLine()) != null) {
                    if (StringUtils.isNotEmpty((String)errorLine)) {
                        errMsg.append(errorLine).append("\n");
                    }
                    logger.error("process error: {} ", (Object)errorLine);
                }
                int exitCode = process.waitFor();
                if (exitCode == 0) break block14;
                throw new DSSErrorException(90002, errMsg.toString());
            }
            catch (Exception e) {
                try {
                    logger.error("{} \u538b\u7f29\u6210 zip \u6587\u4ef6\u5931\u8d25, reason: ", (Throwable)e);
                    DSSErrorException exception = new DSSErrorException(90003, dirPath + " to zip file failed");
                    exception.initCause(e);
                    throw exception;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(infoReader);
                    IOUtils.closeQuietly(errorReader);
                    if (deleteOriginDir) {
                        File file = new File(dirPath);
                        logger.info("\u751f\u6210zip\u6587\u4ef6{}", (Object)longZipFilePath);
                        logger.info("\u5f00\u59cb\u5220\u9664\u76ee\u5f55 {}", (Object)dirPath);
                        if (ZipHelper.deleteDir(file)) {
                            logger.info("\u7ed3\u675f\u5220\u9664\u76ee\u5f55 {} \u6210\u529f", (Object)dirPath);
                        } else {
                            logger.info("\u5220\u9664\u76ee\u5f55 {} \u5931\u8d25", (Object)dirPath);
                        }
                    }
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((Reader)infoReader);
        IOUtils.closeQuietly((Reader)errorReader);
        if (deleteOriginDir) {
            File file = new File(dirPath);
            logger.info("\u751f\u6210zip\u6587\u4ef6{}", (Object)longZipFilePath);
            logger.info("\u5f00\u59cb\u5220\u9664\u76ee\u5f55 {}", (Object)dirPath);
            if (ZipHelper.deleteDir(file)) {
                logger.info("\u7ed3\u675f\u5220\u9664\u76ee\u5f55 {} \u6210\u529f", (Object)dirPath);
            } else {
                logger.info("\u5220\u9664\u76ee\u5f55 {} \u5931\u8d25", (Object)dirPath);
            }
        }
        return longZipFilePath;
    }

    public static String unzip(String dirPath) throws DSSErrorException {
        File file = new File(dirPath);
        if (!file.exists()) {
            logger.error("{} \u4e0d\u5b58\u5728, \u4e0d\u80fd\u89e3\u538bzip\u6587\u4ef6", (Object)dirPath);
            throw new DSSErrorException(90001, dirPath + " does not exist, can not unzip");
        }
        String[] strArr = dirPath.split(File.separator);
        String shortPath = strArr[strArr.length - 1];
        String workPath = dirPath.substring(0, dirPath.length() - shortPath.length() - 1);
        ArrayList<String> list = new ArrayList<String>();
        list.add(UN_ZIP_CMD);
        String longZipFilePath = dirPath.replace(ZIP_TYPE, "");
        list.add(shortPath);
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(new File(workPath));
        BufferedReader infoReader = null;
        BufferedReader errorReader = null;
        try {
            Process process = processBuilder.start();
            infoReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String infoLine = null;
            while ((infoLine = infoReader.readLine()) != null) {
                logger.info("process output: {} ", (Object)infoLine);
            }
            String errorLine = null;
            StringBuilder errMsg = new StringBuilder();
            while ((errorLine = errorReader.readLine()) != null) {
                if (StringUtils.isNotEmpty((String)errorLine)) {
                    errMsg.append(errorLine).append("\n");
                }
                logger.error("process error: {} ", (Object)errorLine);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new DSSErrorException(90007, errMsg.toString());
            }
        }
        catch (Exception e) {
            try {
                logger.error("{} \u89e3\u538b\u7f29 zip \u6587\u4ef6\u5931\u8d25, reason: ", (Throwable)e);
                DSSErrorException exception = new DSSErrorException(90009, dirPath + " to zip file failed");
                exception.initCause(e);
                throw exception;
            }
            catch (Throwable throwable) {
                logger.info("\u751f\u6210\u89e3\u538b\u76ee\u5f55{}", (Object)longZipFilePath);
                IOUtils.closeQuietly(infoReader);
                IOUtils.closeQuietly(errorReader);
                throw throwable;
            }
        }
        logger.info("\u751f\u6210\u89e3\u538b\u76ee\u5f55{}", (Object)longZipFilePath);
        IOUtils.closeQuietly((Reader)infoReader);
        IOUtils.closeQuietly((Reader)errorReader);
        return longZipFilePath;
    }

    private static boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null && children.length > 0) {
            for (String s : children) {
                boolean success = ZipHelper.deleteDir(new File(dir, s));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String zipExportProject(String projectPath) throws DSSErrorException {
        if (projectPath.endsWith(File.separator)) {
            projectPath = projectPath.substring(0, projectPath.lastIndexOf(File.separator));
        }
        return ZipHelper.zip(projectPath);
    }
}

