/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.common.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileHelper.class);

    public static boolean checkDirExists(String dir) {
        File file = new File(dir);
        return file.exists() && file.isDirectory();
    }

    public static void getAllFileNames(String path, List<String> fileNameList) {
        File file = new File(path);
        File[] files = file.listFiles();
        String[] names = file.list();
        if (names != null) {
            String[] completeNames = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                completeNames[i] = path + names[i];
            }
            fileNameList.addAll(Arrays.asList(completeNames));
        }
        for (File tmpFile : files) {
            if (!tmpFile.isDirectory()) continue;
            FileHelper.getAllFileNames(tmpFile.getAbsolutePath() + File.separator, fileNameList);
        }
    }

    public static String readFile(String filename) {
        StringBuffer fileContent = new StringBuffer();
        try (FileInputStream fis = new FileInputStream(filename);
             BufferedInputStream bufferedInput = new BufferedInputStream(fis);){
            int bytesRead = 0;
            byte[] buffer = new byte[1024];
            while ((bytesRead = bufferedInput.read(buffer)) != -1) {
                String tmpContent = new String(buffer, 0, bytesRead);
                fileContent.append(tmpContent);
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.error("\uff0c\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)filename, (Object)ex);
        }
        catch (IOException e) {
            LOGGER.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)filename, (Object)e);
        }
        return fileContent.toString();
    }
}

