/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.common.label;

import com.webank.wedatasphere.dss.common.label.DSSLabel;
import com.webank.wedatasphere.dss.common.label.EnvDSSLabel;
import com.webank.wedatasphere.dss.common.label.LabelInstanceFactory;
import com.webank.wedatasphere.dss.common.label.LabelKeyConvertor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DSSLabelUtil {
    private static Map<String, Object> consltructLabelMap(String label) {
        HashMap<String, Object> labelMap = new HashMap<String, Object>();
        labelMap.put(LabelKeyConvertor.ROUTE_LABEL_KEY, label);
        return labelMap;
    }

    public static List<DSSLabel> createLabelList(String label) {
        Map<String, Object> labelParam = DSSLabelUtil.consltructLabelMap(label);
        LabelInstanceFactory labelInstanceFactory = new LabelInstanceFactory(labelParam);
        List<DSSLabel> dssLabelList = labelInstanceFactory.getLabelList();
        return dssLabelList;
    }

    public static EnvDSSLabel createLabel(String label) {
        Map<String, Object> labelParam = DSSLabelUtil.consltructLabelMap(label);
        LabelInstanceFactory labelInstanceFactory = new LabelInstanceFactory(labelParam);
        EnvDSSLabel envDSSLabel = labelInstanceFactory.getEnvDssLabel();
        return envDSSLabel;
    }

    public static boolean isDevEnv(List<DSSLabel> dssLabels) {
        for (DSSLabel dssLabel : dssLabels) {
            String userEnv = null;
            userEnv = dssLabel instanceof EnvDSSLabel ? ((EnvDSSLabel)dssLabel).getEnv() : (String)((Map)dssLabel.getValue()).get(dssLabel.getLabelKey());
            if (!"dev".equalsIgnoreCase(userEnv)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        List<DSSLabel> labelList = DSSLabelUtil.createLabelList("dev");
        System.out.println(labelList.size());
    }
}

